/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.service.context;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Map;

public class ServiceContextUtil {
    public static ServiceContext createServiceContext(long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(new Long[0], new String[0], groupId, viewableBy);
    }

    public static ServiceContext createServiceContext(Long[] assetCategoryIds, String[] assetTagNames, Long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(assetCategoryIds, assetTagNames, null, groupId, viewableBy);
    }

    public static ServiceContext createServiceContext(Long[] assetCategoryIds, String[] assetTagNames, Map<String, Serializable> expandoBridgeAttributes, Long groupId, String viewableBy) {
        ServiceContext serviceContext = new ServiceContext();
        if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"anyone")) {
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
        } else if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"members")) {
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(false);
        } else {
            serviceContext.setAddGroupPermissions(false);
            serviceContext.setAddGuestPermissions(false);
        }
        if (assetCategoryIds != null) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toArray((Long[])assetCategoryIds));
        }
        if (assetTagNames != null) {
            serviceContext.setAssetTagNames(assetTagNames);
        }
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        if (groupId != null) {
            serviceContext.setScopeGroupId(groupId.longValue());
        }
        return serviceContext;
    }

    public static ServiceContext createServiceContext(Map<String, Serializable> expandoBridgeAttributes, long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(new Long[0], new String[0], expandoBridgeAttributes, groupId, viewableBy);
    }
}

