/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.resource;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;

public class SPIRatingResource<T> {
    private final String _className;
    private final RatingsEntryLocalService _ratingsEntryLocalService;
    private final UnsafeFunction<RatingsEntry, T, Exception> _transformUnsafeFunction;
    private final User _user;

    public SPIRatingResource(String className, RatingsEntryLocalService ratingsEntryLocalService, UnsafeFunction<RatingsEntry, T, Exception> transformUnsafeFunction, User user) {
        this._className = className;
        this._ratingsEntryLocalService = ratingsEntryLocalService;
        this._transformUnsafeFunction = transformUnsafeFunction;
        this._user = user;
    }

    public T addOrUpdateRating(Number ratingValue, long classPK) throws Exception {
        this._checkPermission();
        return (T)this._transformUnsafeFunction.apply((Object)this._ratingsEntryLocalService.updateEntry(this._user.getUserId(), this._className, classPK, GetterUtil.getDouble((Object)ratingValue), new ServiceContext()));
    }

    public void deleteRating(Long classPK) throws Exception {
        this._checkPermission();
        this._ratingsEntryLocalService.deleteEntry(this._user.getUserId(), this._className, classPK.longValue());
    }

    public T getRating(Long classPK) throws Exception {
        return (T)this._transformUnsafeFunction.apply((Object)this._ratingsEntryLocalService.getEntry(this._user.getUserId(), this._className, classPK.longValue()));
    }

    private void _checkPermission() throws Exception {
        if (this._user.isDefaultUser()) {
            throw new PrincipalException();
        }
    }
}

