/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.builder.application;

import com.liferay.portal.kernel.util.Http;
import java.util.List;
import java.util.Objects;

public interface APIApplication {
    public String getBaseURL();

    public long getCompanyId();

    public String getDescription();

    public List<Endpoint> getEndpoints();

    public List<Schema> getSchemas();

    public String getTitle();

    public String getVersion();

    public static interface Sort {
        public String getODataSortString();
    }

    public static interface Schema {
        public String getDescription();

        public String getExternalReferenceCode();

        public String getMainObjectDefinitionExternalReferenceCode();

        public String getName();

        public List<Property> getProperties();
    }

    public static interface Property {
        public String getDescription();

        public String getExternalReferenceCode();

        public String getName();

        public List<String> getObjectRelationshipNames();

        public List<Property> getProperties();

        public String getSourceFieldName();

        public Type getType();

        public static enum Type {
            AGGREGATION,
            ATTACHMENT,
            BOOLEAN,
            DATE,
            DATE_TIME,
            DECIMAL,
            INTEGER,
            LONG_INTEGER,
            LONG_TEXT,
            MULTISELECT_PICKLIST,
            PICKLIST,
            PRECISION_DECIMAL,
            RECORD,
            RICH_TEXT,
            TEXT;

        }
    }

    public static interface Filter {
        public String getODataFilterString();
    }

    public static interface Endpoint {
        public Filter getFilter();

        public Http.Method getMethod();

        public String getPath();

        public String getPathParameter();

        public Schema getRequestSchema();

        public Schema getResponseSchema();

        public RetrieveType getRetrieveType();

        public Scope getScope();

        public Sort getSort();

        public static enum Scope {
            COMPANY("company"),
            SITE("site");

            private final String _value;

            public static Scope parse(String value) {
                for (Scope scope : Scope.values()) {
                    if (!Objects.equals(scope.getValue(), value)) continue;
                    return scope;
                }
                throw new IllegalArgumentException("Invalid value " + value);
            }

            public String getValue() {
                return this._value;
            }

            private Scope(String value) {
                this._value = value;
            }
        }

        public static enum RetrieveType {
            COLLECTION("collection"),
            SINGLE_ELEMENT("singleElement");

            private final String _value;

            public static RetrieveType parse(String value) {
                for (RetrieveType retrieveType : RetrieveType.values()) {
                    if (!Objects.equals(retrieveType.getValue(), value)) continue;
                    return retrieveType;
                }
                throw new IllegalArgumentException("Invalid value " + value);
            }

            public String getValue() {
                return this._value;
            }

            private RetrieveType(String value) {
                this._value = value;
            }
        }
    }
}

