/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.internal.resource.v1_0;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.configuration.BatchEngineTaskCompanyConfiguration;
import com.liferay.batch.engine.constants.BatchEngineImportTaskConstants;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.model.BatchEngineImportTaskError;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.headless.batch.engine.dto.v1_0.FailedItem;
import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.internal.resource.v1_0.BaseImportTaskResourceImpl;
import com.liferay.headless.batch.engine.internal.resource.v1_0.util.ParametersUtil;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/import-task.properties"}, property={"batch.engine=true"}, scope=ServiceScope.PROTOTYPE, service={ImportTaskResource.class})
public class ImportTaskResourceImpl
extends BaseImportTaskResourceImpl {
    private static final Set<String> _ignoredParameters = new HashSet<String>(Arrays.asList("callbackURL", "fieldNameMapping"));
    @Reference
    private BatchEngineImportTaskErrorLocalService _batchEngineImportTaskErrorLocalService;
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private File _file;
    private final Map<String, Integer> _itemClassBatchSizeMap = new HashMap<String, Integer>();
    @Reference
    private ItemClassRegistry _itemClassRegistry;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    @Override
    public ImportTask deleteImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.DELETE, multipartBody.getBinaryFile("file"), callbackURL, className, null, externalReferenceCode, null, importStrategy, taskItemDelegateName, null);
    }

    @Override
    public ImportTask deleteImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.DELETE, this._getBytes(object, contentType), callbackURL, className, null, this._getBatchEngineTaskContentType(contentType), externalReferenceCode, null, importStrategy, taskItemDelegateName, null);
    }

    @Override
    public ImportTask getImportTask(Long importTaskId) throws Exception {
        return this._toImportTask(this._batchEngineImportTaskLocalService.getBatchEngineImportTask(importTaskId.longValue()));
    }

    @Override
    public ImportTask getImportTaskByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toImportTask(this._batchEngineImportTaskLocalService.getBatchEngineImportTaskByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()));
    }

    @Override
    public Response getImportTaskByExternalReferenceCodeContent(String externalReferenceCode) throws Exception {
        return this._getImportTaskContent(this._batchEngineImportTaskLocalService.getBatchEngineImportTaskByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()));
    }

    @Override
    public Response getImportTaskByExternalReferenceCodeFailedItemReport(String externalReferenceCode) throws Exception {
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.getBatchEngineImportTaskByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this._getImportTaskFailedItemReport(batchEngineImportTask.getBatchEngineImportTaskId());
    }

    @Override
    public Response getImportTaskContent(Long importTaskId) throws Exception {
        return this._getImportTaskContent(this._batchEngineImportTaskLocalService.getBatchEngineImportTask(importTaskId.longValue()));
    }

    @Override
    public Response getImportTaskFailedItemReport(Long importTaskId) throws Exception {
        return this._getImportTaskFailedItemReport(importTaskId);
    }

    @Override
    public ImportTask postImportTask(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.CREATE, multipartBody.getBinaryFile("file"), callbackURL, className, createStrategy, externalReferenceCode, fieldNameMapping, importStrategy, taskItemDelegateName, null);
    }

    @Override
    public ImportTask postImportTask(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.CREATE, this._getBytes(object, contentType), callbackURL, className, createStrategy, this._getBatchEngineTaskContentType(contentType), externalReferenceCode, fieldNameMapping, importStrategy, taskItemDelegateName, null);
    }

    @Override
    public ImportTask putImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.UPDATE, multipartBody.getBinaryFile("file"), callbackURL, className, null, externalReferenceCode, null, importStrategy, taskItemDelegateName, updateStrategy);
    }

    @Override
    public ImportTask putImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, Object object) throws Exception {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.UPDATE, this._getBytes(object, contentType), callbackURL, className, null, this._getBatchEngineTaskContentType(contentType), externalReferenceCode, null, importStrategy, taskItemDelegateName, updateStrategy);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        Properties batchSizeProperties = PropsUtil.getProperties((String)"batch.size.", (boolean)true);
        for (Map.Entry<Object, Object> entry : batchSizeProperties.entrySet()) {
            this._itemClassBatchSizeMap.put(String.valueOf(entry.getKey()), GetterUtil.getInteger((Object)entry.getValue()));
        }
    }

    private String _getBatchEngineTaskContentType(String contentType) {
        if (contentType.equals("application/json")) {
            return String.valueOf(BatchEngineTaskContentType.JSON);
        }
        if (contentType.equals("application/x-ndjson")) {
            return String.valueOf(BatchEngineTaskContentType.JSONL);
        }
        if (contentType.equals("text/csv")) {
            return String.valueOf(BatchEngineTaskContentType.CSV);
        }
        return contentType;
    }

    private byte[] _getBytes(Object object, String contentType) throws Exception {
        byte[] bytes = null;
        if (contentType.equals("application/json")) {
            ObjectMapper objectMapper = new ObjectMapper();
            bytes = objectMapper.writeValueAsBytes(object);
        } else {
            String content = (String)object;
            bytes = content.getBytes();
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this._getUnsyncByteArrayOutputStream("fileName", new ByteArrayInputStream(bytes));
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private Map.Entry<byte[], String> _getContentAndExtensionFromCompressedFile(InputStream inputStream) throws Exception {
        byte[] content = StreamUtil.toByteArray((InputStream)inputStream);
        String fileName = null;
        try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new UnsyncByteArrayInputStream(content));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            fileName = zipEntry.getName();
        }
        return new AbstractMap.SimpleImmutableEntry<byte[], String>(content, this._file.getExtension(fileName));
    }

    private Map.Entry<byte[], String> _getContentAndExtensionFromUncompressedFile(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this._getUnsyncByteArrayOutputStream(fileName, inputStream);
        return new AbstractMap.SimpleImmutableEntry<byte[], String>(unsyncByteArrayOutputStream.toByteArray(), this._file.getExtension(fileName));
    }

    private int _getImportBatchSize(long companyId) throws Exception {
        BatchEngineTaskCompanyConfiguration batchEngineTaskCompanyConfiguration = (BatchEngineTaskCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId);
        return batchEngineTaskCompanyConfiguration.importBatchSize();
    }

    private Response _getImportTaskContent(BatchEngineImportTask batchEngineImportTask) {
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus != BatchEngineTaskExecuteStatus.COMPLETED && batchEngineTaskExecuteStatus != BatchEngineTaskExecuteStatus.FAILED) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput streamingOutput = outputStream -> StreamUtil.transfer((InputStream)this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId()), (OutputStream)outputStream);
        return Response.ok((Object)streamingOutput).header("content-disposition", (Object)("attachment; filename=" + StringUtil.randomString() + ".zip")).build();
    }

    private Response _getImportTaskFailedItemReport(long importTaskId) {
        StreamingOutput streamingOutput = outputStream -> {
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter(outputStream)), CSVFormat.DEFAULT);){
                csvPrinter.printRecord(new Object[]{"item", "itemIndex", "message"});
                for (BatchEngineImportTaskError batchEngineImportTaskError : this._batchEngineImportTaskErrorLocalService.getBatchEngineImportTaskErrors(importTaskId)) {
                    csvPrinter.printRecord(new Object[]{batchEngineImportTaskError.getItem(), batchEngineImportTaskError.getItemIndex(), batchEngineImportTaskError.getMessage()});
                }
            }
        };
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)("attachment; filename=" + StringUtil.randomString() + ".csv")).build();
    }

    private UnsyncByteArrayOutputStream _getUnsyncByteArrayOutputStream(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream;
    }

    private ImportTask _importFile(BatchEngineTaskOperation batchEngineTaskOperation, BinaryFile binaryFile, String callbackURL, String className, String createStrategy, String externalReferenceCode, String fieldNameMappingString, String importStrategy, String taskItemDelegateName, String updateStrategy) throws Exception {
        Map.Entry<byte[], String> entry = null;
        entry = StringUtil.endsWith((String)binaryFile.getFileName(), (String)"zip") ? this._getContentAndExtensionFromCompressedFile(binaryFile.getInputStream()) : this._getContentAndExtensionFromUncompressedFile(binaryFile.getFileName(), binaryFile.getInputStream());
        return this._importFile(batchEngineTaskOperation, entry.getKey(), callbackURL, className, createStrategy, entry.getValue(), externalReferenceCode, fieldNameMappingString, importStrategy, taskItemDelegateName, updateStrategy);
    }

    private ImportTask _importFile(BatchEngineTaskOperation batchEngineTaskOperation, byte[] bytes, String callbackURL, String className, String createStrategy, String batchEngineTaskContentType, String externalReferenceCode, String fieldNameMappingString, String importStrategy, String taskItemDelegateName, String updateStrategy) throws Exception {
        Class clazz = this._itemClassRegistry.getItemClass(className);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown class name: " + className);
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(ImportTaskResourceImpl.class.getName());
        Map<String, Serializable> parameters = ParametersUtil.toParameters(this.contextUriInfo, _ignoredParameters);
        if (createStrategy != null) {
            parameters.put("createStrategy", (Serializable)((Object)createStrategy));
        }
        if (updateStrategy != null) {
            parameters.put("updateStrategy", (Serializable)((Object)updateStrategy));
        }
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(externalReferenceCode, this.contextCompany.getCompanyId(), this.contextUser.getUserId(), (long)this._itemClassBatchSizeMap.getOrDefault(className, this._getImportBatchSize(this.contextCompany.getCompanyId())).intValue(), callbackURL, className, bytes, StringUtil.upperCase((String)batchEngineTaskContentType), BatchEngineTaskExecuteStatus.INITIAL.name(), this._toMap(fieldNameMappingString), this._toImportStrategy(importStrategy), batchEngineTaskOperation.name(), parameters, taskItemDelegateName);
        executorService.submit(() -> this._batchEngineImportTaskExecutor.execute(batchEngineImportTask));
        return this._toImportTask(batchEngineImportTask);
    }

    private FailedItem _toFailedItem(final BatchEngineImportTaskError batchEngineImportTaskError) {
        return new FailedItem(){
            {
                this.item = batchEngineImportTaskError.getItem();
                this.itemIndex = batchEngineImportTaskError.getItemIndex();
                this.message = batchEngineImportTaskError.getMessage();
            }
        };
    }

    private int _toImportStrategy(String importStrategy) {
        if (importStrategy == null || importStrategy.equals("ON_ERROR_FAIL")) {
            return 2;
        }
        return 1;
    }

    private ImportTask _toImportTask(final BatchEngineImportTask batchEngineImportTask) {
        return new ImportTask(){
            {
                this.className = batchEngineImportTask.getClassName();
                this.contentType = batchEngineImportTask.getContentType();
                this.endTime = batchEngineImportTask.getEndTime();
                this.errorMessage = batchEngineImportTask.getErrorMessage();
                this.executeStatus = ImportTask.ExecuteStatus.create((String)batchEngineImportTask.getExecuteStatus());
                this.externalReferenceCode = batchEngineImportTask.getExternalReferenceCode();
                this.failedItems = (FailedItem[])ImportTaskResourceImpl.this.transformToArray(batchEngineImportTask.getBatchEngineImportTaskErrors(), batchEngineImportTaskError -> ImportTaskResourceImpl.this._toFailedItem(batchEngineImportTaskError), FailedItem.class);
                this.id = batchEngineImportTask.getBatchEngineImportTaskId();
                this.importStrategy = ImportTask.ImportStrategy.create((String)BatchEngineImportTaskConstants.getImportStrategyString((int)batchEngineImportTask.getImportStrategy()));
                this.operation = ImportTask.Operation.create((String)batchEngineImportTask.getOperation());
                this.processedItemsCount = batchEngineImportTask.getProcessedItemsCount();
                this.startTime = batchEngineImportTask.getStartTime();
                this.totalItemsCount = batchEngineImportTask.getTotalItemsCount();
            }
        };
    }

    private Map<String, String> _toMap(String fieldNameMappingString) {
        String[] fieldNameMappings;
        if (Validator.isNull((String)fieldNameMappingString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fieldNameMappingMap = new HashMap<String, String>();
        for (String fieldNameMapping : fieldNameMappings = StringUtil.split((String)fieldNameMappingString, (char)',')) {
            String[] fieldNames = StringUtil.split((String)fieldNameMapping, (char)'=');
            fieldNameMappingMap.put(fieldNames[0], fieldNames[1]);
        }
        return fieldNameMappingMap;
    }
}

