/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.internal.resource.v1_0;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.internal.resource.v1_0.BaseImportTaskResourceImpl;
import com.liferay.headless.batch.engine.internal.resource.v1_0.util.ParametersUtil;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, properties={"OSGI-INF/liferay/rest/v1_0/import-task.properties"}, property={"batch.engine=true"}, scope=ServiceScope.PROTOTYPE, service={ImportTaskResource.class})
public class ImportTaskResourceImpl
extends BaseImportTaskResourceImpl {
    private static final Set<String> _ignoredParameters = new HashSet<String>(Arrays.asList("callbackURL", "fieldNameMapping"));
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private int _batchSize;
    @Reference
    private File _file;
    private final Map<String, Integer> _itemClassBatchSizeMap = new HashMap<String, Integer>();
    @Reference
    private ItemClassRegistry _itemClassRegistry;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    @Override
    public ImportTask deleteImportTask(String className, String callbackURL, String taskItemDelegateName, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.DELETE, multipartBody.getBinaryFile("file"), callbackURL, className, null, taskItemDelegateName);
    }

    @Override
    public ImportTask deleteImportTask(String className, String callbackURL, String taskItemDelegateName, Object object) throws IOException {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.DELETE, this._getBytes(object, contentType), callbackURL, className, this._getBatchEngineTaskContentType(contentType), taskItemDelegateName, null);
    }

    @Override
    public ImportTask getImportTask(Long importTaskId) throws Exception {
        return this._toImportTask(this._batchEngineImportTaskLocalService.getBatchEngineImportTask(importTaskId.longValue()));
    }

    @Override
    public ImportTask postImportTask(String className, String callbackURL, String fieldNameMapping, String taskItemDelegateName, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.CREATE, multipartBody.getBinaryFile("file"), callbackURL, className, fieldNameMapping, taskItemDelegateName);
    }

    @Override
    public ImportTask postImportTask(String className, String callbackURL, String fieldNameMapping, String taskItemDelegateName, Object object) throws Exception {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.CREATE, this._getBytes(object, contentType), callbackURL, className, this._getBatchEngineTaskContentType(contentType), fieldNameMapping, taskItemDelegateName);
    }

    @Override
    public ImportTask putImportTask(String className, String callbackURL, String taskItemDelegateName, MultipartBody multipartBody) throws Exception {
        return this._importFile(BatchEngineTaskOperation.UPDATE, multipartBody.getBinaryFile("file"), callbackURL, className, null, taskItemDelegateName);
    }

    @Override
    public ImportTask putImportTask(String className, String callbackURL, String taskItemDelegateName, Object object) throws Exception {
        String contentType = this.contextHttpServletRequest.getHeader("Content-Type");
        return this._importFile(BatchEngineTaskOperation.UPDATE, this._getBytes(object, contentType), callbackURL, className, this._getBatchEngineTaskContentType(contentType), null, taskItemDelegateName);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._batchSize = batchEngineTaskConfiguration.importBatchSize();
        if (this._batchSize <= 0) {
            this._batchSize = 1;
        }
        Properties batchSizeProperties = PropsUtil.getProperties((String)"batch.size.", (boolean)true);
        for (Map.Entry<Object, Object> entry : batchSizeProperties.entrySet()) {
            this._itemClassBatchSizeMap.put(String.valueOf(entry.getKey()), GetterUtil.getInteger((Object)entry.getValue()));
        }
    }

    private String _getBatchEngineTaskContentType(String contentType) {
        if (contentType.equals("application/json")) {
            return String.valueOf(BatchEngineTaskContentType.JSON);
        }
        if (contentType.equals("application/x-ndjson")) {
            return String.valueOf(BatchEngineTaskContentType.JSONL);
        }
        if (contentType.equals("text/csv")) {
            return String.valueOf(BatchEngineTaskContentType.CSV);
        }
        return contentType;
    }

    private byte[] _getBytes(Object object, String contentType) throws IOException {
        byte[] bytes = null;
        if (contentType.equals("application/json")) {
            ObjectMapper objectMapper = new ObjectMapper();
            bytes = objectMapper.writeValueAsBytes(object);
        } else {
            String content = (String)object;
            bytes = content.getBytes();
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this._getUnsyncByteArrayOutputStream("fileName", new ByteArrayInputStream(bytes));
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private Map.Entry<byte[], String> _getContentAndExtensionFromCompressedFile(InputStream inputStream) throws IOException {
        byte[] content = StreamUtil.toByteArray((InputStream)inputStream);
        String fileName = null;
        try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new UnsyncByteArrayInputStream(content));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            fileName = zipEntry.getName();
        }
        return new AbstractMap.SimpleImmutableEntry<byte[], String>(content, this._file.getExtension(fileName));
    }

    private Map.Entry<byte[], String> _getContentAndExtensionFromUncompressedFile(String fileName, InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = this._getUnsyncByteArrayOutputStream(fileName, inputStream);
        return new AbstractMap.SimpleImmutableEntry<byte[], String>(unsyncByteArrayOutputStream.toByteArray(), this._file.getExtension(fileName));
    }

    private UnsyncByteArrayOutputStream _getUnsyncByteArrayOutputStream(String fileName, InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream;
    }

    private ImportTask _importFile(BatchEngineTaskOperation batchEngineTaskOperation, BinaryFile binaryFile, String callbackURL, String className, String fieldNameMappingString, String taskItemDelegateName) throws Exception {
        Map.Entry<byte[], String> entry = null;
        entry = StringUtil.endsWith((String)binaryFile.getFileName(), (String)"zip") ? this._getContentAndExtensionFromCompressedFile(binaryFile.getInputStream()) : this._getContentAndExtensionFromUncompressedFile(binaryFile.getFileName(), binaryFile.getInputStream());
        return this._importFile(batchEngineTaskOperation, entry.getKey(), callbackURL, className, entry.getValue(), fieldNameMappingString, taskItemDelegateName);
    }

    private ImportTask _importFile(BatchEngineTaskOperation batchEngineTaskOperation, byte[] bytes, String callbackURL, String className, String batchEngineTaskContentType, String fieldNameMappingString, String taskItemDelegateName) {
        Class clazz = this._itemClassRegistry.getItemClass(className);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown class name: " + className);
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(ImportTaskResourceImpl.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), (long)this._itemClassBatchSizeMap.getOrDefault(className, this._batchSize).intValue(), callbackURL, className, bytes, StringUtil.upperCase((String)batchEngineTaskContentType), BatchEngineTaskExecuteStatus.INITIAL.name(), this._toMap(fieldNameMappingString), batchEngineTaskOperation.name(), ParametersUtil.toParameters(this.contextUriInfo, _ignoredParameters), taskItemDelegateName);
        executorService.submit(() -> this._batchEngineImportTaskExecutor.execute(batchEngineImportTask));
        return this._toImportTask(batchEngineImportTask);
    }

    private ImportTask _toImportTask(final BatchEngineImportTask batchEngineImportTask) {
        return new ImportTask(){
            {
                this.className = batchEngineImportTask.getClassName();
                this.contentType = batchEngineImportTask.getContentType();
                this.endTime = batchEngineImportTask.getEndTime();
                this.errorMessage = batchEngineImportTask.getErrorMessage();
                this.executeStatus = ImportTask.ExecuteStatus.create((String)batchEngineImportTask.getExecuteStatus());
                this.id = batchEngineImportTask.getBatchEngineImportTaskId();
                this.operation = ImportTask.Operation.create((String)batchEngineImportTask.getOperation());
                this.startTime = batchEngineImportTask.getStartTime();
            }
        };
    }

    private Map<String, String> _toMap(String fieldNameMappingString) {
        String[] fieldNameMappings;
        if (Validator.isNull((String)fieldNameMappingString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fieldNameMappingMap = new HashMap<String, String>();
        for (String fieldNameMapping : fieldNameMappings = StringUtil.split((String)fieldNameMappingString, (char)',')) {
            String[] fieldNames = StringUtil.split((String)fieldNameMapping, (char)'=');
            fieldNameMappingMap.put(fieldNames[0], fieldNames[1]);
        }
        return fieldNameMappingMap;
    }
}

