/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.ChangeTransition;
import com.liferay.headless.admin.workflow.dto.v1_0.Role;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTask;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToMe;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToRole;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToUser;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTasksBulkSelection;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.ObjectReviewedUtil;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.RoleUtil;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowTaskResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowTaskResource;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.kernel.workflow.search.WorkflowModelSearchResult;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-task.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowTaskResource.class})
public class WorkflowTaskResourceImpl
extends BaseWorkflowTaskResourceImpl {
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowComparatorFactory _workflowComparatorFactory;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.workflow.WorkflowTask)")
    private ModelResourcePermission<?> _workflowTaskModelResourcePermission;

    @Override
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksAssignedToMePage(Long workflowInstanceId, Boolean completed, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowTaskManager.getWorkflowTasksByWorkflowInstance(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), workflowInstanceId.longValue(), completed, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByWorkflowInstance(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), workflowInstanceId.longValue(), completed));
    }

    @Override
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksAssignedToUserPage(Long workflowInstanceId, Long assigneeId, Boolean completed, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByWorkflowInstance(this.contextCompany.getCompanyId(), assigneeId, workflowInstanceId.longValue(), completed, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByWorkflowInstance(this.contextCompany.getCompanyId(), assigneeId, workflowInstanceId.longValue(), completed));
    }

    @Override
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksPage(Long workflowInstanceId, Boolean completed, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByWorkflowInstance(this.contextCompany.getCompanyId(), null, workflowInstanceId.longValue(), completed, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByWorkflowInstance(this.contextCompany.getCompanyId(), null, workflowInstanceId.longValue(), completed));
    }

    @Override
    public WorkflowTask getWorkflowTask(Long workflowTaskId) throws Exception {
        try {
            return this._toWorkflowTask(this._workflowTaskManager.getWorkflowTask(workflowTaskId.longValue()));
        }
        catch (WorkflowException workflowException) {
            Throwable throwable = workflowException.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw workflowException;
        }
    }

    @Override
    public Boolean getWorkflowTaskHasAssignableUsers(Long workflowTaskId) throws Exception {
        return this._workflowTaskManager.hasAssignableUsers(workflowTaskId.longValue());
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToMePage(Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByUser(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUser(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToMyRolesPage(Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByUserRoles(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUserRoles(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToRolePage(Long roleId, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByRole(this.contextCompany.getCompanyId(), roleId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByRole(this.contextCompany.getCompanyId(), roleId.longValue(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToUserPage(Long assigneeId, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByUser(this.contextCompany.getCompanyId(), assigneeId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUser(this.contextCompany.getCompanyId(), assigneeId.longValue(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToUserRolesPage(Long assigneeId, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksByUserRoles(this.contextCompany.getCompanyId(), assigneeId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUserRoles(this.contextCompany.getCompanyId(), assigneeId.longValue(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksSubmittingUserPage(Long creatorId, Pagination pagination) throws Exception {
        return Page.of(this._getActions(), this.transform(this._workflowTaskManager.getWorkflowTasksBySubmittingUser(this.contextCompany.getCompanyId(), creatorId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountBySubmittingUser(this.contextCompany.getCompanyId(), creatorId.longValue(), null));
    }

    @Override
    public void patchWorkflowTaskAssignToUser(WorkflowTaskAssignToUser[] workflowTaskAssignToUsers) throws Exception {
        try {
            for (WorkflowTaskAssignToUser workflowTaskAssignToUser : workflowTaskAssignToUsers) {
                this._workflowTaskManager.assignWorkflowTaskToUser(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskAssignToUser.getWorkflowTaskId().longValue(), workflowTaskAssignToUser.getAssigneeId().longValue(), workflowTaskAssignToUser.getComment(), workflowTaskAssignToUser.getDueDate(), this._getWorkflowContext(workflowTaskAssignToUser.getWorkflowTaskId()));
            }
        }
        catch (WorkflowException workflowException) {
            Throwable throwable = workflowException.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw workflowException;
        }
    }

    @Override
    public void patchWorkflowTaskChangeTransition(ChangeTransition[] changeTransitions) throws Exception {
        try {
            for (ChangeTransition changeTransition : changeTransitions) {
                this._workflowTaskManager.completeWorkflowTask(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), changeTransition.getWorkflowTaskId().longValue(), changeTransition.getTransitionName(), changeTransition.getComment(), this._getWorkflowContext(changeTransition.getWorkflowTaskId()));
            }
        }
        catch (WorkflowException workflowException) {
            Throwable throwable = workflowException.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw workflowException;
        }
    }

    @Override
    public void patchWorkflowTaskUpdateDueDate(WorkflowTaskAssignToMe[] workflowTaskAssignToMes) throws Exception {
        try {
            for (WorkflowTaskAssignToMe workflowTaskAssignToMe : workflowTaskAssignToMes) {
                this._workflowTaskManager.updateDueDate(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskAssignToMe.getWorkflowTaskId().longValue(), workflowTaskAssignToMe.getComment(), workflowTaskAssignToMe.getDueDate());
            }
        }
        catch (WorkflowException workflowException) {
            Throwable throwable = workflowException.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw workflowException;
        }
    }

    @Override
    public WorkflowTask postWorkflowTaskAssignToMe(Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.assignWorkflowTaskToUser(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskId.longValue(), this.contextUser.getUserId(), workflowTaskAssignToMe.getComment(), workflowTaskAssignToMe.getDueDate(), this._getWorkflowContext(workflowTaskId)));
    }

    @Override
    public WorkflowTask postWorkflowTaskAssignToRole(Long workflowTaskId, WorkflowTaskAssignToRole workflowTaskAssignToRole) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.assignWorkflowTaskToRole(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskId.longValue(), workflowTaskAssignToRole.getRoleId().longValue(), workflowTaskAssignToRole.getComment(), workflowTaskAssignToRole.getDueDate(), this._getWorkflowContext(workflowTaskId)));
    }

    @Override
    public WorkflowTask postWorkflowTaskAssignToUser(Long workflowTaskId, WorkflowTaskAssignToUser workflowTaskAssignToUser) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.assignWorkflowTaskToUser(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskId.longValue(), workflowTaskAssignToUser.getAssigneeId().longValue(), workflowTaskAssignToUser.getComment(), workflowTaskAssignToUser.getDueDate(), this._getWorkflowContext(workflowTaskId)));
    }

    @Override
    public WorkflowTask postWorkflowTaskChangeTransition(Long workflowTaskId, ChangeTransition changeTransition) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.completeWorkflowTask(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskId.longValue(), changeTransition.getTransitionName(), changeTransition.getComment(), this._getWorkflowContext(workflowTaskId)));
    }

    @Override
    public Page<WorkflowTask> postWorkflowTasksPage(Pagination pagination, Sort[] sorts, WorkflowTasksBulkSelection workflowTasksBulkSelection) throws Exception {
        String assigneeClassName = null;
        if (GetterUtil.getBoolean((Object)workflowTasksBulkSelection.getSearchByRoles())) {
            assigneeClassName = com.liferay.portal.kernel.model.Role.class.getName();
        }
        WorkflowModelSearchResult workflowTasks = this._workflowTaskManager.searchWorkflowTasks(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTasksBulkSelection.getAssetTitle(), workflowTasksBulkSelection.getWorkflowTaskNames(), workflowTasksBulkSelection.getAssetTypes(), workflowTasksBulkSelection.getAssetPrimaryKeys(), assigneeClassName, workflowTasksBulkSelection.getAssigneeIds(), workflowTasksBulkSelection.getDateDueStart(), workflowTasksBulkSelection.getDateDueEnd(), workflowTasksBulkSelection.getCompleted(), false, workflowTasksBulkSelection.getSearchByUserRoles(), workflowTasksBulkSelection.getWorkflowDefinitionId(), workflowTasksBulkSelection.getWorkflowInstanceIds(), Boolean.valueOf(GetterUtil.getBoolean((Object)workflowTasksBulkSelection.getAndOperator(), (boolean)true)), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0)));
        return Page.of(this.transform(workflowTasks.getWorkflowModels(), this::_toWorkflowTask), (Pagination)pagination, (long)workflowTasks.getLength());
    }

    @Override
    public WorkflowTask postWorkflowTaskUpdateDueDate(Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.updateDueDate(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowTaskId.longValue(), workflowTaskAssignToMe.getComment(), workflowTaskAssignToMe.getDueDate()));
    }

    private Map<String, Map<String, String>> _getActions() {
        return HashMapBuilder.put((Object)"assignedToMe", this.addAction("VIEW", "getWorkflowTasksAssignedToMePage", "com.liferay.portal.workflow", null)).put((Object)"assignedToRole", this.addAction("VIEW", "getWorkflowTasksAssignedToRolePage", "com.liferay.portal.workflow", null)).put((Object)"assignedToUser", this.addAction("VIEW", "getWorkflowTasksAssignedToUserPage", "com.liferay.portal.workflow", null)).put((Object)"assignedToUserRoles", this.addAction("VIEW", "getWorkflowTasksAssignedToUserRolesPage", "com.liferay.portal.workflow", null)).build();
    }

    private Role[] _getRoles(List<WorkflowTaskAssignee> workflowTaskAssignees) throws Exception {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (WorkflowTaskAssignee workflowTaskAssignee : workflowTaskAssignees) {
            String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
            if (!assigneeClassName.equals(com.liferay.portal.kernel.model.Role.class.getName())) continue;
            roles.add(this._toRole(this._roleLocalService.getRole(workflowTaskAssignee.getAssigneeClassPK())));
        }
        return roles.toArray(new Role[0]);
    }

    private Map<String, Serializable> _getWorkflowContext(long workflowTaskId) throws Exception {
        com.liferay.portal.kernel.workflow.WorkflowTask workflowTask = this._workflowTaskManager.getWorkflowTask(workflowTaskId);
        WorkflowInstance workflowInstance = this._workflowInstanceManager.getWorkflowInstance(this.contextCompany.getCompanyId(), workflowTask.getWorkflowInstanceId());
        Map workflowContext = workflowInstance.getWorkflowContext();
        workflowContext.put("userId", String.valueOf(this.contextUser.getUserId()));
        return workflowContext;
    }

    private OrderByComparator<com.liferay.portal.kernel.workflow.WorkflowTask> _toOrderByComparator(Sort sort) {
        if (sort != null) {
            boolean ascending = !sort.isReverse();
            String sortFieldName = sort.getFieldName();
            if (StringUtil.startsWith((String)sortFieldName, (String)"dateCompletion")) {
                return this._workflowComparatorFactory.getTaskCompletionDateComparator(ascending);
            }
            if (StringUtil.startsWith((String)sortFieldName, (String)"dateCreated")) {
                return this._workflowComparatorFactory.getTaskCreateDateComparator(ascending);
            }
            if (StringUtil.startsWith((String)sortFieldName, (String)"dateDue")) {
                return this._workflowComparatorFactory.getTaskDueDateComparator(ascending);
            }
            if (StringUtil.startsWith((String)sortFieldName, (String)"name")) {
                return this._workflowComparatorFactory.getTaskNameComparator(ascending);
            }
            return this._workflowComparatorFactory.getTaskInstanceIdComparator(ascending);
        }
        return null;
    }

    private Role _toRole(com.liferay.portal.kernel.model.Role role) throws Exception {
        return RoleUtil.toRole(this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextAcceptLanguage.getPreferredLocale(), this._portal, role, this._userLocalService.fetchUser(role.getUserId()));
    }

    private WorkflowTask _toWorkflowTask(final com.liferay.portal.kernel.workflow.WorkflowTask workflowTask) throws Exception {
        return new WorkflowTask(){
            {
                if (workflowTask.getAssigneeUserId() > 0L) {
                    this.assigneePerson = CreatorUtil.toCreator(WorkflowTaskResourceImpl.this._portal, WorkflowTaskResourceImpl.this._userLocalService.fetchUser(workflowTask.getAssigneeUserId()));
                    this.assigneeRoles = WorkflowTaskResourceImpl.this._getRoles(workflowTask.getWorkflowTaskAssignees());
                }
                this.completed = workflowTask.isCompleted();
                this.dateCompletion = workflowTask.getCompletionDate();
                this.dateCreated = workflowTask.getCreateDate();
                this.dateDue = workflowTask.getDueDate();
                this.description = workflowTask.getDescription();
                this.id = workflowTask.getWorkflowTaskId();
                this.label = WorkflowTaskResourceImpl.this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)WorkflowTaskResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), WorkflowTaskResourceImpl.class), workflowTask.getName());
                this.name = workflowTask.getName();
                this.objectReviewed = ObjectReviewedUtil.toObjectReviewed(WorkflowTaskResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), workflowTask.getOptionalAttributes());
                this.workflowDefinitionId = workflowTask.getWorkflowDefinitionId();
                this.workflowDefinitionName = workflowTask.getWorkflowDefinitionName();
                this.workflowDefinitionVersion = String.valueOf(workflowTask.getWorkflowDefinitionVersion());
                this.workflowInstanceId = workflowTask.getWorkflowInstanceId();
                this.setActions(HashMapBuilder.put((Object)"assignToMe", WorkflowTaskResourceImpl.this.addAction("UPDATE", workflowTask.getWorkflowTaskId(), "postWorkflowTaskAssignToMe", WorkflowTaskResourceImpl.this._workflowTaskModelResourcePermission)).put((Object)"assignToRole", WorkflowTaskResourceImpl.this.addAction("UPDATE", workflowTask.getWorkflowTaskId(), "postWorkflowTaskAssignToRole", WorkflowTaskResourceImpl.this._workflowTaskModelResourcePermission)).put((Object)"assignToUser", WorkflowTaskResourceImpl.this.addAction("UPDATE", workflowTask.getWorkflowTaskId(), "postWorkflowTaskAssignToUser", WorkflowTaskResourceImpl.this._workflowTaskModelResourcePermission)).put((Object)"changeTransition", WorkflowTaskResourceImpl.this.addAction("UPDATE", workflowTask.getWorkflowTaskId(), "postWorkflowTaskChangeTransition", WorkflowTaskResourceImpl.this._workflowTaskModelResourcePermission)).put((Object)"updateDueDate", WorkflowTaskResourceImpl.this.addAction("UPDATE", workflowTask.getWorkflowTaskId(), "patchWorkflowTaskUpdateDueDate", WorkflowTaskResourceImpl.this._workflowTaskModelResourcePermission)).build());
            }
        };
    }
}

