/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.ChangeTransition;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowInstance;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowInstanceSubmit;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.ObjectReviewedUtil;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowInstanceResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowInstanceResource;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.WorkflowNode;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowInstanceResource.class})
public class WorkflowInstanceResourceImpl
extends BaseWorkflowInstanceResourceImpl {
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.workflow.WorkflowInstance)")
    private ModelResourcePermission<?> _workflowInstanceModelResourcePermission;

    @Override
    public void deleteWorkflowInstance(Long workflowInstanceId) throws Exception {
        this._workflowInstanceManager.deleteWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue());
    }

    @Override
    public WorkflowInstance getWorkflowInstance(Long workflowInstanceId) throws Exception {
        try {
            return this._toWorkflowInstance(this._workflowInstanceManager.getWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue()));
        }
        catch (WorkflowException workflowException) {
            Throwable throwable = workflowException.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw workflowException;
        }
    }

    @Override
    public Page<WorkflowInstance> getWorkflowInstancesPage(String assetClassName, Long assetPrimaryKey, Boolean completed, Pagination pagination) throws Exception {
        return Page.of((Map)HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getWorkflowInstancesPage", "com.liferay.portal.workflow", null)).build(), this.transform(this._workflowInstanceManager.getWorkflowInstances(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), assetClassName, assetPrimaryKey, Boolean.valueOf(GetterUtil.getBoolean((Object)completed)), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowInstance), (Pagination)pagination, (long)this._workflowInstanceManager.getWorkflowInstanceCount(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), assetClassName, assetPrimaryKey, Boolean.valueOf(GetterUtil.getBoolean((Object)completed))));
    }

    @Override
    public WorkflowInstance postWorkflowInstanceChangeTransition(Long workflowInstanceId, ChangeTransition changeTransition) throws Exception {
        return this._toWorkflowInstance(this._workflowInstanceManager.signalWorkflowInstance(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowInstanceId.longValue(), changeTransition.getTransitionName(), null));
    }

    @Override
    public WorkflowInstance postWorkflowInstanceSubmit(WorkflowInstanceSubmit workflowInstanceSubmit) throws Exception {
        return this._toWorkflowInstance(this._workflowInstanceManager.startWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceSubmit.getSiteId().longValue(), this.contextUser.getUserId(), workflowInstanceSubmit.getWorkflowDefinitionName(), Integer.valueOf(GetterUtil.getInteger((String)workflowInstanceSubmit.getWorkflowDefinitionVersion())), workflowInstanceSubmit.getTransitionName(), this._toWorkflowContext(workflowInstanceSubmit.getContext(), workflowInstanceSubmit.getSiteId())));
    }

    private Map<String, Serializable> _toWorkflowContext(Map<String, ?> context, long siteId) throws Exception {
        Map<String, Serializable> workflowContext = Stream.of(context.entrySet()).flatMap(Collection::parallelStream).filter(entry -> entry.getValue() instanceof Serializable).collect(Collectors.toMap(Map.Entry::getKey, entry -> (Serializable)entry.getValue()));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest);
        serviceContext.setScopeGroupId(siteId);
        workflowContext.put("serviceContext", (Serializable)serviceContext);
        return workflowContext;
    }

    private WorkflowInstance _toWorkflowInstance(final com.liferay.portal.kernel.workflow.WorkflowInstance workflowInstance) throws Exception {
        return new WorkflowInstance(){
            {
                this.completed = workflowInstance.isComplete();
                this.currentNodeNames = (String[])Stream.of(workflowInstance.getCurrentWorkflowNodes()).flatMap(Collection::stream).map(WorkflowNode::getName).toArray(String[]::new);
                this.dateCompletion = workflowInstance.getEndDate();
                this.dateCreated = workflowInstance.getStartDate();
                this.id = workflowInstance.getWorkflowInstanceId();
                this.objectReviewed = ObjectReviewedUtil.toObjectReviewed(WorkflowInstanceResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), workflowInstance.getWorkflowContext());
                this.workflowDefinitionName = workflowInstance.getWorkflowDefinitionName();
                this.workflowDefinitionVersion = String.valueOf(workflowInstance.getWorkflowDefinitionVersion());
                this.setActions(() -> HashMapBuilder.put((Object)"changeTransition", WorkflowInstanceResourceImpl.this.addAction("UPDATE", workflowInstance.getWorkflowInstanceId(), "postWorkflowInstanceChangeTransition", WorkflowInstanceResourceImpl.this._workflowInstanceModelResourcePermission)).put((Object)"delete", WorkflowInstanceResourceImpl.this.addAction("DELETE", workflowInstance.getWorkflowInstanceId(), "deleteWorkflowInstance", WorkflowInstanceResourceImpl.this._workflowInstanceModelResourcePermission)).build());
            }
        };
    }
}

