/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.Node;
import com.liferay.headless.admin.workflow.dto.v1_0.Transition;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowDefinition;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.NodeUtil;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.TransitionUtil;
import com.liferay.headless.admin.workflow.internal.odata.entity.v1_0.WorkflowDefinitionEntityModel;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowDefinitionResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowDefinitionResource;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowDefinitionResource.class})
public class WorkflowDefinitionResourceImpl
extends BaseWorkflowDefinitionResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new WorkflowDefinitionEntityModel();
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private WorkflowComparatorFactory _workflowComparatorFactory;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.workflow.WorkflowDefinition)")
    private ModelResourcePermission<?> _workflowDefinitionModelResourcePermission;

    @Override
    public void create(Collection<WorkflowDefinition> workflowDefinitions, Map<String, Serializable> parameters) throws Exception {
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
            if (this.contextBatchUnsafeConsumer != null) {
                this.contextBatchUnsafeConsumer.accept(workflowDefinitions, workflowDefinition -> this.postWorkflowDefinitionDeploy((WorkflowDefinition)workflowDefinition));
            } else {
                for (WorkflowDefinition workflowDefinition2 : workflowDefinitions) {
                    this.postWorkflowDefinitionDeploy(workflowDefinition2);
                }
            }
        } else {
            super.create(workflowDefinitions, parameters);
        }
    }

    @Override
    public void deleteWorkflowDefinition(Long workflowDefinitionId) throws Exception {
        WorkflowDefinition workflowDefinition = this.getWorkflowDefinition(workflowDefinitionId);
        this.postWorkflowDefinitionUpdateActive(false, workflowDefinition.getName(), workflowDefinition.getVersion());
        this.deleteWorkflowDefinitionUndeploy(workflowDefinition.getName(), workflowDefinition.getVersion());
    }

    @Override
    public void deleteWorkflowDefinitionUndeploy(String name, String version) throws Exception {
        this._workflowDefinitionManager.undeployWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), name, GetterUtil.getInteger((String)version));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public WorkflowDefinition getWorkflowDefinition(Long workflowDefinitionId) throws Exception {
        return this._toWorkflowDefinition((UnsafeSupplier<com.liferay.portal.kernel.workflow.WorkflowDefinition, Exception>)((UnsafeSupplier)() -> this._workflowDefinitionManager.getWorkflowDefinition(workflowDefinitionId.longValue())));
    }

    @Override
    public WorkflowDefinition getWorkflowDefinitionByName(String name, Integer version) throws Exception {
        return this._toWorkflowDefinition((UnsafeSupplier<com.liferay.portal.kernel.workflow.WorkflowDefinition, Exception>)((UnsafeSupplier)() -> {
            if (version == null) {
                return this._workflowDefinitionManager.getLatestWorkflowDefinition(this.contextCompany.getCompanyId(), name);
            }
            return this._workflowDefinitionManager.getWorkflowDefinition(this.contextCompany.getCompanyId(), name, version.intValue());
        }));
    }

    @Override
    public Page<WorkflowDefinition> getWorkflowDefinitionsPage(Boolean active, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_DEFINITION", "postWorkflowDefinition", "com.liferay.portal.workflow", null)).put((Object)"createBatch", this.addAction("ADD_DEFINITION", "postWorkflowDefinitionBatch", "com.liferay.portal.workflow", null)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteWorkflowDefinitionBatch", "com.liferay.portal.workflow", null)).put((Object)"get", this.addAction("VIEW", "getWorkflowDefinitionsPage", "com.liferay.portal.workflow", null)).put((Object)"updateActive", this.addAction("UPDATE", "postWorkflowDefinitionUpdateActive", "com.liferay.portal.workflow", null)).put((Object)"updateBatch", this.addAction("UPDATE", "putWorkflowDefinitionBatch", "com.liferay.portal.workflow", null)).build(), this.transform(this._workflowDefinitionManager.getLatestWorkflowDefinitions(active, this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toWorkflowDefinition), (Pagination)pagination, (long)this._workflowDefinitionManager.getLatestWorkflowDefinitionsCount(active, this.contextCompany.getCompanyId()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinition(WorkflowDefinition workflowDefinition) throws Exception {
        return this.postWorkflowDefinitionDeploy(workflowDefinition);
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionDeploy(WorkflowDefinition workflowDefinition) throws Exception {
        String content = workflowDefinition.getContent();
        return this._toWorkflowDefinition(this._workflowDefinitionManager.deployWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), this._getTitle(workflowDefinition), workflowDefinition.getName(), content.getBytes()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionSave(WorkflowDefinition workflowDefinition) throws Exception {
        String content = workflowDefinition.getContent();
        return this._toWorkflowDefinition(this._workflowDefinitionManager.saveWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), this._getTitle(workflowDefinition), workflowDefinition.getName(), content.getBytes()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionUpdateActive(Boolean active, String name, String version) throws Exception {
        return this._toWorkflowDefinition(this._workflowDefinitionManager.updateActive(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), name, GetterUtil.getInteger((String)version), active.booleanValue()));
    }

    @Override
    public WorkflowDefinition putWorkflowDefinition(Long workflowDefinitionId, WorkflowDefinition workflowDefinition) throws Exception {
        this._workflowDefinitionManager.getLatestWorkflowDefinition(this.contextCompany.getCompanyId(), workflowDefinition.getName());
        return this.postWorkflowDefinitionDeploy(workflowDefinition);
    }

    private String _getTitle(WorkflowDefinition workflowDefinition) throws Exception {
        if (MapUtil.isEmpty((Map)workflowDefinition.getTitle_i18n())) {
            return workflowDefinition.getTitle();
        }
        return this._localization.getXml(workflowDefinition.getTitle_i18n(), this._language.getLanguageId(this.contextCompany.getLocale()), "title");
    }

    private OrderByComparator<com.liferay.portal.kernel.workflow.WorkflowDefinition> _toOrderByComparator(Sort sort) {
        if (sort == null) {
            return this._workflowComparatorFactory.getDefinitionModifiedDateComparator(false);
        }
        if (StringUtil.equals((String)sort.getFieldName(), (String)"name")) {
            return this._workflowComparatorFactory.getDefinitionNameComparator(!sort.isReverse());
        }
        return this._workflowComparatorFactory.getDefinitionModifiedDateComparator(!sort.isReverse());
    }

    private WorkflowDefinition _toWorkflowDefinition(UnsafeSupplier<com.liferay.portal.kernel.workflow.WorkflowDefinition, Exception> unsafeSupplier) throws Exception {
        try {
            return this._toWorkflowDefinition((com.liferay.portal.kernel.workflow.WorkflowDefinition)unsafeSupplier.get());
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof NoSuchModelException) {
                throw (NoSuchModelException)throwable;
            }
            throw exception;
        }
    }

    private WorkflowDefinition _toWorkflowDefinition(final com.liferay.portal.kernel.workflow.WorkflowDefinition workflowDefinition) {
        return new WorkflowDefinition(){
            {
                this.active = workflowDefinition.isActive();
                this.content = workflowDefinition.getContent();
                this.dateCreated = workflowDefinition.getCreateDate();
                this.dateModified = workflowDefinition.getModifiedDate();
                this.description = workflowDefinition.getDescription();
                this.id = workflowDefinition.getWorkflowDefinitionId();
                this.name = workflowDefinition.getName();
                this.nodes = (Node[])WorkflowDefinitionResourceImpl.this.transformToArray(workflowDefinition.getWorkflowNodes(), workflowNode -> NodeUtil.toNode(WorkflowDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), workflowNode), Node.class);
                this.title = workflowDefinition.getTitle(WorkflowDefinitionResourceImpl.this._language.getLanguageId(WorkflowDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale()));
                this.title_i18n = Stream.of(WorkflowDefinitionResourceImpl.this._localization.getLocalizationMap(workflowDefinition.getTitle())).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(entry -> WorkflowDefinitionResourceImpl.this._language.getLanguageId((Locale)entry.getKey()), Map.Entry::getValue));
                this.transitions = (Transition[])WorkflowDefinitionResourceImpl.this.transformToArray(workflowDefinition.getWorkflowTransitions(), workflowTransition -> TransitionUtil.toTransition(WorkflowDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), workflowTransition), Transition.class);
                this.version = String.valueOf(workflowDefinition.getVersion());
                this.setActions(() -> HashMapBuilder.put((Object)"delete", WorkflowDefinitionResourceImpl.this.addAction("DELETE", workflowDefinition.getWorkflowDefinitionId(), "deleteWorkflowDefinition", WorkflowDefinitionResourceImpl.this._workflowDefinitionModelResourcePermission)).put((Object)"update", WorkflowDefinitionResourceImpl.this.addAction("UPDATE", workflowDefinition.getWorkflowDefinitionId(), "putWorkflowDefinition", WorkflowDefinitionResourceImpl.this._workflowDefinitionModelResourcePermission)).build());
            }
        };
    }
}

