/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.ChangeTransition;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTask;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToMe;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToRole;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToUser;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTasksBulkSelection;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowTaskResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseWorkflowTaskResourceImpl
implements EntityModelResource,
VulcanBatchEngineTaskItemDelegate<WorkflowTask>,
WorkflowTaskResource {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<WorkflowTask>, UnsafeConsumer<WorkflowTask, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseWorkflowTaskResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowInstanceId"), @Parameter(in=ParameterIn.QUERY, name="completed"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-instances/{workflowInstanceId}/workflow-tasks")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksPage(@Parameter(hidden=true) @NotNull @PathParam(value="workflowInstanceId") Long workflowInstanceId, @Parameter(hidden=true) @QueryParam(value="completed") Boolean completed, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowInstanceId"), @Parameter(in=ParameterIn.QUERY, name="completed"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-instances/{workflowInstanceId}/workflow-tasks/assigned-to-me")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksAssignedToMePage(@Parameter(hidden=true) @NotNull @PathParam(value="workflowInstanceId") Long workflowInstanceId, @Parameter(hidden=true) @QueryParam(value="completed") Boolean completed, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowInstanceId"), @Parameter(in=ParameterIn.QUERY, name="assigneeId"), @Parameter(in=ParameterIn.QUERY, name="completed"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-instances/{workflowInstanceId}/workflow-tasks/assigned-to-user")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowInstanceWorkflowTasksAssignedToUserPage(@Parameter(hidden=true) @NotNull @PathParam(value="workflowInstanceId") Long workflowInstanceId, @Parameter(hidden=true) @QueryParam(value="assigneeId") Long assigneeId, @Parameter(hidden=true) @QueryParam(value="completed") Boolean completed, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> postWorkflowTasksPage(@Context Pagination pagination, @Context Sort[] sorts, WorkflowTasksBulkSelection workflowTasksBulkSelection) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/workflow-tasks/assign-to-user")
    @Produces(value={"application/json", "application/xml"})
    public void patchWorkflowTaskAssignToUser(WorkflowTaskAssignToUser[] workflowTaskAssignToUsers) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/assigned-to-me")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksAssignedToMePage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/assigned-to-my-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksAssignedToMyRolesPage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="roleId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/assigned-to-role")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksAssignedToRolePage(@Parameter(hidden=true) @NotNull @QueryParam(value="roleId") Long roleId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="assigneeId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/assigned-to-user")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksAssignedToUserPage(@Parameter(hidden=true) @QueryParam(value="assigneeId") Long assigneeId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="assigneeId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/assigned-to-user-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksAssignedToUserRolesPage(@Parameter(hidden=true) @QueryParam(value="assigneeId") Long assigneeId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/workflow-tasks/change-transition")
    @Produces(value={"application/json", "application/xml"})
    public void patchWorkflowTaskChangeTransition(ChangeTransition[] changeTransitions) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="creatorId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/submitting-user")
    @Produces(value={"application/json", "application/xml"})
    public Page<WorkflowTask> getWorkflowTasksSubmittingUserPage(@Parameter(hidden=true) @QueryParam(value="creatorId") Long creatorId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/workflow-tasks/update-due-date")
    @Produces(value={"application/json", "application/xml"})
    public void patchWorkflowTaskUpdateDueDate(WorkflowTaskAssignToMe[] workflowTaskAssignToMes) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/{workflowTaskId}")
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask getWorkflowTask(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId) throws Exception {
        return new WorkflowTask();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks/{workflowTaskId}/assign-to-me")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask postWorkflowTaskAssignToMe(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return new WorkflowTask();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks/{workflowTaskId}/assign-to-role")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask postWorkflowTaskAssignToRole(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId, WorkflowTaskAssignToRole workflowTaskAssignToRole) throws Exception {
        return new WorkflowTask();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks/{workflowTaskId}/assign-to-user")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask postWorkflowTaskAssignToUser(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId, WorkflowTaskAssignToUser workflowTaskAssignToUser) throws Exception {
        return new WorkflowTask();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks/{workflowTaskId}/change-transition")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask postWorkflowTaskChangeTransition(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId, ChangeTransition changeTransition) throws Exception {
        return new WorkflowTask();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @GET
    @Path(value="/workflow-tasks/{workflowTaskId}/has-assignable-users")
    @Produces(value={"text/plain"})
    public Boolean getWorkflowTaskHasAssignableUsers(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId) throws Exception {
        return false;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="workflowTaskId")})
    @Tags(value={@Tag(name="WorkflowTask")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/workflow-tasks/{workflowTaskId}/update-due-date")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public WorkflowTask postWorkflowTaskUpdateDueDate(@Parameter(hidden=true) @NotNull @PathParam(value="workflowTaskId") Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return new WorkflowTask();
    }

    public void create(Collection<WorkflowTask> workflowTasks, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<WorkflowTask> workflowTasks, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<WorkflowTask> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("workflowInstanceId")) {
            return this.getWorkflowInstanceWorkflowTasksPage(Long.parseLong((String)((Object)parameters.get("workflowInstanceId"))), Boolean.parseBoolean((String)((Object)parameters.get("completed"))), pagination);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [workflowInstanceId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<WorkflowTask> workflowTasks, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<WorkflowTask>, UnsafeConsumer<WorkflowTask, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

