/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.dto.v1_0.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import java.util.Locale;
import java.util.function.Function;

public class WorkflowLogUtil {
    public static String getDescription(Language language, Locale locale, Portal portal, Function<Long, Role> roleFunction, Function<Long, User> userFunction, WorkflowLog workflowLog) throws PortalException {
        if (workflowLog.getType() == 3) {
            return language.format(locale, "x-completed-the-task-x", new Object[]{portal.getUserName(workflowLog.getAuditUserId(), String.valueOf(workflowLog.getAuditUserId())), workflowLog.getCurrentWorkflowNodeLabel(locale)}, false);
        }
        if (workflowLog.getType() == 2) {
            return language.format(locale, "x-updated-the-due-date", new Object[]{portal.getUserName(workflowLog.getAuditUserId(), String.valueOf(workflowLog.getAuditUserId()))}, false);
        }
        if (workflowLog.getType() == 0) {
            return language.format(locale, "x-changed-the-state-from-x-to-x", new Object[]{portal.getUserName(workflowLog.getAuditUserId(), String.valueOf(workflowLog.getAuditUserId())), workflowLog.getPreviousWorkflowNodeLabel(locale), workflowLog.getCurrentWorkflowNodeLabel(locale)}, false);
        }
        if (WorkflowLogUtil._isAuditUser(workflowLog)) {
            String pattern = "x-assigned-the-task-to-herself";
            User user = userFunction.apply(workflowLog.getUserId());
            if (user == null || user.isMale()) {
                pattern = "x-assigned-the-task-to-himself";
            }
            String userFullName = user == null ? String.valueOf(workflowLog.getUserId()) : user.getFullName();
            return language.format(locale, pattern, (Object)userFullName, false);
        }
        if (workflowLog.getRoleId() == 0L) {
            StringBundler sb = new StringBundler(3);
            sb.append(language.format(locale, "x-assigned-the-task-to-x", new Object[]{portal.getUserName(workflowLog.getAuditUserId(), String.valueOf(workflowLog.getAuditUserId())), WorkflowLogUtil._getActorName(language, locale, roleFunction, userFunction, workflowLog)}, false));
            if (workflowLog.getPreviousUserId() != 0L) {
                sb.append(" ");
                sb.append(language.format(locale, "previous-assignee-was-x", (Object)portal.getUserName(workflowLog.getPreviousUserId(), String.valueOf(workflowLog.getPreviousUserId())), false));
            }
            return sb.toString();
        }
        return language.format(locale, "task-initially-assigned-to-the-x-role", (Object)WorkflowLogUtil._getActorName(language, locale, roleFunction, userFunction, workflowLog), false);
    }

    private static String _getActorName(Language language, Locale locale, Function<Long, Role> roleFunction, Function<Long, User> userFunction, WorkflowLog workflowLog) {
        if (workflowLog.getRoleId() != 0L) {
            Role role = roleFunction.apply(workflowLog.getRoleId());
            if (role == null) {
                return String.valueOf(workflowLog.getRoleId());
            }
            return role.getTitle(language.getLanguageId(locale));
        }
        if (workflowLog.getUserId() != 0L) {
            User user = userFunction.apply(workflowLog.getUserId());
            if (user == null) {
                return String.valueOf(workflowLog.getUserId());
            }
            return user.getFullName();
        }
        return "";
    }

    private static boolean _isAuditUser(WorkflowLog workflowLog) {
        if (workflowLog.getUserId() == 0L) {
            return false;
        }
        return workflowLog.getAuditUserId() == workflowLog.getUserId();
    }
}

