/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.Role;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.RoleUtil;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowLogResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowLogResource;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowLogManager;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactoryUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.LogType;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-log.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowLogResource.class})
public class WorkflowLogResourceImpl
extends BaseWorkflowLogResourceImpl {
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowLogManager _workflowLogManager;

    @Override
    public Page<com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog> getWorkflowInstanceWorkflowLogsPage(Long workflowInstanceId, String[] types, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowLogManager.getWorkflowLogsByWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue(), this._toLogTypes(types), pagination.getStartPosition(), pagination.getEndPosition(), WorkflowComparatorFactoryUtil.getLogCreateDateComparator((boolean)false)), this::_toWorkflowLog), (Pagination)pagination, (long)this._workflowLogManager.getWorkflowLogCountByWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue(), this._toLogTypes(types)));
    }

    @Override
    public com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog getWorkflowLog(Long workflowLogId) throws Exception {
        return this._toWorkflowLog(this._kaleoWorkflowModelConverter.toWorkflowLog(this._kaleoLogLocalService.getKaleoLog(workflowLogId.longValue())));
    }

    @Override
    public Page<com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog> getWorkflowTaskWorkflowLogsPage(Long workflowTaskId, String[] types, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowLogManager.getWorkflowLogsByWorkflowTask(this.contextCompany.getCompanyId(), workflowTaskId.longValue(), this._toLogTypes(types), pagination.getStartPosition(), pagination.getEndPosition(), WorkflowComparatorFactoryUtil.getLogCreateDateComparator((boolean)false)), this::_toWorkflowLog), (Pagination)pagination, (long)this._workflowLogManager.getWorkflowLogCountByWorkflowTask(this.contextCompany.getCompanyId(), workflowTaskId.longValue(), this._toLogTypes(types)));
    }

    private String _toLogTypeName(WorkflowLog.Type type) {
        if (type == WorkflowLog.Type.TASK_ASSIGN) {
            return LogType.TASK_ASSIGNMENT.name();
        }
        if (type == WorkflowLog.Type.TASK_COMPLETION) {
            return LogType.TASK_COMPLETION.name();
        }
        if (type == WorkflowLog.Type.TASK_UPDATE) {
            return LogType.TASK_UPDATE.name();
        }
        if (type == WorkflowLog.Type.TRANSITION) {
            return LogType.NODE_EXIT.name();
        }
        return null;
    }

    private List<Integer> _toLogTypes(String[] types) {
        return Stream.of(types).map(WorkflowLog.Type::create).map(this::_toLogTypeName).map(KaleoLogUtil::convert).distinct().collect(Collectors.toList());
    }

    private Role _toRole(long roleId) throws Exception {
        com.liferay.portal.kernel.model.Role role = this._roleLocalService.getRole(roleId);
        if (role == null) {
            return null;
        }
        return RoleUtil.toRole(this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextAcceptLanguage.getPreferredLocale(), this._portal, role, this._userLocalService.fetchUser(role.getUserId()));
    }

    private com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog _toWorkflowLog(final WorkflowLog workflowLog) throws Exception {
        return new com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog(){
            {
                this.auditPerson = CreatorUtil.toCreator(WorkflowLogResourceImpl.this._portal, WorkflowLogResourceImpl.this._userLocalService.fetchUser(workflowLog.getAuditUserId()));
                this.commentLog = workflowLog.getComment();
                this.dateCreated = workflowLog.getCreateDate();
                this.id = workflowLog.getWorkflowLogId();
                this.person = CreatorUtil.toCreator(WorkflowLogResourceImpl.this._portal, WorkflowLogResourceImpl.this._userLocalService.fetchUser(workflowLog.getUserId()));
                this.previousPerson = CreatorUtil.toCreator(WorkflowLogResourceImpl.this._portal, WorkflowLogResourceImpl.this._userLocalService.fetchUser(workflowLog.getPreviousUserId()));
                this.previousRole = WorkflowLogResourceImpl.this._toRole(workflowLog.getPreviousRoleId());
                this.previousState = workflowLog.getPreviousState();
                this.role = WorkflowLogResourceImpl.this._toRole(workflowLog.getRoleId());
                this.state = workflowLog.getState();
                this.type = WorkflowLogResourceImpl.this._toWorkflowLogType(KaleoLogUtil.convert((int)workflowLog.getType()));
                this.workflowTaskId = workflowLog.getWorkflowTaskId();
            }
        };
    }

    private WorkflowLog.Type _toWorkflowLogType(String type) {
        if (type == LogType.NODE_EXIT.name()) {
            return WorkflowLog.Type.TRANSITION;
        }
        if (type == LogType.TASK_ASSIGNMENT.name()) {
            return WorkflowLog.Type.TASK_ASSIGN;
        }
        if (type == LogType.TASK_COMPLETION.name()) {
            return WorkflowLog.Type.TASK_COMPLETION;
        }
        if (type == LogType.TASK_UPDATE.name()) {
            return WorkflowLog.Type.TASK_UPDATE;
        }
        return null;
    }
}

