/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowDefinition;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowDefinitionResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowDefinitionResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowDefinitionResource.class})
public class WorkflowDefinitionResourceImpl
extends BaseWorkflowDefinitionResourceImpl {
    @Reference(target="(proxy.bean=false)")
    private WorkflowDefinitionManager _workflowDefinitionManager;

    @Override
    public void deleteWorkflowDefinitionUndeploy(String name, String version) throws Exception {
        this._workflowDefinitionManager.undeployWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), name, GetterUtil.getInteger((String)version));
    }

    @Override
    public WorkflowDefinition getWorkflowDefinitionByName(String name) throws Exception {
        return this._toWorkflowDefinition(this._workflowDefinitionManager.getLatestWorkflowDefinition(this.contextCompany.getCompanyId(), name));
    }

    @Override
    public Page<WorkflowDefinition> getWorkflowDefinitionsPage(Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowDefinitionManager.getLatestWorkflowDefinitions(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowDefinition), (Pagination)pagination, (long)this._workflowDefinitionManager.getLatestWorkflowDefinitionsCount(this.contextCompany.getCompanyId()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionDeploy(WorkflowDefinition workflowDefinition) throws Exception {
        String content = workflowDefinition.getContent();
        return this._toWorkflowDefinition(this._workflowDefinitionManager.deployWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowDefinition.getTitle(), workflowDefinition.getName(), content.getBytes()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionSave(WorkflowDefinition workflowDefinition) throws Exception {
        String content = workflowDefinition.getContent();
        return this._toWorkflowDefinition(this._workflowDefinitionManager.saveWorkflowDefinition(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowDefinition.getTitle(), workflowDefinition.getName(), content.getBytes()));
    }

    @Override
    public WorkflowDefinition postWorkflowDefinitionUpdateActive(Boolean active, String name, String version) throws Exception {
        return this._toWorkflowDefinition(this._workflowDefinitionManager.updateActive(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), name, GetterUtil.getInteger((String)version), active.booleanValue()));
    }

    private WorkflowDefinition _toWorkflowDefinition(final com.liferay.portal.kernel.workflow.WorkflowDefinition workflowDefinition) {
        return new WorkflowDefinition(){
            {
                this.active = workflowDefinition.isActive();
                this.content = workflowDefinition.getContent();
                this.dateModified = workflowDefinition.getModifiedDate();
                this.description = workflowDefinition.getDescription();
                this.name = workflowDefinition.getName();
                this.title = workflowDefinition.getTitle();
                this.version = String.valueOf(workflowDefinition.getVersion());
            }
        };
    }
}

