/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.dto.v1_0.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.headless.admin.workflow.dto.v1_0.ObjectReviewed;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectReviewedUtil {
    public static ObjectReviewed toObjectReviewed(final Locale locale, final Map<String, Serializable> optionalAttributes) {
        return new ObjectReviewed(){
            {
                this.assetTitle = ObjectReviewedUtil._getAssetTitle(GetterUtil.getLong(optionalAttributes.get("entryClassPK")), GetterUtil.getString(optionalAttributes.get("entryClassName")), locale);
                this.assetType = ObjectReviewedUtil._getAssetType(GetterUtil.getString(optionalAttributes.get("entryClassName")), locale);
                this.id = GetterUtil.getLong(optionalAttributes.get("entryClassPK"));
                this.resourceType = ObjectReviewedUtil._toResourceType(GetterUtil.getString(optionalAttributes.get("entryClassName")));
            }
        };
    }

    private static String _getAssetTitle(long classPK, String entryClassName, Locale locale) {
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)entryClassName);
        return workflowHandler.getTitle(classPK, locale);
    }

    private static String _getAssetType(String entryClassName, Locale locale) {
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)entryClassName);
        return workflowHandler.getType(locale);
    }

    private static String _toResourceType(String entryClassName) {
        if (Objects.equals(entryClassName, BlogsEntry.class.getName())) {
            return "BlogPosting";
        }
        if (Objects.equals(entryClassName, MBDiscussion.class.getName())) {
            return "Comment";
        }
        return null;
    }
}

