/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.headless.admin.workflow.dto.v1_0.ChangeTransition;
import com.liferay.headless.admin.workflow.dto.v1_0.ObjectReviewed;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTask;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToMe;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTaskAssignToUser;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowTaskResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowTaskResource;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.xml.bind.ValidationException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-task.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowTaskResource.class})
public class WorkflowTaskResourceImpl
extends BaseWorkflowTaskResourceImpl {
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;

    @Override
    public Page<WorkflowTask> getRoleWorkflowTasksPage(Long roleId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowTaskManager.getWorkflowTasksByRole(this.contextCompany.getCompanyId(), roleId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByRole(this.contextCompany.getCompanyId(), roleId.longValue(), null));
    }

    @Override
    public WorkflowTask getWorkflowTask(Long workflowTaskId) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.getWorkflowTask(this.contextCompany.getCompanyId(), workflowTaskId.longValue()));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToMePage(Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowTaskManager.getWorkflowTasksByUser(this.contextCompany.getCompanyId(), this._user.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUser(this.contextCompany.getCompanyId(), this._user.getUserId(), null));
    }

    @Override
    public Page<WorkflowTask> getWorkflowTasksAssignedToMyRolesPage(Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowTaskManager.getWorkflowTasksByUserRoles(this.contextCompany.getCompanyId(), this._user.getUserId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowTask), (Pagination)pagination, (long)this._workflowTaskManager.getWorkflowTaskCountByUserRoles(this.contextCompany.getCompanyId(), this._user.getUserId(), null));
    }

    @Override
    public WorkflowTask postWorkflowTaskAssignToMe(Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.assignWorkflowTaskToUser(this._user.getCompanyId(), this._user.getUserId(), workflowTaskId.longValue(), this._user.getUserId(), workflowTaskAssignToMe.getComment(), workflowTaskAssignToMe.getDueDate(), null));
    }

    @Override
    public WorkflowTask postWorkflowTaskAssignToUser(Long workflowTaskId, WorkflowTaskAssignToUser workflowTaskAssignToUser) throws Exception {
        long assigneeId = workflowTaskAssignToUser.getAssigneeId();
        return this._toWorkflowTask(this._workflowTaskManager.assignWorkflowTaskToUser(this.contextCompany.getCompanyId(), this._user.getUserId(), workflowTaskId.longValue(), assigneeId, workflowTaskAssignToUser.getComment(), workflowTaskAssignToUser.getDueDate(), null));
    }

    @Override
    public WorkflowTask postWorkflowTaskChangeTransition(Long workflowTaskId, ChangeTransition changeTransition) throws Exception {
        String transition = changeTransition.getTransition();
        List<String> transitionsNames = this._getTaskTransitionsNames(this._workflowTaskManager.getWorkflowTask(this._user.getCompanyId(), workflowTaskId.longValue()));
        if (!transitionsNames.contains(transition)) {
            throw new ValidationException("Invalid transition: " + transition);
        }
        return this._toWorkflowTask(this._workflowTaskManager.completeWorkflowTask(this._user.getCompanyId(), this._user.getUserId(), workflowTaskId.longValue(), transition, "", null));
    }

    @Override
    public WorkflowTask postWorkflowTaskUpdateDueDate(Long workflowTaskId, WorkflowTaskAssignToMe workflowTaskAssignToMe) throws Exception {
        return this._toWorkflowTask(this._workflowTaskManager.updateDueDate(this._user.getCompanyId(), this._user.getUserId(), workflowTaskId.longValue(), workflowTaskAssignToMe.getComment(), workflowTaskAssignToMe.getDueDate()));
    }

    private String _getResourceType(Map<String, Serializable> optionalAttributes) {
        String className = GetterUtil.getString((Object)optionalAttributes.get("entryClassName"));
        if (className.equals(BlogsEntry.class.getName())) {
            return "BlogPosting";
        }
        if (className.equals(MBDiscussion.class.getName())) {
            return "Comment";
        }
        return null;
    }

    private List<String> _getTaskTransitionsNames(com.liferay.portal.kernel.workflow.WorkflowTask workflowTask) throws Exception {
        if (workflowTask.getAssigneeUserId() > 0L) {
            User user = this._userLocalService.getUserById(workflowTask.getAssigneeUserId());
            return this._workflowTaskManager.getNextTransitionNames(user.getCompanyId(), workflowTask.getAssigneeUserId(), workflowTask.getWorkflowTaskId());
        }
        return Collections.emptyList();
    }

    private ObjectReviewed _toObjectReviewed(final Map<String, Serializable> optionalAttributes) {
        return new ObjectReviewed(){
            {
                this.id = GetterUtil.getLong(optionalAttributes.get("entryClassPK"));
                this.resourceType = WorkflowTaskResourceImpl.this._getResourceType(optionalAttributes);
            }
        };
    }

    private WorkflowTask _toWorkflowTask(final com.liferay.portal.kernel.workflow.WorkflowTask workflowTask) throws Exception {
        return new WorkflowTask(){
            {
                this.completed = workflowTask.isCompleted();
                this.dateCompleted = workflowTask.getCompletionDate();
                this.dateCreated = workflowTask.getCreateDate();
                this.definitionName = workflowTask.getWorkflowDefinitionName();
                this.description = workflowTask.getDescription();
                this.dueDate = workflowTask.getDueDate();
                this.id = workflowTask.getWorkflowTaskId();
                this.name = workflowTask.getName();
                this.objectReviewed = WorkflowTaskResourceImpl.this._toObjectReviewed(workflowTask.getOptionalAttributes());
                List taskTransitionsNames = WorkflowTaskResourceImpl.this._getTaskTransitionsNames(workflowTask);
                this.transitions = taskTransitionsNames.toArray(new String[0]);
            }
        };
    }
}

