/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.client.pagination;

import com.liferay.headless.admin.workflow.client.aggregation.Facet;
import com.liferay.headless.admin.workflow.client.json.BaseJSONParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Page<T> {
    private Map<String, Map> _actions;
    private List<Facet> _facets = new ArrayList<Facet>();
    private Collection<T> _items;
    private long _page;
    private long _pageSize;
    private long _totalCount;

    public static <T> Page<T> of(String json, Function<String, T> toDTOFunction) {
        PageJSONParser<T> pageJSONParser = new PageJSONParser<T>(toDTOFunction);
        return (Page)pageJSONParser.parseToDTO(json);
    }

    public Map<String, Map> getActions() {
        return this._actions;
    }

    public List<Facet> getFacets() {
        return this._facets;
    }

    public Collection<T> getItems() {
        return this._items;
    }

    public long getLastPage() {
        if (this._totalCount == 0L) {
            return 1L;
        }
        return -Math.floorDiv(-this._totalCount, this._pageSize);
    }

    public long getPage() {
        return this._page;
    }

    public long getPageSize() {
        return this._pageSize;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    public boolean hasNext() {
        return this.getLastPage() > this._page;
    }

    public boolean hasPrevious() {
        return this._page > 1L;
    }

    public void setActions(Map<String, Map> actions) {
        this._actions = actions;
    }

    public void setFacets(List<Facet> facets) {
        this._facets = facets;
    }

    public void setItems(Collection<T> items) {
        this._items = items;
    }

    public void setPage(long page) {
        this._page = page;
    }

    public void setPageSize(long pageSize) {
        this._pageSize = pageSize;
    }

    public void setTotalCount(long totalCount) {
        this._totalCount = totalCount;
    }

    public static class PageJSONParser<T>
    extends BaseJSONParser<Page> {
        private final Function<String, T> _toDTOFunction;

        public PageJSONParser() {
            this._toDTOFunction = null;
        }

        public PageJSONParser(Function<String, T> toDTOFunction) {
            this._toDTOFunction = toDTOFunction;
        }

        @Override
        protected Page createDTO() {
            return new Page();
        }

        protected Page[] createDTOArray(int size) {
            return new Page[size];
        }

        @Override
        protected void setField(Page page, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "actions")) {
                if (jsonParserFieldValue != null) {
                    PageJSONParser<T> pageJSONParser = new PageJSONParser<T>(this._toDTOFunction);
                    page.setActions(pageJSONParser.parseToMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "facets")) {
                if (jsonParserFieldValue != null) {
                    page.setFacets(Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(this::parseToMap).map(facets -> new Facet((String)facets.get("facetCriteria"), Stream.of((Object[])facets.get("facetValues")).map(object -> (String)object).map(this::parseToMap).map(facetValues -> new Facet.FacetValue(Integer.valueOf((String)facetValues.get("numberOfOccurrences")), (String)facetValues.get("term"))).collect(Collectors.toList()))).collect(Collectors.toList()));
                }
            } else if (Objects.equals(jsonParserFieldName, "items")) {
                if (jsonParserFieldValue != null) {
                    page.setItems(Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(string -> this._toDTOFunction.apply((String)string)).collect(Collectors.toList()));
                }
            } else if (!Objects.equals(jsonParserFieldName, "lastPage")) {
                if (Objects.equals(jsonParserFieldName, "page")) {
                    if (jsonParserFieldValue != null) {
                        page.setPage(Long.valueOf((String)jsonParserFieldValue));
                    }
                } else if (Objects.equals(jsonParserFieldName, "pageSize")) {
                    if (jsonParserFieldValue != null) {
                        page.setPageSize(Long.valueOf((String)jsonParserFieldValue));
                    }
                } else if (Objects.equals(jsonParserFieldName, "totalCount")) {
                    if (jsonParserFieldValue != null) {
                        page.setTotalCount(Long.valueOf((String)jsonParserFieldValue));
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported field name " + jsonParserFieldName);
                }
            }
        }
    }
}

