/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.workflow.dto.v1_0.Creator;
import com.liferay.headless.admin.workflow.dto.v1_0.Role;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents the log containing the workflow's activity history (e.g., transitions, assignees, etc.).", value="WorkflowLog")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WorkflowLog")
public class WorkflowLog
implements Serializable {
    @GraphQLField(description="The user account of the person auditing the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The user account of the person auditing the workflow.") Creator auditPerson;
    @GraphQLField(description="The log's comments.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's comments.") String commentLog;
    @GraphQLField(description="The log's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's creation date.") Date dateCreated;
    @GraphQLField(description="The log's description.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's description.") String description;
    @GraphQLField(description="The log's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's ID.") Long id;
    @GraphQLField(description="The person assigned to the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The person assigned to the workflow.") Creator person;
    @GraphQLField(description="The previous person assigned to the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The previous person assigned to the workflow.") Creator previousPerson;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Role previousRole;
    @GraphQLField(description="The workflow's previous state.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's previous state.") String previousState;
    @GraphQLField(description="The workflow's previous state Label.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's previous state Label.") String previousStateLabel;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Role role;
    @GraphQLField(description="The workflow's current state.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's current state.") String state;
    @GraphQLField(description="The workflow's current state Label.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's current state Label.") String stateLabel;
    @GraphQLField(description="The workflow log's type.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow log's type.") Type type;
    @GraphQLField(description="The task associated with this workflow log.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task associated with this workflow log.") Long workflowTaskId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static WorkflowLog toDTO(String json) {
        return (WorkflowLog)ObjectMapperUtil.readValue(WorkflowLog.class, (String)json);
    }

    public static WorkflowLog unsafeToDTO(String json) {
        return (WorkflowLog)ObjectMapperUtil.unsafeReadValue(WorkflowLog.class, (String)json);
    }

    @Schema(description="The user account of the person auditing the workflow.")
    @Valid
    public Creator getAuditPerson() {
        return this.auditPerson;
    }

    public void setAuditPerson(Creator auditPerson) {
        this.auditPerson = auditPerson;
    }

    @JsonIgnore
    public void setAuditPerson(UnsafeSupplier<Creator, Exception> auditPersonUnsafeSupplier) {
        try {
            this.auditPerson = (Creator)auditPersonUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's comments.")
    public String getCommentLog() {
        return this.commentLog;
    }

    public void setCommentLog(String commentLog) {
        this.commentLog = commentLog;
    }

    @JsonIgnore
    public void setCommentLog(UnsafeSupplier<String, Exception> commentLogUnsafeSupplier) {
        try {
            this.commentLog = (String)commentLogUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The person assigned to the workflow.")
    @Valid
    public Creator getPerson() {
        return this.person;
    }

    public void setPerson(Creator person) {
        this.person = person;
    }

    @JsonIgnore
    public void setPerson(UnsafeSupplier<Creator, Exception> personUnsafeSupplier) {
        try {
            this.person = (Creator)personUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The previous person assigned to the workflow.")
    @Valid
    public Creator getPreviousPerson() {
        return this.previousPerson;
    }

    public void setPreviousPerson(Creator previousPerson) {
        this.previousPerson = previousPerson;
    }

    @JsonIgnore
    public void setPreviousPerson(UnsafeSupplier<Creator, Exception> previousPersonUnsafeSupplier) {
        try {
            this.previousPerson = (Creator)previousPersonUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Role getPreviousRole() {
        return this.previousRole;
    }

    public void setPreviousRole(Role previousRole) {
        this.previousRole = previousRole;
    }

    @JsonIgnore
    public void setPreviousRole(UnsafeSupplier<Role, Exception> previousRoleUnsafeSupplier) {
        try {
            this.previousRole = (Role)previousRoleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's previous state.")
    public String getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(String previousState) {
        this.previousState = previousState;
    }

    @JsonIgnore
    public void setPreviousState(UnsafeSupplier<String, Exception> previousStateUnsafeSupplier) {
        try {
            this.previousState = (String)previousStateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's previous state Label.")
    public String getPreviousStateLabel() {
        return this.previousStateLabel;
    }

    public void setPreviousStateLabel(String previousStateLabel) {
        this.previousStateLabel = previousStateLabel;
    }

    @JsonIgnore
    public void setPreviousStateLabel(UnsafeSupplier<String, Exception> previousStateLabelUnsafeSupplier) {
        try {
            this.previousStateLabel = (String)previousStateLabelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @JsonIgnore
    public void setRole(UnsafeSupplier<Role, Exception> roleUnsafeSupplier) {
        try {
            this.role = (Role)roleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's current state.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonIgnore
    public void setState(UnsafeSupplier<String, Exception> stateUnsafeSupplier) {
        try {
            this.state = (String)stateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's current state Label.")
    public String getStateLabel() {
        return this.stateLabel;
    }

    public void setStateLabel(String stateLabel) {
        this.stateLabel = stateLabel;
    }

    @JsonIgnore
    public void setStateLabel(UnsafeSupplier<String, Exception> stateLabelUnsafeSupplier) {
        try {
            this.stateLabel = (String)stateLabelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow log's type.")
    @Valid
    public Type getType() {
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        try {
            this.type = (Type)((Object)typeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task associated with this workflow log.")
    public Long getWorkflowTaskId() {
        return this.workflowTaskId;
    }

    public void setWorkflowTaskId(Long workflowTaskId) {
        this.workflowTaskId = workflowTaskId;
    }

    @JsonIgnore
    public void setWorkflowTaskId(UnsafeSupplier<Long, Exception> workflowTaskIdUnsafeSupplier) {
        try {
            this.workflowTaskId = (Long)workflowTaskIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkflowLog)) {
            return false;
        }
        WorkflowLog workflowLog = (WorkflowLog)object;
        return Objects.equals(this.toString(), workflowLog.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.auditPerson != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"auditPerson\": ");
            sb.append(String.valueOf(this.auditPerson));
        }
        if (this.commentLog != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"commentLog\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.commentLog));
            sb.append("\"");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.description));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.person != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"person\": ");
            sb.append(String.valueOf(this.person));
        }
        if (this.previousPerson != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousPerson\": ");
            sb.append(String.valueOf(this.previousPerson));
        }
        if (this.previousRole != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousRole\": ");
            sb.append(String.valueOf(this.previousRole));
        }
        if (this.previousState != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousState\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.previousState));
            sb.append("\"");
        }
        if (this.previousStateLabel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousStateLabel\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.previousStateLabel));
            sb.append("\"");
        }
        if (this.role != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"role\": ");
            sb.append(String.valueOf(this.role));
        }
        if (this.state != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"state\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.state));
            sb.append("\"");
        }
        if (this.stateLabel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"stateLabel\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.stateLabel));
            sb.append("\"");
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)this.type);
            sb.append("\"");
        }
        if (this.workflowTaskId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"workflowTaskId\": ");
            sb.append((Object)this.workflowTaskId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WorkflowLog._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WorkflowLog._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WorkflowLog._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WorkflowLog._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        NODE_ENTRY("NodeEntry"),
        TASK_ASSIGN("TaskAssign"),
        TASK_COMPLETION("TaskCompletion"),
        TASK_UPDATE("TaskUpdate"),
        TRANSITION("Transition");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

