/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.workflow.dto.v1_0.Creator;
import com.liferay.headless.admin.workflow.dto.v1_0.ObjectReviewed;
import com.liferay.headless.admin.workflow.dto.v1_0.Role;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a task to be executed in a workflow.", value="WorkflowTask")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WorkflowTask")
public class WorkflowTask
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Creator assigneePerson;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Role[] assigneeRoles;
    @GraphQLField(description="A flag that indicates whether the task is complete.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A flag that indicates whether the task is complete.") Boolean completed;
    @GraphQLField(description="The task's completion date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's completion date.") Date dateCompletion;
    @GraphQLField(description="The task's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's creation date.") Date dateCreated;
    @GraphQLField(description="The date the task should be completed by.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The date the task should be completed by.") Date dateDue;
    @GraphQLField(description="The task's description.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's description.") String description;
    @GraphQLField(description="The task's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's ID.") Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String label;
    @GraphQLField(description="The task's name.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's name.") String name;
    @GraphQLField(description="The object/asset that the task's workflow is managing.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object/asset that the task's workflow is managing.") ObjectReviewed objectReviewed;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long workflowDefinitionId;
    @GraphQLField(description="The name of the task's workflow definition.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The name of the task's workflow definition.") String workflowDefinitionName;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String workflowDefinitionVersion;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long workflowInstanceId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTask", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static WorkflowTask toDTO(String json) {
        return (WorkflowTask)ObjectMapperUtil.readValue(WorkflowTask.class, (String)json);
    }

    public static WorkflowTask unsafeToDTO(String json) {
        return (WorkflowTask)ObjectMapperUtil.unsafeReadValue(WorkflowTask.class, (String)json);
    }

    @Schema
    @Valid
    public Creator getAssigneePerson() {
        return this.assigneePerson;
    }

    public void setAssigneePerson(Creator assigneePerson) {
        this.assigneePerson = assigneePerson;
    }

    @JsonIgnore
    public void setAssigneePerson(UnsafeSupplier<Creator, Exception> assigneePersonUnsafeSupplier) {
        try {
            this.assigneePerson = (Creator)assigneePersonUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Role[] getAssigneeRoles() {
        return this.assigneeRoles;
    }

    public void setAssigneeRoles(Role[] assigneeRoles) {
        this.assigneeRoles = assigneeRoles;
    }

    @JsonIgnore
    public void setAssigneeRoles(UnsafeSupplier<Role[], Exception> assigneeRolesUnsafeSupplier) {
        try {
            this.assigneeRoles = (Role[])assigneeRolesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether the task is complete.")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @JsonIgnore
    public void setCompleted(UnsafeSupplier<Boolean, Exception> completedUnsafeSupplier) {
        try {
            this.completed = (Boolean)completedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's completion date.")
    public Date getDateCompletion() {
        return this.dateCompletion;
    }

    public void setDateCompletion(Date dateCompletion) {
        this.dateCompletion = dateCompletion;
    }

    @JsonIgnore
    public void setDateCompletion(UnsafeSupplier<Date, Exception> dateCompletionUnsafeSupplier) {
        try {
            this.dateCompletion = (Date)dateCompletionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the task should be completed by.")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    @JsonIgnore
    public void setDateDue(UnsafeSupplier<Date, Exception> dateDueUnsafeSupplier) {
        try {
            this.dateDue = (Date)dateDueUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @JsonIgnore
    public void setLabel(UnsafeSupplier<String, Exception> labelUnsafeSupplier) {
        try {
            this.label = (String)labelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The object/asset that the task's workflow is managing.")
    @Valid
    public ObjectReviewed getObjectReviewed() {
        return this.objectReviewed;
    }

    public void setObjectReviewed(ObjectReviewed objectReviewed) {
        this.objectReviewed = objectReviewed;
    }

    @JsonIgnore
    public void setObjectReviewed(UnsafeSupplier<ObjectReviewed, Exception> objectReviewedUnsafeSupplier) {
        try {
            this.objectReviewed = (ObjectReviewed)objectReviewedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    public void setWorkflowDefinitionId(Long workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
    }

    @JsonIgnore
    public void setWorkflowDefinitionId(UnsafeSupplier<Long, Exception> workflowDefinitionIdUnsafeSupplier) {
        try {
            this.workflowDefinitionId = (Long)workflowDefinitionIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The name of the task's workflow definition.")
    public String getWorkflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public void setWorkflowDefinitionName(String workflowDefinitionName) {
        this.workflowDefinitionName = workflowDefinitionName;
    }

    @JsonIgnore
    public void setWorkflowDefinitionName(UnsafeSupplier<String, Exception> workflowDefinitionNameUnsafeSupplier) {
        try {
            this.workflowDefinitionName = (String)workflowDefinitionNameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getWorkflowDefinitionVersion() {
        return this.workflowDefinitionVersion;
    }

    public void setWorkflowDefinitionVersion(String workflowDefinitionVersion) {
        this.workflowDefinitionVersion = workflowDefinitionVersion;
    }

    @JsonIgnore
    public void setWorkflowDefinitionVersion(UnsafeSupplier<String, Exception> workflowDefinitionVersionUnsafeSupplier) {
        try {
            this.workflowDefinitionVersion = (String)workflowDefinitionVersionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(Long workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    @JsonIgnore
    public void setWorkflowInstanceId(UnsafeSupplier<Long, Exception> workflowInstanceIdUnsafeSupplier) {
        try {
            this.workflowInstanceId = (Long)workflowInstanceIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkflowTask)) {
            return false;
        }
        WorkflowTask workflowTask = (WorkflowTask)object;
        return Objects.equals(this.toString(), workflowTask.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.assigneePerson != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assigneePerson\": ");
            sb.append(String.valueOf(this.assigneePerson));
        }
        if (this.assigneeRoles != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assigneeRoles\": ");
            sb.append("[");
            for (int i = 0; i < this.assigneeRoles.length; ++i) {
                sb.append(String.valueOf(this.assigneeRoles[i]));
                if (i + 1 >= this.assigneeRoles.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.completed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"completed\": ");
            sb.append((Object)this.completed);
        }
        if (this.dateCompletion != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCompletion\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCompletion));
            sb.append("\"");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateDue != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateDue\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateDue));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.description));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.label != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"label\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.label));
            sb.append("\"");
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.name));
            sb.append("\"");
        }
        if (this.objectReviewed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"objectReviewed\": ");
            sb.append(String.valueOf(this.objectReviewed));
        }
        if (this.workflowDefinitionId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"workflowDefinitionId\": ");
            sb.append((Object)this.workflowDefinitionId);
        }
        if (this.workflowDefinitionName != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"workflowDefinitionName\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.workflowDefinitionName));
            sb.append("\"");
        }
        if (this.workflowDefinitionVersion != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"workflowDefinitionVersion\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.workflowDefinitionVersion));
            sb.append("\"");
        }
        if (this.workflowInstanceId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"workflowInstanceId\": ");
            sb.append((Object)this.workflowInstanceId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WorkflowTask._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WorkflowTask._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WorkflowTask._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WorkflowTask._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

