/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.workflow.dto.v1_0.ObjectReviewed;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a task to be executed in a workflow.", value="WorkflowTask")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WorkflowTask")
public class WorkflowTask
implements Serializable {
    @GraphQLField(description="A flag that indicates whether the task is complete.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A flag that indicates whether the task is complete.") Boolean completed;
    @GraphQLField(description="The task's completion date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's completion date.") Date dateCompleted;
    @GraphQLField(description="The task's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's creation date.") Date dateCreated;
    @GraphQLField(description="The name of the task's workflow definition.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The name of the task's workflow definition.") String definitionName;
    @GraphQLField(description="The task's description.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's description.") String description;
    @GraphQLField(description="The date the task should be completed by.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The date the task should be completed by.") Date dueDate;
    @GraphQLField(description="The task's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's ID.") Long id;
    @GraphQLField(description="The task's name.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task's name.") String name;
    @GraphQLField(description="The object/asset that the task's workflow is managing.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object/asset that the task's workflow is managing.") ObjectReviewed objectReviewed;
    @GraphQLField(description="A list of transitions to be launched by the task's workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of transitions to be launched by the task's workflow.") String[] transitions;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.workflow.dto.v1_0.WorkflowTask", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static WorkflowTask toDTO(String json) {
        return (WorkflowTask)ObjectMapperUtil.readValue(WorkflowTask.class, (String)json);
    }

    public static WorkflowTask unsafeToDTO(String json) {
        return (WorkflowTask)ObjectMapperUtil.unsafeReadValue(WorkflowTask.class, (String)json);
    }

    @Schema(description="A flag that indicates whether the task is complete.")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @JsonIgnore
    public void setCompleted(UnsafeSupplier<Boolean, Exception> completedUnsafeSupplier) {
        try {
            this.completed = (Boolean)completedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's completion date.")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    @JsonIgnore
    public void setDateCompleted(UnsafeSupplier<Date, Exception> dateCompletedUnsafeSupplier) {
        try {
            this.dateCompleted = (Date)dateCompletedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The name of the task's workflow definition.")
    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    @JsonIgnore
    public void setDefinitionName(UnsafeSupplier<String, Exception> definitionNameUnsafeSupplier) {
        try {
            this.definitionName = (String)definitionNameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the task should be completed by.")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @JsonIgnore
    public void setDueDate(UnsafeSupplier<Date, Exception> dueDateUnsafeSupplier) {
        try {
            this.dueDate = (Date)dueDateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The object/asset that the task's workflow is managing.")
    @Valid
    public ObjectReviewed getObjectReviewed() {
        return this.objectReviewed;
    }

    public void setObjectReviewed(ObjectReviewed objectReviewed) {
        this.objectReviewed = objectReviewed;
    }

    @JsonIgnore
    public void setObjectReviewed(UnsafeSupplier<ObjectReviewed, Exception> objectReviewedUnsafeSupplier) {
        try {
            this.objectReviewed = (ObjectReviewed)objectReviewedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of transitions to be launched by the task's workflow.")
    public String[] getTransitions() {
        return this.transitions;
    }

    public void setTransitions(String[] transitions) {
        this.transitions = transitions;
    }

    @JsonIgnore
    public void setTransitions(UnsafeSupplier<String[], Exception> transitionsUnsafeSupplier) {
        try {
            this.transitions = (String[])transitionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkflowTask)) {
            return false;
        }
        WorkflowTask workflowTask = (WorkflowTask)object;
        return Objects.equals(this.toString(), workflowTask.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.completed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"completed\": ");
            sb.append((Object)this.completed);
        }
        if (this.dateCompleted != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCompleted\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCompleted));
            sb.append("\"");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.definitionName != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"definitionName\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.definitionName));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.description));
            sb.append("\"");
        }
        if (this.dueDate != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dueDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dueDate));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(WorkflowTask._escape(this.name));
            sb.append("\"");
        }
        if (this.objectReviewed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"objectReviewed\": ");
            sb.append(String.valueOf(this.objectReviewed));
        }
        if (this.transitions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"transitions\": ");
            sb.append("[");
            for (int i = 0; i < this.transitions.length; ++i) {
                sb.append("\"");
                sb.append(WorkflowTask._escape(this.transitions[i]));
                sb.append("\"");
                if (i + 1 >= this.transitions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WorkflowTask._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WorkflowTask._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WorkflowTask._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WorkflowTask._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

