/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Role;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseRoleResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.RoleResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.RoleAssignmentException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserGroupRoleService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/role.properties"}, scope=ServiceScope.PROTOTYPE, service={RoleResource.class})
public class RoleResourceImpl
extends BaseRoleResourceImpl {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Role)")
    private ModelResourcePermission<com.liferay.portal.kernel.model.Role> _roleModelResourcePermission;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserGroupRoleService _userGroupRoleService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserService _userService;

    @Override
    public void deleteOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
        this._checkRoleType(roleId, 3);
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        this._userGroupRoleService.deleteUserGroupRoles(userAccountId.longValue(), organization.getGroupId(), new long[]{roleId});
    }

    @Override
    public void deleteRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
        this._userService.deleteRoleUser(roleId.longValue(), userAccountId.longValue());
    }

    @Override
    public void deleteSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
        this._checkRoleType(roleId, 2);
        this._userGroupRoleService.deleteUserGroupRoles(userAccountId.longValue(), siteId.longValue(), new long[]{roleId});
    }

    @Override
    public Role getRole(Long roleId) throws Exception {
        com.liferay.portal.kernel.model.Role role = this._roleService.fetchRole(roleId.longValue());
        if (role == null) {
            throw new NoSuchRoleException("No role exists with role ID " + roleId);
        }
        return this._toRole(this._roleService.getRole(roleId.longValue()));
    }

    @Override
    public Page<Role> getRolesPage(Integer[] types, String search, Pagination pagination) throws Exception {
        if (types == null) {
            types = new Integer[]{3, 1, 2};
        }
        return Page.of((Map)HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getRolesPage", Role.class.getName(), 0L)).build(), this.transform(this._roleService.search(this.contextCompany.getCompanyId(), search, types, null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toRole), (Pagination)pagination, (long)this._roleService.searchCount(this.contextCompany.getCompanyId(), search, types, null));
    }

    @Override
    public void postOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
        this._checkRoleType(roleId, 3);
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        this._userGroupRoleService.addUserGroupRoles(userAccountId.longValue(), organization.getGroupId(), new long[]{roleId});
    }

    @Override
    public void postRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
        this._checkRoleType(roleId, 1);
        this._userService.addRoleUsers(roleId.longValue(), new long[]{userAccountId});
    }

    @Override
    public void postSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
        this._checkRoleType(roleId, 2);
        this._userGroupRoleService.addUserGroupRoles(userAccountId.longValue(), siteId.longValue(), new long[]{roleId});
    }

    private void _checkRoleType(long roleId, int type) throws Exception {
        com.liferay.portal.kernel.model.Role serviceBuilderRole = this._roleService.getRole(roleId);
        if (serviceBuilderRole.getType() != type) {
            throw new RoleAssignmentException(StringBundler.concat((String[])new String[]{"Role type ", RoleConstants.getTypeLabel((int)serviceBuilderRole.getType()), " is not role type ", RoleConstants.getTypeLabel((int)type)}));
        }
    }

    private Map<String, Map<String, String>> _getActions(Long roleId) {
        return HashMapBuilder.put((Object)"create-organization-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "postOrganizationRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"create-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "postRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"create-site-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "postSiteRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"delete-organization-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "deleteOrganizationRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"delete-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "deleteRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"delete-site-role-user-account-association", this.addAction("ASSIGN_MEMBERS", roleId, "deleteSiteRoleUserAccountAssociation", this._roleModelResourcePermission)).put((Object)"get", this.addAction("VIEW", roleId, "getRole", this._roleModelResourcePermission)).build();
    }

    private Role _toRole(final com.liferay.portal.kernel.model.Role role) throws Exception {
        return new Role(){
            {
                this.actions = RoleResourceImpl.this._getActions(role.getRoleId());
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])role.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(RoleResourceImpl.this._portal, RoleResourceImpl.this._userLocalService.fetchUser(role.getUserId()));
                this.dateCreated = role.getCreateDate();
                this.dateModified = role.getModifiedDate();
                this.description = role.getDescription(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)RoleResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getDescriptionMap());
                this.id = role.getRoleId();
                this.name = role.getTitle(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)RoleResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getTitleMap());
                this.roleType = role.getTypeLabel();
            }
        };
    }
}

