/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseOrganizationResourceImpl
implements EntityModelResource,
OrganizationResource,
VulcanBatchEngineTaskItemDelegate<Organization> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Organization>, UnsafeConsumer<Organization, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseOrganizationResourceImpl.class);

    @Operation(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/organizations")
    @Produces(value={"application/json", "application/xml"})
    public Page<Organization> getAccountByExternalReferenceCodeOrganizationsPage(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountByExternalReferenceCodeOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/organizations/{organizationId}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountByExternalReferenceCodeOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
    }

    @Operation(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/accounts/{accountId}/organizations")
    @Produces(value={"application/json", "application/xml"})
    public Page<Organization> getAccountOrganizationsPage(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @DELETE
    @Path(value="/accounts/{accountId}/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @Path(value="/accounts/{accountId}/organizations/{organizationId}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
    }

    @Operation(description="Retrieves the organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/organizations")
    @Produces(value={"application/json", "application/xml"})
    public Page<Organization> getOrganizationsPage(@Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new organization")
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Organization postOrganization(Organization organization) throws Exception {
        return new Organization();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json"})
    @Path(value="/organizations/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postOrganizationBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Organization.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes an organization.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Organization")})
    @DELETE
    @Path(value="/organizations/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteOrganizationByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/organizations/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Organization getOrganizationByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Organization();
    }

    @Operation(description="Updates the organization with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/organizations/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Organization patchOrganizationByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Organization organization) throws Exception {
        Organization existingOrganization = this.getOrganizationByExternalReferenceCode(externalReferenceCode);
        if (organization.getActions() != null) {
            existingOrganization.setActions(organization.getActions());
        }
        if (organization.getComment() != null) {
            existingOrganization.setComment(organization.getComment());
        }
        if (organization.getDateCreated() != null) {
            existingOrganization.setDateCreated(organization.getDateCreated());
        }
        if (organization.getDateModified() != null) {
            existingOrganization.setDateModified(organization.getDateModified());
        }
        if (organization.getExternalReferenceCode() != null) {
            existingOrganization.setExternalReferenceCode(organization.getExternalReferenceCode());
        }
        if (organization.getImage() != null) {
            existingOrganization.setImage(organization.getImage());
        }
        if (organization.getKeywords() != null) {
            existingOrganization.setKeywords(organization.getKeywords());
        }
        if (organization.getName() != null) {
            existingOrganization.setName(organization.getName());
        }
        if (organization.getNumberOfAccounts() != null) {
            existingOrganization.setNumberOfAccounts(organization.getNumberOfAccounts());
        }
        if (organization.getNumberOfOrganizations() != null) {
            existingOrganization.setNumberOfOrganizations(organization.getNumberOfOrganizations());
        }
        if (organization.getNumberOfUsers() != null) {
            existingOrganization.setNumberOfUsers(organization.getNumberOfUsers());
        }
        this.preparePatch(organization, existingOrganization);
        return this.putOrganizationByExternalReferenceCode(externalReferenceCode, existingOrganization);
    }

    @Operation(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Organization putOrganizationByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Organization organization) throws Exception {
        return new Organization();
    }

    @Operation(description="Deletes an organization.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @DELETE
    @Path(value="/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/organizations/batch")
    @Produces(value={"application/json"})
    public Response deleteOrganizationBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Organization.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the organization.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    public Organization getOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId) throws Exception {
        return new Organization();
    }

    @Operation(description="Updates the organization with the information sent in the request body. Fields not present in the request body are left unchanged.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    public Organization patchOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, Organization organization) throws Exception {
        Organization existingOrganization = this.getOrganization(organizationId);
        if (organization.getActions() != null) {
            existingOrganization.setActions(organization.getActions());
        }
        if (organization.getComment() != null) {
            existingOrganization.setComment(organization.getComment());
        }
        if (organization.getDateCreated() != null) {
            existingOrganization.setDateCreated(organization.getDateCreated());
        }
        if (organization.getDateModified() != null) {
            existingOrganization.setDateModified(organization.getDateModified());
        }
        if (organization.getExternalReferenceCode() != null) {
            existingOrganization.setExternalReferenceCode(organization.getExternalReferenceCode());
        }
        if (organization.getImage() != null) {
            existingOrganization.setImage(organization.getImage());
        }
        if (organization.getKeywords() != null) {
            existingOrganization.setKeywords(organization.getKeywords());
        }
        if (organization.getName() != null) {
            existingOrganization.setName(organization.getName());
        }
        if (organization.getNumberOfAccounts() != null) {
            existingOrganization.setNumberOfAccounts(organization.getNumberOfAccounts());
        }
        if (organization.getNumberOfOrganizations() != null) {
            existingOrganization.setNumberOfOrganizations(organization.getNumberOfOrganizations());
        }
        if (organization.getNumberOfUsers() != null) {
            existingOrganization.setNumberOfUsers(organization.getNumberOfUsers());
        }
        this.preparePatch(organization, existingOrganization);
        return this.putOrganization(organizationId, existingOrganization);
    }

    @Operation(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations/{organizationId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Organization putOrganization(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, Organization organization) throws Exception {
        return new Organization();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json"})
    @Path(value="/organizations/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putOrganizationBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Organization.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/organizations/{organizationId}/child-organizations")
    @Produces(value={"application/json", "application/xml"})
    public Page<Organization> getOrganizationChildOrganizationsPage(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Removes users from an organization by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/organizations/{organizationId}/user-accounts/by-email-address")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserAccountsByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, String[] strings) throws Exception {
    }

    @Operation(description="Assigns users to an organization by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.QUERY, name="organizationRoleIds")})
    @Tags(value={@Tag(name="Organization")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations/{organizationId}/user-accounts/by-email-address")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> postUserAccountsByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @QueryParam(value="organizationRoleIds") String organizationRoleIds, String[] strings) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Removes a user from an organization by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="Organization")})
    @DELETE
    @Path(value="/organizations/{organizationId}/user-accounts/by-email-address/{emailAddress}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Assigns a user to an organization by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="Organization")})
    @Path(value="/organizations/{organizationId}/user-accounts/by-email-address/{emailAddress}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserAccount postUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
        return new UserAccount();
    }

    @Operation(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentOrganizationId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Organization")})
    @GET
    @Path(value="/organizations/{parentOrganizationId}/organizations")
    @Produces(value={"application/json", "application/xml"})
    public Page<Organization> getOrganizationOrganizationsPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentOrganizationId") String parentOrganizationId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void create(Collection<Organization> organizations, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer organizationUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            organizationUnsafeConsumer = organization -> this.postOrganization((Organization)organization);
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            organizationUnsafeConsumer = organization -> this.putOrganizationByExternalReferenceCode(organization.getExternalReferenceCode(), (Organization)organization);
        }
        if (organizationUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Organization");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(organizations, (Object)organizationUnsafeConsumer);
        } else {
            for (Organization organization2 : organizations) {
                organizationUnsafeConsumer.accept((Object)organization2);
            }
        }
    }

    public void delete(Collection<Organization> organizations, Map<String, Serializable> parameters) throws Exception {
        for (Organization organization : organizations) {
            this.deleteOrganization(organization.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Organization> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("accountId")) {
            return this.getAccountOrganizationsPage(Long.parseLong((String)((Object)parameters.get("accountId"))), search, filter, pagination, sorts);
        }
        return this.getOrganizationsPage(Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Organization> organizations, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer organizationUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            organizationUnsafeConsumer = organization -> this.patchOrganization(organization.getId() != null ? organization.getId() : (String)parameters.get("organizationId"), (Organization)organization);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            organizationUnsafeConsumer = organization -> this.putOrganization(organization.getId() != null ? organization.getId() : (String)parameters.get("organizationId"), (Organization)organization);
        }
        if (organizationUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Organization");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(organizations, (Object)organizationUnsafeConsumer);
        } else {
            for (Organization organization2 : organizations) {
                organizationUnsafeConsumer.accept((Object)organization2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Organization>, UnsafeConsumer<Organization, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(Organization organization, Organization existingOrganization) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

