/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.AccountRole;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseAccountRoleResourceImpl
implements AccountRoleResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<AccountRole> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<AccountRole>, UnsafeConsumer<AccountRole, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseAccountRoleResourceImpl.class);

    @Operation(description="Unassigns account users by external reference code from the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="userAccountExternalReferenceCode")})
    @Tags(value={@Tag(name="AccountRole")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{accountExternalReferenceCode}/account-roles/{accountRoleId}/user-accounts/by-external-reference-code/{userAccountExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="accountExternalReferenceCode") String accountExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
    }

    @Operation(description="Assigns account users by external reference code to the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="userAccountExternalReferenceCode")})
    @Tags(value={@Tag(name="AccountRole")})
    @Path(value="/accounts/by-external-reference-code/{accountExternalReferenceCode}/account-roles/{accountRoleId}/user-accounts/by-external-reference-code/{userAccountExternalReferenceCode}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="accountExternalReferenceCode") String accountExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
    }

    @Operation(description="Gets a user's account roles by their external reference code from an account by external reference code")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="userAccountExternalReferenceCode")})
    @Tags(value={@Tag(name="AccountRole")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{accountExternalReferenceCode}/user-accounts/by-external-reference-code/{userAccountExternalReferenceCode}/account-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<AccountRole> getAccountByExternalReferenceCodeUserAccountByExternalReferenceCodeAccountRolesPage(@Parameter(hidden=true) @NotNull @PathParam(value="accountExternalReferenceCode") String accountExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Gets the account's roles")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="AccountRole")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/account-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<AccountRole> getAccountAccountRolesByExternalReferenceCodePage(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Adds a role for the account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AccountRole")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/account-roles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AccountRole postAccountAccountRoleByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, AccountRole accountRole) throws Exception {
        return new AccountRole();
    }

    @Operation(description="Unassigns account users by email address from the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="AccountRole")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/account-roles/{accountRoleId}/user-accounts/by-email-address/{emailAddress}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Assigns account users by email address to the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="AccountRole")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/account-roles/{accountRoleId}/user-accounts/by-email-address/{emailAddress}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Gets a user's account roles by their email address from an account by external reference code")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="AccountRole")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts/by-email-address/{emailAddress}/account-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<AccountRole> getAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPage(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Gets the account's roles")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="AccountRole")})
    @GET
    @Path(value="/accounts/{accountId}/account-roles")
    @Produces(value={"application/json", "application/xml"})
    public Page<AccountRole> getAccountAccountRolesPage(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Adds a role for the account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="AccountRole")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/{accountId}/account-roles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AccountRole postAccountAccountRole(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, AccountRole accountRole) throws Exception {
        return new AccountRole();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AccountRole")})
    @Consumes(value={"application/json"})
    @Path(value="/accounts/{accountId}/account-roles/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAccountAccountRoleBatch(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(AccountRole.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Unassigns account users to the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="AccountRole")})
    @DELETE
    @Path(value="/accounts/{accountId}/account-roles/{accountRoleId}/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountAccountRoleUserAccountAssociation(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId) throws Exception {
    }

    @Operation(description="Assigns account users to the account role")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="accountRoleId"), @Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="AccountRole")})
    @Path(value="/accounts/{accountId}/account-roles/{accountRoleId}/user-accounts/{userAccountId}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountAccountRoleUserAccountAssociation(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="accountRoleId") Long accountRoleId, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId) throws Exception {
    }

    public void create(Collection<AccountRole> accountRoles, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer accountRoleUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("accountId")) {
                accountRoleUnsafeConsumer = accountRole -> this.postAccountAccountRole(Long.parseLong((String)parameters.get("accountId")), (AccountRole)accountRole);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [accountId]");
            }
        }
        if (accountRoleUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for AccountRole");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(accountRoles, (Object)accountRoleUnsafeConsumer);
        } else {
            for (AccountRole accountRole2 : accountRoles) {
                accountRoleUnsafeConsumer.accept((Object)accountRole2);
            }
        }
    }

    public void delete(Collection<AccountRole> accountRoles, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<AccountRole> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("accountId")) {
            return this.getAccountAccountRolesPage(Long.parseLong((String)((Object)parameters.get("accountId"))), (String)((Object)parameters.get("keywords")), filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [accountId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<AccountRole> accountRoles, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<AccountRole>, UnsafeConsumer<AccountRole, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

