/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.headless.admin.user.dto.v1_0.AccountRole;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.UserResourceDTOConverter;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.AccountRoleEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseAccountRoleResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-role.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountRoleResource.class})
public class AccountRoleResourceImpl
extends BaseAccountRoleResourceImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    private final EntityModel _entityModel = new AccountRoleEntityModel();
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserResourceDTOConverter _userResourceDTOConverter;

    @Override
    public void deleteAccountAccountRoleUserAccountAssociation(Long accountId, Long accountRoleId, Long userAccountId) throws Exception {
        this._accountRoleLocalService.unassociateUser(accountId.longValue(), accountRoleId.longValue(), userAccountId.longValue());
    }

    @Override
    public void deleteAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(String externalReferenceCode, Long accountRoleId, String emailAddress) throws Exception {
        User user = this._userLocalService.getUserByEmailAddress(this.contextCompany.getCompanyId(), emailAddress);
        this.deleteAccountAccountRoleUserAccountAssociation(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), accountRoleId, user.getUserId());
    }

    @Override
    public void deleteAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(String accountExternalReferenceCode, Long accountRoleId, String userAccountExternalReferenceCode) throws Exception {
        this.deleteAccountAccountRoleUserAccountAssociation(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), accountRoleId, this._userResourceDTOConverter.getUserId(userAccountExternalReferenceCode));
    }

    @Override
    public Page<AccountRole> getAccountAccountRolesByExternalReferenceCodePage(String externalReferenceCode, String keywords, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getAccountAccountRolesPage(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), keywords, filter, pagination, sorts);
    }

    @Override
    public Page<AccountRole> getAccountAccountRolesPage(Long accountId, String keywords, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (accountId > 0L) {
            this._accountEntryLocalService.getAccountEntry(accountId.longValue());
        }
        try (SafeCloseable safeCloseable = AccountRolePermissionThreadLocal.setWithSafeCloseable((long)accountId);){
            Page page = SearchUtil.search(null, booleanQuery -> {
                BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
                TermsFilter termsFilter = new TermsFilter("accountEntryId");
                termsFilter.addValues(ArrayUtil.toStringArray((long[])new long[]{0L, accountId}));
                preBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
            }, (Filter)filter, (String)com.liferay.account.model.AccountRole.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> {}, searchContext -> {
                searchContext.setCompanyId(this.contextCompany.getCompanyId());
                if (Validator.isNotNull((String)keywords)) {
                    searchContext.setKeywords(keywords);
                }
            }, (Sort[])sorts, document -> this._toAccountRole(this._accountRoleLocalService.getAccountRole(GetterUtil.getLong((String)document.get("entryClassPK")))));
            return page;
        }
    }

    @Override
    public Page<AccountRole> getAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPage(String externalReferenceCode, String emailAddress) throws Exception {
        User user = this._userLocalService.getUserByEmailAddress(this.contextCompany.getCompanyId(), emailAddress);
        return Page.of(this.transform(this._accountRoleLocalService.getAccountRoles(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), user.getUserId()), accountRole -> this._toAccountRole((com.liferay.account.model.AccountRole)accountRole)));
    }

    @Override
    public Page<AccountRole> getAccountByExternalReferenceCodeUserAccountByExternalReferenceCodeAccountRolesPage(String accountExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        return Page.of(this.transform(this._accountRoleLocalService.getAccountRoles(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), this._userResourceDTOConverter.getUserId(userAccountExternalReferenceCode)), accountRole -> this._toAccountRole((com.liferay.account.model.AccountRole)accountRole)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return this._entityModel;
    }

    @Override
    public AccountRole postAccountAccountRole(Long accountId, AccountRole accountRole) throws Exception {
        return this._toAccountRole(this._accountRoleLocalService.addAccountRole(this.contextUser.getUserId(), accountId.longValue(), accountRole.getName(), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), accountRole.getDisplayName()), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), accountRole.getDescription())));
    }

    @Override
    public AccountRole postAccountAccountRoleByExternalReferenceCode(String externalReferenceCode, AccountRole accountRole) throws Exception {
        return this.postAccountAccountRole(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), accountRole);
    }

    @Override
    public void postAccountAccountRoleUserAccountAssociation(Long accountId, Long accountRoleId, Long userAccountId) throws Exception {
        this._accountRoleLocalService.associateUser(accountId.longValue(), accountRoleId.longValue(), userAccountId.longValue());
    }

    @Override
    public void postAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(String externalReferenceCode, Long accountRoleId, String emailAddress) throws Exception {
        User user = this._userLocalService.getUserByEmailAddress(this.contextCompany.getCompanyId(), emailAddress);
        this.postAccountAccountRoleUserAccountAssociation(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), accountRoleId, user.getUserId());
    }

    @Override
    public void postAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(String accountExternalReferenceCode, Long accountRoleId, String userAccountExternalReferenceCode) throws Exception {
        this.postAccountAccountRoleUserAccountAssociation(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), accountRoleId, this._userResourceDTOConverter.getUserId(userAccountExternalReferenceCode));
    }

    private AccountRole _toAccountRole(final com.liferay.account.model.AccountRole serviceBuilderAccountRole) throws Exception {
        final Role role = serviceBuilderAccountRole.getRole();
        return new AccountRole(){
            {
                this.accountId = serviceBuilderAccountRole.getAccountEntryId();
                this.description = role.getDescription(AccountRoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.displayName = role.getTitle(AccountRoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = serviceBuilderAccountRole.getAccountRoleId();
                this.name = serviceBuilderAccountRole.getRoleName();
                this.roleId = serviceBuilderAccountRole.getRoleId();
            }
        };
    }
}

