/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.OrganizationResourceDTOConverter;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.AccountEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class, NestedFieldSupport.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl
implements NestedFieldSupport {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    private final EntityModel _entityModel = new AccountEntityModel();
    @Reference
    private OrganizationResourceDTOConverter _organizationResourceDTOConverter;

    @Override
    public void deleteAccount(Long accountId) throws Exception {
        this._accountEntryService.deleteAccountEntry(accountId.longValue());
    }

    @Override
    public void deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        this.deleteAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode));
    }

    @Override
    public void deleteOrganizationAccounts(Long organizationId, Long[] accountIds) throws Exception {
        for (Long accountId : accountIds) {
            this._accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel(accountId.longValue(), organizationId.longValue());
        }
    }

    @Override
    public void deleteOrganizationAccountsByExternalReferenceCode(Long organizationId, String[] externalReferenceCodes) throws Exception {
        for (String externalReferenceCode : externalReferenceCodes) {
            this._accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), organizationId.longValue());
        }
    }

    @Override
    public Account getAccount(Long accountId) throws Exception {
        return this._toAccount(this._accountEntryService.getAccountEntry(accountId.longValue()));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this.getAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode));
    }

    @Override
    public Page<Account> getAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_ACCOUNT_ENTRY", "postAccount", "90", 0L)).put((Object)"create-by-external-reference-code", this.addAction("ADD_ACCOUNT_ENTRY", "putAccountByExternalReferenceCode", "90", 0L)).put((Object)"get", this.addAction("VIEW", 0L, "getAccountsPage", this._accountEntryModelResourcePermission)).build(), booleanQuery -> {}, (Filter)filter, (String)AccountEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
        }, (Sort[])sorts, document -> {
            long accountEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toAccount(this._accountEntryService.getAccountEntry(accountEntryId));
        });
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModel;
    }

    @Override
    @NestedField(parentClass=Organization.class, value="organizationAccounts")
    public Page<Account> getOrganizationAccountsPage(String organizationId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        com.liferay.portal.kernel.model.Organization organization = this._organizationResourceDTOConverter.getObject(organizationId);
        return this._getOrganizationAccountsPage(Collections.emptyMap(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("organizationIds", String.valueOf(organization.getOrganizationId())), BooleanClauseOccur.MUST);
        }), search, filter, pagination, sorts);
    }

    @Override
    public void patchOrganizationMoveAccounts(Long sourceOrganizationId, Long targetOrganizationId, Long[] accountIds) throws Exception {
        this.deleteOrganizationAccounts(sourceOrganizationId, accountIds);
        this.postOrganizationAccounts(targetOrganizationId, accountIds);
    }

    @Override
    public void patchOrganizationMoveAccountsByExternalReferenceCode(Long sourceOrganizationId, Long targetOrganizationId, String[] externalReferenceCodes) throws Exception {
        this.deleteOrganizationAccountsByExternalReferenceCode(sourceOrganizationId, externalReferenceCodes);
        this.postOrganizationAccountsByExternalReferenceCode(targetOrganizationId, externalReferenceCodes);
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.addAccountEntry(this.contextUser.getUserId(), this._getParentAccountId(account), account.getName(), account.getDescription(), this._getDomains(account), null, null, null, this._getType(account), this._getStatus(account), null);
        accountEntry = this._accountEntryService.updateExternalReferenceCode(accountEntry.getAccountEntryId(), account.getExternalReferenceCode());
        this._accountEntryOrganizationRelLocalService.setAccountEntryOrganizationRels(accountEntry.getAccountEntryId(), this._getOrganizationIds(account));
        return this._toAccount(accountEntry);
    }

    @Override
    public void postOrganizationAccounts(Long organizationId, Long[] accountIds) throws Exception {
        for (Long accountId : accountIds) {
            this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(accountId.longValue(), organizationId.longValue());
        }
    }

    @Override
    public void postOrganizationAccountsByExternalReferenceCode(Long organizationId, String[] externalReferenceCodes) throws Exception {
        for (String externalReferenceCode : externalReferenceCodes) {
            this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), organizationId.longValue());
        }
    }

    @Override
    public Account putAccount(Long accountId, Account account) throws Exception {
        this._accountEntryService.updateExternalReferenceCode(accountId.longValue(), account.getExternalReferenceCode());
        this._accountEntryOrganizationRelLocalService.setAccountEntryOrganizationRels(accountId.longValue(), this._getOrganizationIds(account));
        return this._toAccount(this._accountEntryService.updateAccountEntry(accountId.longValue(), this._getParentAccountId(account), account.getName(), account.getDescription(), false, this._getDomains(account), null, null, null, this._getStatus(account), null));
    }

    @Override
    public Account putAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        return this._toAccount(this._accountEntryService.addOrUpdateAccountEntry(externalReferenceCode, this.contextUser.getUserId(), this._getParentAccountId(account), account.getName(), account.getDescription(), this._getDomains(account), null, null, null, this._getType(account), this._getStatus(account), null));
    }

    private String[] _getDomains(Account account) {
        return Optional.ofNullable(account.getDomains()).orElse(new String[0]);
    }

    private DTOConverterContext _getDTOConverterContext(long accountEntryId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"create-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "postOrganizationAccounts", this._accountEntryModelResourcePermission)).put((Object)"create-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "postOrganizationAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"delete", this.addAction("DELETE", accountEntryId, "deleteAccount", this._accountEntryModelResourcePermission)).put((Object)"delete-by-external-reference-code", this.addAction("DELETE", accountEntryId, "deleteAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"delete-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "deleteOrganizationAccounts", this._accountEntryModelResourcePermission)).put((Object)"delete-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "deleteOrganizationAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", accountEntryId, "getAccount", this._accountEntryModelResourcePermission)).put((Object)"get-by-external-reference-code", this.addAction("VIEW", accountEntryId, "getAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"move-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "patchOrganizationMoveAccounts", this._accountEntryModelResourcePermission)).put((Object)"move-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "patchOrganizationMoveAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"replace", this.addAction("UPDATE", accountEntryId, "putAccount", this._accountEntryModelResourcePermission)).put((Object)"replace-by-external-reference-code", this.addAction("UPDATE", accountEntryId, "putAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", accountEntryId, "patchAccount", this._accountEntryModelResourcePermission)).put((Object)"update-by-external-reference-code", this.addAction("UPDATE", accountEntryId, "patchAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).build(), null, this.contextHttpServletRequest, (Object)accountEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private Page<Account> _getOrganizationAccountsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)filter, (String)AccountEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toAccount(this._accountEntryService.getAccountEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private long[] _getOrganizationIds(Account account) {
        return Optional.ofNullable(account.getOrganizationIds()).map(ArrayUtil::toArray).orElse(new long[0]);
    }

    private long _getParentAccountId(Account account) {
        return Optional.ofNullable(account.getParentAccountId()).orElse(0L);
    }

    private int _getStatus(Account account) {
        return Optional.ofNullable(account.getStatus()).orElse(0);
    }

    private String _getType(Account account) {
        return Optional.ofNullable(account.getTypeAsString()).orElse("business");
    }

    private Account _toAccount(AccountEntry accountEntry) throws Exception {
        return (Account)this._accountResourceDTOConverter.toDTO(this._getDTOConverterContext(accountEntry.getAccountEntryId()));
    }
}

