/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.graphql.mutation.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.AccountRole;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.UserGroup;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.headless.admin.user.resource.v1_0.RoleResource;
import com.liferay.headless.admin.user.resource.v1_0.SubscriptionResource;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.headless.admin.user.resource.v1_0.UserGroupResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.Collection;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Mutation {
    private static ComponentServiceObjects<AccountResource> _accountResourceComponentServiceObjects;
    private static ComponentServiceObjects<AccountRoleResource> _accountRoleResourceComponentServiceObjects;
    private static ComponentServiceObjects<OrganizationResource> _organizationResourceComponentServiceObjects;
    private static ComponentServiceObjects<RoleResource> _roleResourceComponentServiceObjects;
    private static ComponentServiceObjects<SubscriptionResource> _subscriptionResourceComponentServiceObjects;
    private static ComponentServiceObjects<UserAccountResource> _userAccountResourceComponentServiceObjects;
    private static ComponentServiceObjects<UserGroupResource> _userGroupResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;
    private VulcanBatchEngineImportTaskResource _vulcanBatchEngineImportTaskResource;

    public static void setAccountResourceComponentServiceObjects(ComponentServiceObjects<AccountResource> accountResourceComponentServiceObjects) {
        _accountResourceComponentServiceObjects = accountResourceComponentServiceObjects;
    }

    public static void setAccountRoleResourceComponentServiceObjects(ComponentServiceObjects<AccountRoleResource> accountRoleResourceComponentServiceObjects) {
        _accountRoleResourceComponentServiceObjects = accountRoleResourceComponentServiceObjects;
    }

    public static void setOrganizationResourceComponentServiceObjects(ComponentServiceObjects<OrganizationResource> organizationResourceComponentServiceObjects) {
        _organizationResourceComponentServiceObjects = organizationResourceComponentServiceObjects;
    }

    public static void setRoleResourceComponentServiceObjects(ComponentServiceObjects<RoleResource> roleResourceComponentServiceObjects) {
        _roleResourceComponentServiceObjects = roleResourceComponentServiceObjects;
    }

    public static void setSubscriptionResourceComponentServiceObjects(ComponentServiceObjects<SubscriptionResource> subscriptionResourceComponentServiceObjects) {
        _subscriptionResourceComponentServiceObjects = subscriptionResourceComponentServiceObjects;
    }

    public static void setUserAccountResourceComponentServiceObjects(ComponentServiceObjects<UserAccountResource> userAccountResourceComponentServiceObjects) {
        _userAccountResourceComponentServiceObjects = userAccountResourceComponentServiceObjects;
    }

    public static void setUserGroupResourceComponentServiceObjects(ComponentServiceObjects<UserGroupResource> userGroupResourceComponentServiceObjects) {
        _userGroupResourceComponentServiceObjects = userGroupResourceComponentServiceObjects;
    }

    @GraphQLField(description="Creates a new account")
    public @GraphQLField(description="Creates a new account") Account createAccount(@GraphQLName(value="account") Account account) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.postAccount(account));
    }

    @GraphQLField
    public Response createAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.postAccountBatch(callbackURL, object));
    }

    @GraphQLField(description="Deletes an account.")
    public @GraphQLField(description="Deletes an account.") boolean deleteAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.deleteAccountByExternalReferenceCode(externalReferenceCode));
        return true;
    }

    @GraphQLField(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    public @GraphQLField(description="Updates the account with information sent in the request body. Only the provided fields are updated.") Account patchAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="account") Account account) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.patchAccountByExternalReferenceCode(externalReferenceCode, account));
    }

    @GraphQLField(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.") Account updateAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="account") Account account) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.putAccountByExternalReferenceCode(externalReferenceCode, account));
    }

    @GraphQLField(description="Deletes an account.")
    public @GraphQLField(description="Deletes an account.") boolean deleteAccount(@GraphQLName(value="accountId") Long accountId) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.deleteAccount(accountId));
        return true;
    }

    @GraphQLField
    public Response deleteAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.deleteAccountBatch(callbackURL, object));
    }

    @GraphQLField(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    public @GraphQLField(description="Updates the account with information sent in the request body. Only the provided fields are updated.") Account patchAccount(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="account") Account account) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.patchAccount(accountId, account));
    }

    @GraphQLField(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.") Account updateAccount(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="account") Account account) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.putAccount(accountId, account));
    }

    @GraphQLField
    public Response updateAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.putAccountBatch(callbackURL, object));
    }

    @GraphQLField
    public boolean patchOrganizationMoveAccounts(@GraphQLName(value="sourceOrganizationId") Long sourceOrganizationId, @GraphQLName(value="targetOrganizationId") Long targetOrganizationId, @GraphQLName(value="longs") Long[] longs) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.patchOrganizationMoveAccounts(sourceOrganizationId, targetOrganizationId, longs));
        return true;
    }

    @GraphQLField
    public boolean patchOrganizationMoveAccountsByExternalReferenceCode(@GraphQLName(value="sourceOrganizationId") Long sourceOrganizationId, @GraphQLName(value="targetOrganizationId") Long targetOrganizationId, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.patchOrganizationMoveAccountsByExternalReferenceCode(sourceOrganizationId, targetOrganizationId, strings));
        return true;
    }

    @GraphQLField
    public boolean deleteOrganizationAccounts(@GraphQLName(value="organizationId") Long organizationId, @GraphQLName(value="longs") Long[] longs) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.deleteOrganizationAccounts(organizationId, longs));
        return true;
    }

    @GraphQLField
    public boolean createOrganizationAccounts(@GraphQLName(value="organizationId") Long organizationId, @GraphQLName(value="longs") Long[] longs) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.postOrganizationAccounts(organizationId, longs));
        return true;
    }

    @GraphQLField
    public boolean deleteOrganizationAccountsByExternalReferenceCode(@GraphQLName(value="organizationId") Long organizationId, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.deleteOrganizationAccountsByExternalReferenceCode(organizationId, strings));
        return true;
    }

    @GraphQLField
    public boolean createOrganizationAccountsByExternalReferenceCode(@GraphQLName(value="organizationId") Long organizationId, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.postOrganizationAccountsByExternalReferenceCode(organizationId, strings));
        return true;
    }

    @GraphQLField(description="Unassigns account users by external reference code from the account role")
    public @GraphQLField(description="Unassigns account users by external reference code from the account role") boolean deleteAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(@GraphQLName(value="accountExternalReferenceCode") String accountExternalReferenceCode, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.deleteAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(accountExternalReferenceCode, accountRoleId, userAccountExternalReferenceCode));
        return true;
    }

    @GraphQLField(description="Assigns account users by external reference code to the account role")
    public @GraphQLField(description="Assigns account users by external reference code to the account role") boolean createAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(@GraphQLName(value="accountExternalReferenceCode") String accountExternalReferenceCode, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountByExternalReferenceCodeAccountRoleUserAccountByExternalReferenceCode(accountExternalReferenceCode, accountRoleId, userAccountExternalReferenceCode));
        return true;
    }

    @GraphQLField(description="Adds a role for the account")
    public @GraphQLField(description="Adds a role for the account") AccountRole createAccountAccountRoleByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="accountRole") AccountRole accountRole) throws Exception {
        return (AccountRole)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountAccountRoleByExternalReferenceCode(externalReferenceCode, accountRole));
    }

    @GraphQLField(description="Unassigns account users by email address from the account role")
    public @GraphQLField(description="Unassigns account users by email address from the account role") boolean deleteAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.deleteAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(externalReferenceCode, accountRoleId, emailAddress));
        return true;
    }

    @GraphQLField(description="Assigns account users by email address to the account role")
    public @GraphQLField(description="Assigns account users by email address to the account role") boolean createAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(externalReferenceCode, accountRoleId, emailAddress));
        return true;
    }

    @GraphQLField(description="Adds a role for the account")
    public @GraphQLField(description="Adds a role for the account") AccountRole createAccountAccountRole(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="accountRole") AccountRole accountRole) throws Exception {
        return (AccountRole)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountAccountRole(accountId, accountRole));
    }

    @GraphQLField
    public Response createAccountAccountRoleBatch(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountAccountRoleBatch(accountId, callbackURL, object));
    }

    @GraphQLField(description="Unassigns account users to the account role")
    public @GraphQLField(description="Unassigns account users to the account role") boolean deleteAccountAccountRoleUserAccountAssociation(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.deleteAccountAccountRoleUserAccountAssociation(accountId, accountRoleId, userAccountId));
        return true;
    }

    @GraphQLField(description="Assigns account users to the account role")
    public @GraphQLField(description="Assigns account users to the account role") boolean createAccountAccountRoleUserAccountAssociation(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="accountRoleId") Long accountRoleId, @GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        this._applyVoidComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> accountRoleResource.postAccountAccountRoleUserAccountAssociation(accountId, accountRoleId, userAccountId));
        return true;
    }

    @GraphQLField
    public boolean deleteAccountByExternalReferenceCodeOrganization(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="organizationId") String organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteAccountByExternalReferenceCodeOrganization(externalReferenceCode, organizationId));
        return true;
    }

    @GraphQLField
    public boolean createAccountByExternalReferenceCodeOrganization(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="organizationId") String organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.postAccountByExternalReferenceCodeOrganization(externalReferenceCode, organizationId));
        return true;
    }

    @GraphQLField
    public boolean deleteAccountOrganization(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="organizationId") String organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteAccountOrganization(accountId, organizationId));
        return true;
    }

    @GraphQLField
    public boolean createAccountOrganization(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="organizationId") String organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.postAccountOrganization(accountId, organizationId));
        return true;
    }

    @GraphQLField(description="Creates a new organization")
    public @GraphQLField(description="Creates a new organization") Organization createOrganization(@GraphQLName(value="organization") Organization organization) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.postOrganization(organization));
    }

    @GraphQLField
    public Response createOrganizationBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.postOrganizationBatch(callbackURL, object));
    }

    @GraphQLField(description="Deletes an organization.")
    public @GraphQLField(description="Deletes an organization.") boolean deleteOrganizationByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteOrganizationByExternalReferenceCode(externalReferenceCode));
        return true;
    }

    @GraphQLField(description="Updates the organization with information sent in the request body. Only the provided fields are updated.")
    public @GraphQLField(description="Updates the organization with information sent in the request body. Only the provided fields are updated.") Organization patchOrganizationByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="organization") Organization organization) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.patchOrganizationByExternalReferenceCode(externalReferenceCode, organization));
    }

    @GraphQLField(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.") Organization updateOrganizationByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="organization") Organization organization) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.putOrganizationByExternalReferenceCode(externalReferenceCode, organization));
    }

    @GraphQLField(description="Deletes an organization.")
    public @GraphQLField(description="Deletes an organization.") boolean deleteOrganization(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteOrganization(organizationId));
        return true;
    }

    @GraphQLField
    public Response deleteOrganizationBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteOrganizationBatch(callbackURL, object));
    }

    @GraphQLField(description="Updates the organization with the information sent in the request body. Fields not present in the request body are left unchanged.")
    public @GraphQLField(description="Updates the organization with the information sent in the request body. Fields not present in the request body are left unchanged.") Organization patchOrganization(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="organization") Organization organization) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.patchOrganization(organizationId, organization));
    }

    @GraphQLField(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the organization with information sent in the request body. Any missing fields are deleted unless they are required.") Organization updateOrganization(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="organization") Organization organization) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.putOrganization(organizationId, organization));
    }

    @GraphQLField
    public Response updateOrganizationBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.putOrganizationBatch(callbackURL, object));
    }

    @GraphQLField(description="Removes users from an organization by their email addresses")
    public @GraphQLField(description="Removes users from an organization by their email addresses") boolean deleteUserAccountsByEmailAddress(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteUserAccountsByEmailAddress(organizationId, strings));
        return true;
    }

    @GraphQLField(description="Assigns users to an organization by their email addresses")
    public @GraphQLField(description="Assigns users to an organization by their email addresses") Collection<UserAccount> createUserAccountsByEmailAddress(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="organizationRoleIds") String organizationRoleIds, @GraphQLName(value="strings") String[] strings) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> {
            Page paginationPage = organizationResource.postUserAccountsByEmailAddress(organizationId, organizationRoleIds, strings);
            return paginationPage.getItems();
        });
    }

    @GraphQLField(description="Removes a user from an organization by their email address")
    public @GraphQLField(description="Removes a user from an organization by their email address") boolean deleteUserAccountByEmailAddress(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.deleteUserAccountByEmailAddress(organizationId, emailAddress));
        return true;
    }

    @GraphQLField(description="Assigns a user to an organization by their email address")
    public @GraphQLField(description="Assigns a user to an organization by their email address") UserAccount createUserAccountByEmailAddress(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.postUserAccountByEmailAddress(organizationId, emailAddress));
    }

    @GraphQLField(description="Unassociates a role with a user account")
    public @GraphQLField(description="Unassociates a role with a user account") boolean deleteRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.deleteRoleUserAccountAssociation(roleId, userAccountId));
        return true;
    }

    @GraphQLField(description="Associates a role with a user account")
    public @GraphQLField(description="Associates a role with a user account") boolean createRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.postRoleUserAccountAssociation(roleId, userAccountId));
        return true;
    }

    @GraphQLField(description="Unassociates an organization role with a user account")
    public @GraphQLField(description="Unassociates an organization role with a user account") boolean deleteOrganizationRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="organizationId") Long organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.deleteOrganizationRoleUserAccountAssociation(roleId, userAccountId, organizationId));
        return true;
    }

    @GraphQLField(description="Associates a organization role with a user account")
    public @GraphQLField(description="Associates a organization role with a user account") boolean createOrganizationRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="organizationId") Long organizationId) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.postOrganizationRoleUserAccountAssociation(roleId, userAccountId, organizationId));
        return true;
    }

    @GraphQLField(description="Unassociates a site role with a user account")
    public @GraphQLField(description="Unassociates a site role with a user account") boolean deleteSiteRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="siteKey") @NotEmpty String siteKey) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.deleteSiteRoleUserAccountAssociation(roleId, userAccountId, Long.valueOf(siteKey)));
        return true;
    }

    @GraphQLField(description="Associates a site role with a user account")
    public @GraphQLField(description="Associates a site role with a user account") boolean createSiteRoleUserAccountAssociation(@GraphQLName(value="roleId") Long roleId, @GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="siteKey") @NotEmpty String siteKey) throws Exception {
        this._applyVoidComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.postSiteRoleUserAccountAssociation(roleId, userAccountId, Long.valueOf(siteKey)));
        return true;
    }

    @GraphQLField
    public boolean deleteMyUserAccountSubscription(@GraphQLName(value="subscriptionId") Long subscriptionId) throws Exception {
        this._applyVoidComponentServiceObjects(_subscriptionResourceComponentServiceObjects, this::_populateResourceContext, subscriptionResource -> subscriptionResource.deleteMyUserAccountSubscription(subscriptionId));
        return true;
    }

    @GraphQLField(description="Removes a user by their external reference code from an account by external reference code")
    public @GraphQLField(description="Removes a user by their external reference code from an account by external reference code") boolean deleteAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(@GraphQLName(value="accountExternalReferenceCode") String accountExternalReferenceCode, @GraphQLName(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(accountExternalReferenceCode, userAccountExternalReferenceCode));
        return true;
    }

    @GraphQLField(description="Assigns a user by their external reference code to an account by external reference code")
    public @GraphQLField(description="Assigns a user by their external reference code to an account by external reference code") boolean createAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(@GraphQLName(value="accountExternalReferenceCode") String accountExternalReferenceCode, @GraphQLName(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(accountExternalReferenceCode, userAccountExternalReferenceCode));
        return true;
    }

    @GraphQLField(description="Creates a user and assigns them to the account")
    public @GraphQLField(description="Creates a user and assigns them to the account") UserAccount createAccountUserAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccountByExternalReferenceCode(externalReferenceCode, userAccount));
    }

    @GraphQLField(description="Removes users from an account by their email addresses")
    public @GraphQLField(description="Removes users from an account by their email addresses") boolean deleteAccountUserAccountsByExternalReferenceCodeByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteAccountUserAccountsByExternalReferenceCodeByEmailAddress(externalReferenceCode, strings));
        return true;
    }

    @GraphQLField(description="Assigns users to an account by their email addresses")
    public @GraphQLField(description="Assigns users to an account by their email addresses") boolean createAccountUserAccountsByExternalReferenceCodeByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccountsByExternalReferenceCodeByEmailAddress(externalReferenceCode, strings));
        return true;
    }

    @GraphQLField(description="Removes a user from an account by external reference code by their email address")
    public @GraphQLField(description="Removes a user from an account by external reference code by their email address") boolean deleteAccountUserAccountByExternalReferenceCodeByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteAccountUserAccountByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress));
        return true;
    }

    @GraphQLField(description="Assigns a user to an account by external reference code by their email address")
    public @GraphQLField(description="Assigns a user to an account by external reference code by their email address") boolean createAccountUserAccountByExternalReferenceCodeByEmailAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccountByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress));
        return true;
    }

    @GraphQLField(description="Creates a user and assigns them to the account")
    public @GraphQLField(description="Creates a user and assigns them to the account") UserAccount createAccountUserAccount(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccount(accountId, userAccount));
    }

    @GraphQLField
    public Response createAccountUserAccountBatch(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccountBatch(accountId, callbackURL, object));
    }

    @GraphQLField(description="Removes users from an account by their email addresses")
    public @GraphQLField(description="Removes users from an account by their email addresses") boolean deleteAccountUserAccountsByEmailAddress(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="strings") String[] strings) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteAccountUserAccountsByEmailAddress(accountId, strings));
        return true;
    }

    @GraphQLField(description="Assigns users to an account by their email addresses")
    public @GraphQLField(description="Assigns users to an account by their email addresses") Collection<UserAccount> createAccountUserAccountsByEmailAddress(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="accountRoleIds") String accountRoleIds, @GraphQLName(value="strings") String[] strings) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> {
            Page paginationPage = userAccountResource.postAccountUserAccountsByEmailAddress(accountId, accountRoleIds, strings);
            return paginationPage.getItems();
        });
    }

    @GraphQLField(description="Removes a user from an account by their email address")
    public @GraphQLField(description="Removes a user from an account by their email address") boolean deleteAccountUserAccountByEmailAddress(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteAccountUserAccountByEmailAddress(accountId, emailAddress));
        return true;
    }

    @GraphQLField(description="Assigns a user to an account by their email address")
    public @GraphQLField(description="Assigns a user to an account by their email address") UserAccount createAccountUserAccountByEmailAddress(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postAccountUserAccountByEmailAddress(accountId, emailAddress));
    }

    @GraphQLField(description="Creates a new user account")
    public @GraphQLField(description="Creates a new user account") UserAccount createUserAccount(@GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postUserAccount(userAccount));
    }

    @GraphQLField
    public Response createUserAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.postUserAccountBatch(callbackURL, object));
    }

    @GraphQLField
    public boolean deleteUserAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteUserAccountByExternalReferenceCode(externalReferenceCode));
        return true;
    }

    @GraphQLField
    public UserAccount updateUserAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.putUserAccountByExternalReferenceCode(externalReferenceCode, userAccount));
    }

    @GraphQLField(description="Deletes the user account")
    public @GraphQLField(description="Deletes the user account") boolean deleteUserAccount(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        this._applyVoidComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteUserAccount(userAccountId));
        return true;
    }

    @GraphQLField
    public Response deleteUserAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.deleteUserAccountBatch(callbackURL, object));
    }

    @GraphQLField(description="Updates the user account with information sent in the request body. Only the provided fields are updated.")
    public @GraphQLField(description="Updates the user account with information sent in the request body. Only the provided fields are updated.") UserAccount patchUserAccount(@GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.patchUserAccount(userAccountId, userAccount));
    }

    @GraphQLField(description="Replaces the user account with information sent in the request body. Any missing fields are deleted unless they are required.")
    public @GraphQLField(description="Replaces the user account with information sent in the request body. Any missing fields are deleted unless they are required.") UserAccount updateUserAccount(@GraphQLName(value="userAccountId") Long userAccountId, @GraphQLName(value="userAccount") UserAccount userAccount) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.putUserAccount(userAccountId, userAccount));
    }

    @GraphQLField
    public Response updateUserAccountBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.putUserAccountBatch(callbackURL, object));
    }

    @GraphQLField
    public UserGroup createUserGroup(@GraphQLName(value="userGroup") UserGroup userGroup) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.postUserGroup(userGroup));
    }

    @GraphQLField
    public Response createUserGroupBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.postUserGroupBatch(callbackURL, object));
    }

    @GraphQLField
    public boolean deleteUserGroupByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        this._applyVoidComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.deleteUserGroupByExternalReferenceCode(externalReferenceCode));
        return true;
    }

    @GraphQLField
    public UserGroup patchUserGroupByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="userGroup") UserGroup userGroup) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.patchUserGroupByExternalReferenceCode(externalReferenceCode, userGroup));
    }

    @GraphQLField
    public UserGroup updateUserGroupByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="userGroup") UserGroup userGroup) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.putUserGroupByExternalReferenceCode(externalReferenceCode, userGroup));
    }

    @GraphQLField
    public boolean deleteUserGroup(@GraphQLName(value="userGroupId") Long userGroupId) throws Exception {
        this._applyVoidComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.deleteUserGroup(userGroupId));
        return true;
    }

    @GraphQLField
    public Response deleteUserGroupBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.deleteUserGroupBatch(callbackURL, object));
    }

    @GraphQLField
    public UserGroup patchUserGroup(@GraphQLName(value="userGroupId") Long userGroupId, @GraphQLName(value="userGroup") UserGroup userGroup) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.patchUserGroup(userGroupId, userGroup));
    }

    @GraphQLField
    public UserGroup updateUserGroup(@GraphQLName(value="userGroupId") Long userGroupId, @GraphQLName(value="userGroup") UserGroup userGroup) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.putUserGroup(userGroupId, userGroup));
    }

    @GraphQLField
    public Response updateUserGroupBatch(@GraphQLName(value="callbackURL") String callbackURL, @GraphQLName(value="object") Object object) throws Exception {
        return (Response)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.putUserGroupBatch(callbackURL, object));
    }

    @GraphQLField
    public boolean deleteUserGroupUsers(@GraphQLName(value="userGroupId") Long userGroupId, @GraphQLName(value="longs") Long[] longs) throws Exception {
        this._applyVoidComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.deleteUserGroupUsers(userGroupId, longs));
        return true;
    }

    @GraphQLField
    public boolean createUserGroupUsers(@GraphQLName(value="userGroupId") Long userGroupId, @GraphQLName(value="longs") Long[] longs) throws Exception {
        this._applyVoidComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.postUserGroupUsers(userGroupId, longs));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E1 extends Throwable, E2 extends Throwable> void _applyVoidComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeConsumer<T, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            unsafeFunction.accept(resource);
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(AccountResource accountResource) throws Exception {
        accountResource.setContextAcceptLanguage(this._acceptLanguage);
        accountResource.setContextCompany(this._company);
        accountResource.setContextHttpServletRequest(this._httpServletRequest);
        accountResource.setContextHttpServletResponse(this._httpServletResponse);
        accountResource.setContextUriInfo(this._uriInfo);
        accountResource.setContextUser(this._user);
        accountResource.setGroupLocalService(this._groupLocalService);
        accountResource.setRoleLocalService(this._roleLocalService);
        accountResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(AccountRoleResource accountRoleResource) throws Exception {
        accountRoleResource.setContextAcceptLanguage(this._acceptLanguage);
        accountRoleResource.setContextCompany(this._company);
        accountRoleResource.setContextHttpServletRequest(this._httpServletRequest);
        accountRoleResource.setContextHttpServletResponse(this._httpServletResponse);
        accountRoleResource.setContextUriInfo(this._uriInfo);
        accountRoleResource.setContextUser(this._user);
        accountRoleResource.setGroupLocalService(this._groupLocalService);
        accountRoleResource.setRoleLocalService(this._roleLocalService);
        accountRoleResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(OrganizationResource organizationResource) throws Exception {
        organizationResource.setContextAcceptLanguage(this._acceptLanguage);
        organizationResource.setContextCompany(this._company);
        organizationResource.setContextHttpServletRequest(this._httpServletRequest);
        organizationResource.setContextHttpServletResponse(this._httpServletResponse);
        organizationResource.setContextUriInfo(this._uriInfo);
        organizationResource.setContextUser(this._user);
        organizationResource.setGroupLocalService(this._groupLocalService);
        organizationResource.setRoleLocalService(this._roleLocalService);
        organizationResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(RoleResource roleResource) throws Exception {
        roleResource.setContextAcceptLanguage(this._acceptLanguage);
        roleResource.setContextCompany(this._company);
        roleResource.setContextHttpServletRequest(this._httpServletRequest);
        roleResource.setContextHttpServletResponse(this._httpServletResponse);
        roleResource.setContextUriInfo(this._uriInfo);
        roleResource.setContextUser(this._user);
        roleResource.setGroupLocalService(this._groupLocalService);
        roleResource.setRoleLocalService(this._roleLocalService);
        roleResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(SubscriptionResource subscriptionResource) throws Exception {
        subscriptionResource.setContextAcceptLanguage(this._acceptLanguage);
        subscriptionResource.setContextCompany(this._company);
        subscriptionResource.setContextHttpServletRequest(this._httpServletRequest);
        subscriptionResource.setContextHttpServletResponse(this._httpServletResponse);
        subscriptionResource.setContextUriInfo(this._uriInfo);
        subscriptionResource.setContextUser(this._user);
        subscriptionResource.setGroupLocalService(this._groupLocalService);
        subscriptionResource.setRoleLocalService(this._roleLocalService);
        subscriptionResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(UserAccountResource userAccountResource) throws Exception {
        userAccountResource.setContextAcceptLanguage(this._acceptLanguage);
        userAccountResource.setContextCompany(this._company);
        userAccountResource.setContextHttpServletRequest(this._httpServletRequest);
        userAccountResource.setContextHttpServletResponse(this._httpServletResponse);
        userAccountResource.setContextUriInfo(this._uriInfo);
        userAccountResource.setContextUser(this._user);
        userAccountResource.setGroupLocalService(this._groupLocalService);
        userAccountResource.setRoleLocalService(this._roleLocalService);
        userAccountResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }

    private void _populateResourceContext(UserGroupResource userGroupResource) throws Exception {
        userGroupResource.setContextAcceptLanguage(this._acceptLanguage);
        userGroupResource.setContextCompany(this._company);
        userGroupResource.setContextHttpServletRequest(this._httpServletRequest);
        userGroupResource.setContextHttpServletResponse(this._httpServletResponse);
        userGroupResource.setContextUriInfo(this._uriInfo);
        userGroupResource.setContextUser(this._user);
        userGroupResource.setGroupLocalService(this._groupLocalService);
        userGroupResource.setRoleLocalService(this._roleLocalService);
        userGroupResource.setVulcanBatchEngineImportTaskResource(this._vulcanBatchEngineImportTaskResource);
    }
}

