/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.util;

import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PostalAddressUtil {
    public static PostalAddress toPostalAddress(final boolean acceptAllLanguages, final Address address, final long companyId, final Locale locale) {
        final ListType listType = address.getListType();
        return new PostalAddress(){
            {
                this.addressLocality = address.getCity();
                this.addressType = listType.getName();
                this.id = address.getAddressId();
                this.name = address.getName();
                this.postalCode = address.getZip();
                this.primary = address.isPrimary();
                this.streetAddressLine1 = address.getStreet1();
                this.streetAddressLine2 = address.getStreet2();
                this.streetAddressLine3 = address.getStreet3();
                this.setAddressCountry(() -> {
                    if (address.getCountryId() <= 0L) {
                        return null;
                    }
                    Country country = address.getCountry();
                    return country.getName(locale);
                });
                this.setAddressCountry_i18n(() -> {
                    if (!acceptAllLanguages) {
                        return null;
                    }
                    Set locales = LanguageUtil.getCompanyAvailableLocales((long)companyId);
                    Stream localesStream = locales.stream();
                    Country country = address.getCountry();
                    return localesStream.collect(Collectors.toMap(LocaleUtil::toBCP47LanguageId, arg_0 -> ((Country)country).getName(arg_0)));
                });
                this.setAddressRegion(() -> {
                    if (address.getRegionId() <= 0L) {
                        return null;
                    }
                    Region region = address.getRegion();
                    return region.getName();
                });
            }
        };
    }
}

