/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.converter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.UserGroup"}, service={DTOConverter.class, UserGroupResourceDTOConverter.class})
public class UserGroupResourceDTOConverter
implements DTOConverter<UserGroup, com.liferay.headless.admin.user.dto.v1_0.UserGroup> {
    @Reference
    private UserGroupService _userGroupService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return com.liferay.headless.admin.user.dto.v1_0.UserGroup.class.getSimpleName();
    }

    public UserGroup getObject(String externalReferenceCode) throws Exception {
        UserGroup userGroup = this._userGroupService.fetchUserGroupByExternalReferenceCode(CompanyThreadLocal.getCompanyId().longValue(), externalReferenceCode);
        if (userGroup == null) {
            userGroup = this._userGroupService.getUserGroup(GetterUtil.getLong((String)externalReferenceCode));
        }
        return userGroup;
    }

    public long getUserGroupId(String externalReferenceCode) throws Exception {
        UserGroup userGroup = this.getObject(externalReferenceCode);
        return userGroup.getUserGroupId();
    }

    public com.liferay.headless.admin.user.dto.v1_0.UserGroup toDTO(final DTOConverterContext dtoConverterContext, final UserGroup userGroup) throws PortalException {
        if (userGroup == null) {
            return null;
        }
        return new com.liferay.headless.admin.user.dto.v1_0.UserGroup(){
            {
                this.actions = dtoConverterContext.getActions();
                this.description = userGroup.getDescription();
                this.externalReferenceCode = userGroup.getExternalReferenceCode();
                this.id = userGroup.getUserGroupId();
                this.name = userGroup.getName();
                this.usersCount = UserGroupResourceDTOConverter.this._userLocalService.getUserGroupUsersCount(userGroup.getUserGroupId(), 0);
            }
        };
    }
}

