/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Site;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseSiteResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.SiteResource;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import javax.validation.ValidationException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteResource.class})
public class SiteResourceImpl
extends BaseSiteResourceImpl {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Page<Site> getMyUserAccountSitesPage(Pagination pagination) throws Exception {
        return Page.of(this.transform(this._groupService.getUserSitesGroups(this.contextUser.getUserId(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toSite));
    }

    @Override
    public Site getSite(Long siteId) throws Exception {
        return this._toSite(this._groupService.getGroup(siteId.longValue()));
    }

    @Override
    public Site getSiteByFriendlyUrlPath(String url) throws Exception {
        Group group = this._groupLocalService.fetchFriendlyURLGroup(this.contextCompany.getCompanyId(), "/" + url);
        if (group == null) {
            throw new ValidationException("No site exists with friendly URL " + url);
        }
        GroupPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Group)group, (String)"VIEW");
        return this._toSite(group);
    }

    private Site _toSite(final Group group) throws Exception {
        return new Site(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])group.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(SiteResourceImpl.this._portal, SiteResourceImpl.this._userLocalService.fetchUser(group.getCreatorUserId()));
                this.description = group.getDescription(SiteResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)SiteResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)group.getDescriptionMap());
                this.friendlyUrlPath = group.getFriendlyURL();
                this.id = group.getGroupId();
                this.key = group.getGroupKey();
                this.membershipType = group.getTypeLabel();
                this.name = group.getName(SiteResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)SiteResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)group.getNameMap());
                this.parentSiteId = group.getParentGroupId();
                this.sites = (Site[])SiteResourceImpl.this.transformToArray(SiteResourceImpl.this._groupService.getGroups(group.getCompanyId(), group.getGroupId(), true), x$0 -> SiteResourceImpl.this._toSite(x$0), Site.class);
            }
        };
    }
}

