/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.OrganizationResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BasePhoneResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.PhoneResource;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.vulcan.pagination.Page;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/phone.properties"}, scope=ServiceScope.PROTOTYPE, service={PhoneResource.class})
public class PhoneResourceImpl
extends BasePhoneResourceImpl {
    @Reference
    private OrganizationResourceDTOConverter _organizationResourceDTOConverter;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private UserService _userService;

    @Override
    public Page<Phone> getOrganizationPhonesPage(Long organizationId) throws Exception {
        Organization organization = this._organizationResourceDTOConverter.getObject(String.valueOf(organizationId));
        return Page.of(this.transform(this._phoneService.getPhones(organization.getModelClassName(), organization.getOrganizationId()), PhoneUtil::toPhone));
    }

    @Override
    public Phone getPhone(Long phoneId) throws Exception {
        return PhoneUtil.toPhone(this._phoneService.getPhone(phoneId.longValue()));
    }

    @Override
    public Page<Phone> getUserAccountPhonesPage(Long userAccountId) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        return Page.of(this.transform(this._phoneService.getPhones(Contact.class.getName(), user.getContactId()), PhoneUtil::toPhone));
    }
}

