/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Segment;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseSegmentResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.SegmentResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/segment.properties"}, scope=ServiceScope.PROTOTYPE, service={SegmentResource.class})
public class SegmentResourceImpl
extends BaseSegmentResourceImpl {
    @Context
    private HttpHeaders _httpHeaders;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryService _segmentsEntryService;
    @Reference
    private UserService _userService;

    @Override
    public Page<Segment> getSiteSegmentsPage(Long siteId, Pagination pagination) {
        return Page.of(this.transform(this._segmentsEntryService.getSegmentsEntries(siteId.longValue(), true, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSegment), (Pagination)pagination, (long)this._segmentsEntryService.getSegmentsEntriesCount(siteId.longValue(), true));
    }

    @Override
    public Page<Segment> getSiteUserAccountSegmentsPage(Long siteId, Long userAccountId) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        long[] segmentsEntryIds = this._segmentsEntryProviderRegistry.getSegmentsEntryIds(siteId.longValue(), user.getModelClassName(), user.getPrimaryKey(), this._createSegmentsContext());
        return Page.of(this.transformToList(ArrayUtil.toArray((long[])segmentsEntryIds), segmentsEntryId -> this._toSegment(this._segmentsEntryService.getSegmentsEntry(segmentsEntryId.longValue()))));
    }

    private com.liferay.segments.context.Context _createSegmentsContext() {
        com.liferay.segments.context.Context context = new com.liferay.segments.context.Context();
        MultivaluedMap multivaluedMap = this._httpHeaders.getRequestHeaders();
        for (Map.Entry entry : multivaluedMap.entrySet()) {
            String key = StringUtil.toLowerCase((String)((String)entry.getKey()));
            List values = (List)entry.getValue();
            String value = (String)values.get(0);
            if (key.startsWith("x-")) {
                context.put(CamelCaseUtil.toCamelCase((String)StringUtil.removeSubstring((String)key, (String)"x-")), (Serializable)((Object)value));
                continue;
            }
            if (key.equals("accept-language")) {
                context.put("languageId", (Serializable)((Object)StringUtil.replace((String)value, (char)'-', (char)'_')));
                continue;
            }
            if (key.equals("host")) {
                context.put("url", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("referer")) {
                context.put("referrerURL", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("user-agent")) {
                context.put("userAgent", (Serializable)((Object)value));
                continue;
            }
            context.put(key, (Serializable)((Object)value));
        }
        context.put("localDate", (Serializable)LocalDate.from(ZonedDateTime.now()));
        return context;
    }

    private Segment _toSegment(final SegmentsEntry segmentsEntry) {
        return new Segment(){
            {
                this.active = segmentsEntry.isActive();
                this.criteria = segmentsEntry.getCriteria();
                this.dateCreated = segmentsEntry.getCreateDate();
                this.dateModified = segmentsEntry.getModifiedDate();
                this.id = segmentsEntry.getSegmentsEntryId();
                this.name = segmentsEntry.getName(segmentsEntry.getDefaultLanguageId());
                this.siteId = segmentsEntry.getGroupId();
                this.source = segmentsEntry.getSource();
            }
        };
    }
}

