/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.client.resource.v1_0;

import com.liferay.headless.admin.user.client.dto.v1_0.Role;
import com.liferay.headless.admin.user.client.http.HttpInvoker;
import com.liferay.headless.admin.user.client.pagination.Page;
import com.liferay.headless.admin.user.client.pagination.Pagination;
import com.liferay.headless.admin.user.client.problem.Problem;
import com.liferay.headless.admin.user.client.serdes.v1_0.RoleSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface RoleResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<Role> getRolesPage(Pagination var1) throws Exception;

    public HttpInvoker.HttpResponse getRolesPageHttpResponse(Pagination var1) throws Exception;

    public Role getRole(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getRoleHttpResponse(Long var1) throws Exception;

    public void deleteRoleUserAccountAssociation(Long var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse deleteRoleUserAccountAssociationHttpResponse(Long var1, Long var2) throws Exception;

    public void postRoleUserAccountAssociation(Long var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse postRoleUserAccountAssociationHttpResponse(Long var1, Long var2) throws Exception;

    public void deleteOrganizationRoleUserAccountAssociation(Long var1, Long var2, Long var3) throws Exception;

    public HttpInvoker.HttpResponse deleteOrganizationRoleUserAccountAssociationHttpResponse(Long var1, Long var2, Long var3) throws Exception;

    public void postOrganizationRoleUserAccountAssociation(Long var1, Long var2, Long var3) throws Exception;

    public HttpInvoker.HttpResponse postOrganizationRoleUserAccountAssociationHttpResponse(Long var1, Long var2, Long var3) throws Exception;

    public void deleteSiteRoleUserAccountAssociation(Long var1, Long var2, Long var3) throws Exception;

    public HttpInvoker.HttpResponse deleteSiteRoleUserAccountAssociationHttpResponse(Long var1, Long var2, Long var3) throws Exception;

    public void postSiteRoleUserAccountAssociation(Long var1, Long var2, Long var3) throws Exception;

    public HttpInvoker.HttpResponse postSiteRoleUserAccountAssociationHttpResponse(Long var1, Long var2, Long var3) throws Exception;

    public static class RoleResourceImpl
    implements RoleResource {
        private static final Logger _logger = Logger.getLogger(RoleResource.class.getName());
        private Builder _builder;

        @Override
        public Page<Role> getRolesPage(Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getRolesPageHttpResponse(pagination);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, RoleSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getRolesPageHttpResponse(Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Role getRole(Long roleId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getRoleHttpResponse(roleId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return RoleSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getRoleHttpResponse(Long roleId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}", roleId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteRoleUserAccountAssociationHttpResponse(roleId, userAccountId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}", roleId, userAccountId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postRoleUserAccountAssociationHttpResponse(roleId, userAccountId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(userAccountId.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}", roleId, userAccountId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteOrganizationRoleUserAccountAssociationHttpResponse(roleId, userAccountId, organizationId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteOrganizationRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}/organization/{organizationId}", roleId, userAccountId, organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postOrganizationRoleUserAccountAssociationHttpResponse(roleId, userAccountId, organizationId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postOrganizationRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(organizationId.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}/organization/{organizationId}", roleId, userAccountId, organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteSiteRoleUserAccountAssociationHttpResponse(roleId, userAccountId, siteId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteSiteRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId, Long siteId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}/site/{siteId}", roleId, userAccountId, siteId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteRoleUserAccountAssociationHttpResponse(roleId, userAccountId, siteId);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postSiteRoleUserAccountAssociationHttpResponse(Long roleId, Long userAccountId, Long siteId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(siteId.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-user/v1.0/roles/{roleId}/association/user-account/{userAccountId}/site/{siteId}", roleId, userAccountId, siteId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private RoleResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public RoleResource build() {
            return new RoleResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

