/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="An account represents an external account, for example a customer business.", value="Account")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="An account represents an external account, for example a customer business.", requiredProperties={"name"})
@XmlRootElement(name="Account")
public class Account
implements Serializable {
    @GraphQLField(description="The users linked to the account")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The users linked to the account") UserAccount[] accountUserAccounts;
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @GraphQLField(description="The account's email domains. Users assigned to this account generally will have email addresses under one of these domains.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The account's email domains. Users assigned to this account generally will have email addresses under one of these domains.") String[] domains;
    @GraphQLField(description="The optional external key of this account.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The optional external key of this account.") String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @GraphQLField(description="The number of this account's associated users.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this account's associated users.") Integer numberOfUsers;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long[] organizationIds;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long parentAccountId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer status;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Type type;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.user.dto.v1_0.Account", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static Account toDTO(String json) {
        return (Account)ObjectMapperUtil.readValue(Account.class, (String)json);
    }

    public static Account unsafeToDTO(String json) {
        return (Account)ObjectMapperUtil.unsafeReadValue(Account.class, (String)json);
    }

    @Schema(description="The users linked to the account")
    @Valid
    public UserAccount[] getAccountUserAccounts() {
        return this.accountUserAccounts;
    }

    public void setAccountUserAccounts(UserAccount[] accountUserAccounts) {
        this.accountUserAccounts = accountUserAccounts;
    }

    @JsonIgnore
    public void setAccountUserAccounts(UnsafeSupplier<UserAccount[], Exception> accountUserAccountsUnsafeSupplier) {
        try {
            this.accountUserAccounts = (UserAccount[])accountUserAccountsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The account's email domains. Users assigned to this account generally will have email addresses under one of these domains.")
    public String[] getDomains() {
        return this.domains;
    }

    public void setDomains(String[] domains) {
        this.domains = domains;
    }

    @JsonIgnore
    public void setDomains(UnsafeSupplier<String[], Exception> domainsUnsafeSupplier) {
        try {
            this.domains = (String[])domainsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The optional external key of this account.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of this account's associated users.")
    public Integer getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public void setNumberOfUsers(Integer numberOfUsers) {
        this.numberOfUsers = numberOfUsers;
    }

    @JsonIgnore
    public void setNumberOfUsers(UnsafeSupplier<Integer, Exception> numberOfUsersUnsafeSupplier) {
        try {
            this.numberOfUsers = (Integer)numberOfUsersUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long[] getOrganizationIds() {
        return this.organizationIds;
    }

    public void setOrganizationIds(Long[] organizationIds) {
        this.organizationIds = organizationIds;
    }

    @JsonIgnore
    public void setOrganizationIds(UnsafeSupplier<Long[], Exception> organizationIdsUnsafeSupplier) {
        try {
            this.organizationIds = (Long[])organizationIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getParentAccountId() {
        return this.parentAccountId;
    }

    public void setParentAccountId(Long parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    @JsonIgnore
    public void setParentAccountId(UnsafeSupplier<Long, Exception> parentAccountIdUnsafeSupplier) {
        try {
            this.parentAccountId = (Long)parentAccountIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        try {
            this.status = (Integer)statusUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Type getType() {
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        try {
            this.type = (Type)((Object)typeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return Objects.equals(this.toString(), account.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.accountUserAccounts != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountUserAccounts\": ");
            sb.append("[");
            for (i = 0; i < this.accountUserAccounts.length; ++i) {
                sb.append(String.valueOf(this.accountUserAccounts[i]));
                if (i + 1 >= this.accountUserAccounts.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Account._toJSON(this.actions));
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(Account._escape(this.description));
            sb.append("\"");
        }
        if (this.domains != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"domains\": ");
            sb.append("[");
            for (i = 0; i < this.domains.length; ++i) {
                sb.append("\"");
                sb.append(Account._escape(this.domains[i]));
                sb.append("\"");
                if (i + 1 >= this.domains.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Account._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Account._escape(this.name));
            sb.append("\"");
        }
        if (this.numberOfUsers != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfUsers\": ");
            sb.append((Object)this.numberOfUsers);
        }
        if (this.organizationIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationIds\": ");
            sb.append("[");
            for (i = 0; i < this.organizationIds.length; ++i) {
                sb.append((Object)this.organizationIds[i]);
                if (i + 1 >= this.organizationIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.parentAccountId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentAccountId\": ");
            sb.append((Object)this.parentAccountId);
        }
        if (this.status != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)this.status);
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)this.type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Account._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Account._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Account._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Account._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        BUSINESS("business"),
        GUEST("guest"),
        PERSON("person");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

