/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.graphql.query.v1_0;

import com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.content.resource.v1_0.DisplayPageTemplateResource;
import com.liferay.headless.admin.content.resource.v1_0.StructuredContentResource;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<DisplayPageTemplateResource> _displayPageTemplateResourceComponentServiceObjects;
    private static ComponentServiceObjects<StructuredContentResource> _structuredContentResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private BiFunction<Object, List<String>, Aggregation> _aggregationBiFunction;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setDisplayPageTemplateResourceComponentServiceObjects(ComponentServiceObjects<DisplayPageTemplateResource> displayPageTemplateResourceComponentServiceObjects) {
        _displayPageTemplateResourceComponentServiceObjects = displayPageTemplateResourceComponentServiceObjects;
    }

    public static void setStructuredContentResourceComponentServiceObjects(ComponentServiceObjects<StructuredContentResource> structuredContentResourceComponentServiceObjects) {
        _structuredContentResourceComponentServiceObjects = structuredContentResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrieves the display page templates of a site")
    public @GraphQLField(description="Retrieves the display page templates of a site") DisplayPageTemplatePage displayPageTemplates(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (DisplayPageTemplatePage)this._applyComponentServiceObjects(_displayPageTemplateResourceComponentServiceObjects, this::_populateResourceContext, displayPageTemplateResource -> new DisplayPageTemplatePage(displayPageTemplateResource.getSiteDisplayPageTemplatesPage(Long.valueOf(siteKey), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(displayPageTemplateResource, sortsString))));
    }

    @GraphQLField(description="Retrieves a display page template of a site")
    public @GraphQLField(description="Retrieves a display page template of a site") DisplayPageTemplate displayPageTemplate(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="displayPageTemplateKey") String displayPageTemplateKey) throws Exception {
        return (DisplayPageTemplate)this._applyComponentServiceObjects(_displayPageTemplateResourceComponentServiceObjects, this::_populateResourceContext, displayPageTemplateResource -> displayPageTemplateResource.getSiteDisplayPageTemplate(Long.valueOf(siteKey), displayPageTemplateKey));
    }

    @GraphQLField(description="Retrieves the site's structured contents latest version. Results can be paginated, filtered, searched, flattened, and sorted.")
    public @GraphQLField(description="Retrieves the site's structured contents latest version. Results can be paginated, filtered, searched, flattened, and sorted.") StructuredContentPage structuredContents(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="aggregation") List<String> aggregations, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (StructuredContentPage)this._applyComponentServiceObjects(_structuredContentResourceComponentServiceObjects, this::_populateResourceContext, structuredContentResource -> new StructuredContentPage(structuredContentResource.getSiteStructuredContentsPage(Long.valueOf(siteKey), flatten, search, this._aggregationBiFunction.apply(structuredContentResource, aggregations), this._filterBiFunction.apply(structuredContentResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(structuredContentResource, sortsString))));
    }

    @GraphQLField(description="Retrieves a version of a structured content")
    public @GraphQLField(description="Retrieves a version of a structured content") StructuredContent structuredContentByVersion(@GraphQLName(value="structuredContentId") Long structuredContentId, @GraphQLName(value="version") Double version) throws Exception {
        return (StructuredContent)this._applyComponentServiceObjects(_structuredContentResourceComponentServiceObjects, this::_populateResourceContext, structuredContentResource -> structuredContentResource.getStructuredContentByVersion(structuredContentId, version));
    }

    @GraphQLField(description="Retrieves all versions of a structured content via its ID.")
    public @GraphQLField(description="Retrieves all versions of a structured content via its ID.") StructuredContentPage structuredContentsVersions(@GraphQLName(value="structuredContentId") Long structuredContentId) throws Exception {
        return (StructuredContentPage)this._applyComponentServiceObjects(_structuredContentResourceComponentServiceObjects, this::_populateResourceContext, structuredContentResource -> new StructuredContentPage(structuredContentResource.getStructuredContentsVersionsPage(structuredContentId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(DisplayPageTemplateResource displayPageTemplateResource) throws Exception {
        displayPageTemplateResource.setContextAcceptLanguage(this._acceptLanguage);
        displayPageTemplateResource.setContextCompany(this._company);
        displayPageTemplateResource.setContextHttpServletRequest(this._httpServletRequest);
        displayPageTemplateResource.setContextHttpServletResponse(this._httpServletResponse);
        displayPageTemplateResource.setContextUriInfo(this._uriInfo);
        displayPageTemplateResource.setContextUser(this._user);
        displayPageTemplateResource.setGroupLocalService(this._groupLocalService);
        displayPageTemplateResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(StructuredContentResource structuredContentResource) throws Exception {
        structuredContentResource.setContextAcceptLanguage(this._acceptLanguage);
        structuredContentResource.setContextCompany(this._company);
        structuredContentResource.setContextHttpServletRequest(this._httpServletRequest);
        structuredContentResource.setContextHttpServletResponse(this._httpServletResponse);
        structuredContentResource.setContextUriInfo(this._uriInfo);
        structuredContentResource.setContextUser(this._user);
        structuredContentResource.setGroupLocalService(this._groupLocalService);
        structuredContentResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="StructuredContentPage")
    public class StructuredContentPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<StructuredContent> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public StructuredContentPage(Page structuredContentPage) {
            this.actions = structuredContentPage.getActions();
            this.facets = structuredContentPage.getFacets();
            this.items = structuredContentPage.getItems();
            this.lastPage = structuredContentPage.getLastPage();
            this.page = structuredContentPage.getPage();
            this.pageSize = structuredContentPage.getPageSize();
            this.totalCount = structuredContentPage.getTotalCount();
        }
    }

    @GraphQLName(value="DisplayPageTemplatePage")
    public class DisplayPageTemplatePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected List<Facet> facets;
        @GraphQLField
        protected Collection<DisplayPageTemplate> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public DisplayPageTemplatePage(Page displayPageTemplatePage) {
            this.actions = displayPageTemplatePage.getActions();
            this.facets = displayPageTemplatePage.getFacets();
            this.items = displayPageTemplatePage.getItems();
            this.lastPage = displayPageTemplatePage.getLastPage();
            this.page = displayPageTemplatePage.getPage();
            this.pageSize = displayPageTemplatePage.getPageSize();
            this.totalCount = displayPageTemplatePage.getTotalCount();
        }
    }
}

