/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.address.internal.graphql.query.v1_0;

import com.liferay.headless.admin.address.dto.v1_0.Country;
import com.liferay.headless.admin.address.dto.v1_0.Region;
import com.liferay.headless.admin.address.resource.v1_0.CountryResource;
import com.liferay.headless.admin.address.resource.v1_0.RegionResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<CountryResource> _countryResourceComponentServiceObjects;
    private static ComponentServiceObjects<RegionResource> _regionResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setCountryResourceComponentServiceObjects(ComponentServiceObjects<CountryResource> countryResourceComponentServiceObjects) {
        _countryResourceComponentServiceObjects = countryResourceComponentServiceObjects;
    }

    public static void setRegionResourceComponentServiceObjects(ComponentServiceObjects<RegionResource> regionResourceComponentServiceObjects) {
        _regionResourceComponentServiceObjects = regionResourceComponentServiceObjects;
    }

    @GraphQLField
    public CountryPage countries(@GraphQLName(value="active") Boolean active, @GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (CountryPage)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> new CountryPage(countryResource.getCountriesPage(active, search, Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(countryResource, sortsString))));
    }

    @GraphQLField
    public Country countryByA2(@GraphQLName(value="a2") String a2) throws Exception {
        return (Country)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> countryResource.getCountryByA2(a2));
    }

    @GraphQLField
    public Country countryByA3(@GraphQLName(value="a3") String a3) throws Exception {
        return (Country)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> countryResource.getCountryByA3(a3));
    }

    @GraphQLField
    public Country countryByName(@GraphQLName(value="name") String name) throws Exception {
        return (Country)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> countryResource.getCountryByName(name));
    }

    @GraphQLField
    public Country countryByNumber(@GraphQLName(value="number") Integer number) throws Exception {
        return (Country)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> countryResource.getCountryByNumber(number));
    }

    @GraphQLField
    public Country country(@GraphQLName(value="countryId") Long countryId) throws Exception {
        return (Country)this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, this::_populateResourceContext, countryResource -> countryResource.getCountry(countryId));
    }

    @GraphQLField
    public RegionPage countryRegions(@GraphQLName(value="countryId") Long countryId, @GraphQLName(value="active") Boolean active, @GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (RegionPage)this._applyComponentServiceObjects(_regionResourceComponentServiceObjects, this::_populateResourceContext, regionResource -> new RegionPage(regionResource.getCountryRegionsPage(countryId, active, search, Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(regionResource, sortsString))));
    }

    @GraphQLField
    public Region countryRegionByRegionCode(@GraphQLName(value="countryId") Long countryId, @GraphQLName(value="regionCode") String regionCode) throws Exception {
        return (Region)this._applyComponentServiceObjects(_regionResourceComponentServiceObjects, this::_populateResourceContext, regionResource -> regionResource.getCountryRegionByRegionCode(countryId, regionCode));
    }

    @GraphQLField
    public RegionPage regions(@GraphQLName(value="active") Boolean active, @GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (RegionPage)this._applyComponentServiceObjects(_regionResourceComponentServiceObjects, this::_populateResourceContext, regionResource -> new RegionPage(regionResource.getRegionsPage(active, search, Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(regionResource, sortsString))));
    }

    @GraphQLField
    public Region region(@GraphQLName(value="regionId") Long regionId) throws Exception {
        return (Region)this._applyComponentServiceObjects(_regionResourceComponentServiceObjects, this::_populateResourceContext, regionResource -> regionResource.getRegion(regionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(CountryResource countryResource) throws Exception {
        countryResource.setContextAcceptLanguage(this._acceptLanguage);
        countryResource.setContextCompany(this._company);
        countryResource.setContextHttpServletRequest(this._httpServletRequest);
        countryResource.setContextHttpServletResponse(this._httpServletResponse);
        countryResource.setContextUriInfo(this._uriInfo);
        countryResource.setContextUser(this._user);
        countryResource.setGroupLocalService(this._groupLocalService);
        countryResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(RegionResource regionResource) throws Exception {
        regionResource.setContextAcceptLanguage(this._acceptLanguage);
        regionResource.setContextCompany(this._company);
        regionResource.setContextHttpServletRequest(this._httpServletRequest);
        regionResource.setContextHttpServletResponse(this._httpServletResponse);
        regionResource.setContextUriInfo(this._uriInfo);
        regionResource.setContextUser(this._user);
        regionResource.setGroupLocalService(this._groupLocalService);
        regionResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="RegionPage")
    public class RegionPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Region> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public RegionPage(Page regionPage) {
            this.actions = regionPage.getActions();
            this.items = regionPage.getItems();
            this.lastPage = regionPage.getLastPage();
            this.page = regionPage.getPage();
            this.pageSize = regionPage.getPageSize();
            this.totalCount = regionPage.getTotalCount();
        }
    }

    @GraphQLName(value="CountryPage")
    public class CountryPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Country> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CountryPage(Page countryPage) {
            this.actions = countryPage.getActions();
            this.items = countryPage.getItems();
            this.lastPage = countryPage.getLastPage();
            this.page = countryPage.getPage();
            this.pageSize = countryPage.getPageSize();
            this.totalCount = countryPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=Country.class)
    public class GetCountryRegionByRegionCodeTypeExtension {
        private Country _country;

        public GetCountryRegionByRegionCodeTypeExtension(Country country) {
            this._country = country;
        }

        @GraphQLField
        public Region regionByRegionCode(@GraphQLName(value="regionCode") String regionCode) throws Exception {
            return (Region)Query.this._applyComponentServiceObjects(_regionResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), regionResource -> regionResource.getCountryRegionByRegionCode(this._country.getId(), regionCode));
        }
    }

    @GraphQLTypeExtension(value=Region.class)
    public class GetCountryTypeExtension {
        private Region _region;

        public GetCountryTypeExtension(Region region) {
            this._region = region;
        }

        @GraphQLField
        public Country country() throws Exception {
            return (Country)Query.this._applyComponentServiceObjects(_countryResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), countryResource -> countryResource.getCountry(this._region.getCountryId()));
        }
    }
}

