/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.hash;

import java.math.BigInteger;

public class HashValue {
    private final BigInteger _bigInteger;

    public static HashValue parse(String inputString) {
        if (inputString == null || inputString.length() == 0) {
            return null;
        }
        return new HashValue(HashValue._parseInput(inputString));
    }

    public HashValue(byte[] digest) {
        this._bigInteger = new BigInteger(1, digest);
    }

    public HashValue(String hexString) {
        this._bigInteger = new BigInteger(hexString, 16);
    }

    public byte[] asByteArray() {
        return this._bigInteger.toByteArray();
    }

    public String asCompactString() {
        return this._bigInteger.toString(36);
    }

    public String asHexString() {
        return this._bigInteger.toString(16);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HashValue)) {
            return false;
        }
        HashValue otherHashValue = (HashValue)other;
        return this._bigInteger.equals(otherHashValue._bigInteger);
    }

    public int hashCode() {
        return this._bigInteger.hashCode();
    }

    private static String _parseInput(String inputString) {
        if (inputString == null) {
            return null;
        }
        String cleaned = inputString.trim();
        int spaceIndex = (cleaned = cleaned.toLowerCase()).indexOf(32);
        if (spaceIndex != -1) {
            String firstPart = cleaned.substring(0, spaceIndex);
            if (firstPart.startsWith("md") || firstPart.startsWith("sha")) {
                cleaned = cleaned.substring(cleaned.lastIndexOf(32) + 1);
            } else if (firstPart.endsWith(":")) {
                cleaned = cleaned.substring(spaceIndex + 1);
                cleaned = cleaned.replace(" ", "");
            } else {
                cleaned = cleaned.substring(0, spaceIndex);
            }
        }
        return cleaned;
    }
}

