/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.hash;

import com.liferay.gradle.util.hash.HashValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.UncheckedException;

public class HashUtil {
    public static HashValue createHash(File file, String algorithm) {
        try {
            return HashUtil._createHash(new FileInputStream(file), algorithm);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw new UncheckedIOException(String.format("Failed to create %s hash for file %s.", algorithm, file.getAbsolutePath()), uncheckedIOException.getCause());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException((Throwable)fileNotFoundException);
        }
    }

    public static HashValue md5(File file) {
        return HashUtil.createHash(file, "MD5");
    }

    public static HashValue sha1(byte[] bytes) {
        return HashUtil._createHash(new ByteArrayInputStream(bytes), "SHA1");
    }

    public static HashValue sha1(File file) {
        return HashUtil.createHash(file, "SHA1");
    }

    public static HashValue sha1(InputStream inputStream) {
        return HashUtil._createHash(inputStream, "SHA1");
    }

    public static HashValue sha256(byte[] bytes) {
        return HashUtil._createHash(new ByteArrayInputStream(bytes), "SHA-256");
    }

    public static HashValue sha256(File file) {
        return HashUtil.createHash(file, "SHA-256");
    }

    public static HashValue sha256(InputStream inputStream) {
        return HashUtil._createHash(inputStream, "SHA-256");
    }

    public static HashValue sha512(File file) {
        return HashUtil.createHash(file, "SHA-512");
    }

    public static HashValue sha512(InputStream inputStream) {
        return HashUtil._createHash(inputStream, "SHA-512");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashValue _createHash(InputStream inputStream, String algorithm) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = HashUtil._createMessageDigest(algorithm);
            byte[] buffer = new byte[4096];
            try {
                int nread;
                while ((nread = inputStream.read(buffer)) >= 0) {
                    messageDigest.update(buffer, 0, nread);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
        return new HashValue(messageDigest.digest());
    }

    private static MessageDigest _createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)noSuchAlgorithmException);
        }
    }
}

