/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util;

import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePluginConvention;

public class OSGiUtil {
    public static String getBundleSymbolicName(Project project) {
        String groupId;
        BasePluginConvention basePluginConvention = GradleUtil.getConvention(project, BasePluginConvention.class);
        String archivesBaseName = basePluginConvention.getArchivesBaseName();
        if (archivesBaseName.startsWith(groupId = String.valueOf(project.getGroup()))) {
            return archivesBaseName;
        }
        String lastSection = groupId.substring(groupId.lastIndexOf(46) + 1);
        if (archivesBaseName.equals(lastSection)) {
            return groupId;
        }
        if (archivesBaseName.startsWith(lastSection)) {
            String artifactId = archivesBaseName.substring(lastSection.length());
            if (Character.isLetterOrDigit(artifactId.charAt(0))) {
                return OSGiUtil._getBundleSymbolicName(groupId, artifactId);
            }
            return OSGiUtil._getBundleSymbolicName(groupId, artifactId.substring(1));
        }
        return OSGiUtil._getBundleSymbolicName(groupId, archivesBaseName);
    }

    private static String _getBundleSymbolicName(String groupId, String artifactId) {
        return groupId + "." + artifactId;
    }
}

