/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.tasks;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.work.ExecuteJavaWorkAction;
import com.liferay.gradle.util.work.ExecuteJavaWorkParameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GUtil;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class ExecuteJavaTask
extends DefaultTask {
    private boolean _debugForkedJVM;
    private boolean _fork;
    private final Set<Object> _jvmArgs = new HashSet<Object>();
    private final WorkerExecutor _workerExecutor;

    @Inject
    public ExecuteJavaTask(WorkerExecutor workerExecutor) {
        this._workerExecutor = workerExecutor;
    }

    public boolean debugForkedJVM() {
        return this._debugForkedJVM;
    }

    @TaskAction
    public void executeJava() {
        this._submitWorkQueue(this._createWorkQueue());
    }

    public FileCollection getClasspath() {
        return null;
    }

    public List<String> getJvmArgs() {
        return GradleUtil.toStringList(this._jvmArgs);
    }

    public boolean isFork() {
        return this._fork;
    }

    public ExecuteJavaTask jvmArgs(Iterable<Object> jvmArgs) {
        GUtil.addToCollection(this._jvmArgs, (Iterable[])new Iterable[]{jvmArgs});
        return this;
    }

    public ExecuteJavaTask jvmArgs(Object ... jvmArgs) {
        return this.jvmArgs(Arrays.asList(jvmArgs));
    }

    public void setDebugForkedJVM(boolean debugForkedJVM) {
        this._debugForkedJVM = debugForkedJVM;
    }

    public void setFork(boolean fork) {
        this._fork = fork;
    }

    public void setJvmArgs(Iterable<Object> jvmArgs) {
        this._jvmArgs.clear();
        this.jvmArgs(jvmArgs);
    }

    public void setJvmArgs(Object ... jvmArgs) {
        this.setJvmArgs(Arrays.asList(jvmArgs));
    }

    protected List<String> getArgs() {
        return null;
    }

    protected abstract String getMain();

    protected WorkerExecutor getWorkerExecutor() {
        return this._workerExecutor;
    }

    private WorkQueue _createWorkQueue() {
        final FileCollection classpath = this.getClasspath();
        final List<String> jvmArgs = this.getJvmArgs();
        final Logger logger = this.getLogger();
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        if (this.isFork() || jvmArgs != null && !jvmArgs.isEmpty()) {
            return workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(){

                public void execute(ProcessWorkerSpec processWorkerSpec) {
                    processWorkerSpec.forkOptions((Action)new Action<JavaForkOptions>(){

                        public void execute(JavaForkOptions javaForkOptions) {
                            javaForkOptions.jvmArgs((Iterable)jvmArgs);
                            Jvm jvm = Jvm.current();
                            javaForkOptions.setEnvironment(jvm.getInheritableEnvironmentVariables(System.getenv()));
                            javaForkOptions.setDebug(ExecuteJavaTask.this.debugForkedJVM());
                        }
                    });
                    if (classpath != null && !classpath.isEmpty()) {
                        ConfigurableFileCollection processWorkerClasspath = processWorkerSpec.getClasspath();
                        processWorkerClasspath.from(new Object[]{classpath});
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Running in process isolation");
                        if (jvmArgs != null && !jvmArgs.isEmpty()) {
                            logger.info("JVM arguments: {}", (Object)jvmArgs);
                        }
                        if (classpath != null && !classpath.isEmpty()) {
                            logger.info("Classpath: {}", (Object)classpath.getAsPath());
                        }
                    }
                }
            });
        }
        if (classpath != null && !classpath.isEmpty()) {
            return workerExecutor.classLoaderIsolation((Action)new Action<ClassLoaderWorkerSpec>(){

                public void execute(ClassLoaderWorkerSpec classLoaderWorkerSpec) {
                    ConfigurableFileCollection classLoaderWorkerClasspath = classLoaderWorkerSpec.getClasspath();
                    classLoaderWorkerClasspath.from(new Object[]{classpath});
                    if (logger.isInfoEnabled()) {
                        logger.info("Running in class loader isolation: {}", (Object)classpath.getAsPath());
                    }
                }
            });
        }
        if (logger.isInfoEnabled()) {
            logger.info("Running with no isolation");
        }
        return workerExecutor.noIsolation();
    }

    private void _submitWorkQueue(WorkQueue workQueue) {
        workQueue.submit(ExecuteJavaWorkAction.class, (Action)new Action<ExecuteJavaWorkParameters>(){

            public void execute(ExecuteJavaWorkParameters executeJavaWorkParameters) {
                ListProperty<String> argsListProperty = executeJavaWorkParameters.getArgs();
                List<String> args = ExecuteJavaTask.this.getArgs();
                if (args == null) {
                    args = Collections.emptyList();
                }
                argsListProperty.set(args);
                Property<String> mainProperty = executeJavaWorkParameters.getMain();
                String main = ExecuteJavaTask.this.getMain();
                mainProperty.set((Object)main);
                Logger logger = ExecuteJavaTask.this.getLogger();
                if (logger.isInfoEnabled()) {
                    logger.info("Running {}: {}", (Object)main, args);
                }
            }
        });
    }
}

