/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.copy;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;

public class ReplaceLeadingPathAction
implements Action<FileCopyDetails> {
    private final boolean _excludeUnmatched;
    private final Map<Object, Object> _leadingPathReplacementsMap;

    public ReplaceLeadingPathAction(boolean excludeUnmatched, Map<Object, Object> leadingPathReplacementsMap) {
        this._excludeUnmatched = excludeUnmatched;
        this._leadingPathReplacementsMap = leadingPathReplacementsMap;
    }

    public ReplaceLeadingPathAction(Map<Object, Object> leadingPathReplacementsMap) {
        this(true, leadingPathReplacementsMap);
    }

    public void execute(FileCopyDetails fileCopyDetails) {
        RelativePath relativePath = fileCopyDetails.getRelativePath();
        String path = relativePath.getPathString();
        for (Map.Entry<Object, Object> entry : this._leadingPathReplacementsMap.entrySet()) {
            String oldLeadingPath = this._fixLeadingPath(entry.getKey());
            if (!path.startsWith(oldLeadingPath)) continue;
            String newLeadingPath = this._fixLeadingPath(entry.getValue());
            path = newLeadingPath + path.substring(oldLeadingPath.length());
            fileCopyDetails.setRelativePath(RelativePath.parse((boolean)true, (String)path));
            return;
        }
        if (this._excludeUnmatched) {
            fileCopyDetails.exclude();
        }
    }

    private String _fixLeadingPath(Object leadingPath) {
        String leadingPathString = GradleUtil.toString(leadingPath);
        if (Validator.isNull(leadingPathString)) {
            return "";
        }
        char lastChar = leadingPathString.charAt(leadingPathString.length() - 1);
        if (lastChar != '/') {
            leadingPathString = leadingPathString + '/';
        }
        return leadingPathString;
    }
}

