/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util;

import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class FileUtil {
    private static final File _TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Logger _logger = Logging.getLogger(FileUtil.class);

    public static void concatenate(File destinationFile, Iterable<File> sourceFiles) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);
             FileChannel destinationChannel = fileOutputStream.getChannel();){
            for (File sourceFile : sourceFiles) {
                FileInputStream fileInputStream = new FileInputStream(sourceFile);
                Throwable throwable = null;
                try {
                    FileChannel sourceChannel = fileInputStream.getChannel();
                    Throwable throwable2 = null;
                    try {
                        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (sourceChannel == null) continue;
                        if (throwable2 != null) {
                            try {
                                sourceChannel.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        sourceChannel.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
    }

    public static String createTempFileName(String prefix, String extension) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(prefix)) {
            sb.append(prefix);
        }
        sb.append(System.currentTimeMillis());
        sb.append(UUID.randomUUID());
        if (Validator.isNotNull(extension)) {
            sb.append('.');
            sb.append(extension);
        }
        return sb.toString();
    }

    public static boolean exists(Project project, String fileName) {
        File file = project.file((Object)fileName);
        return file.exists();
    }

    public static File get(Project project, String url) throws IOException {
        return FileUtil.get(project, url, null);
    }

    public static File get(Project project, String url, File destinationFile) throws IOException {
        return FileUtil.get(project, url, destinationFile, false, true);
    }

    public static synchronized File get(Project project, String url, File destinationFile, boolean ignoreErrors, boolean tryLocalNetwork) throws IOException {
        String fileName;
        String mirrorsCacheArtifactSubdir = url.replaceFirst("https?:\\/\\/(.+\\/).+", "$1");
        File mirrorsCacheArtifactDir = new File(FileUtil._getMirrorsCacheDir(), mirrorsCacheArtifactSubdir);
        File mirrorsCacheArtifactFile = new File(mirrorsCacheArtifactDir, fileName = url.replaceFirst(".+\\/(.+)", "$1"));
        if (!mirrorsCacheArtifactFile.exists()) {
            mirrorsCacheArtifactDir.mkdirs();
            String mirrorsUrl = url.replaceFirst("http:\\/\\/", "http://mirrors.lax.liferay.com/");
            if (tryLocalNetwork) {
                try {
                    FileUtil._get(project, mirrorsUrl, mirrorsCacheArtifactFile, ignoreErrors);
                }
                catch (Exception e) {
                    FileUtil._get(project, url, mirrorsCacheArtifactFile, ignoreErrors);
                }
            } else {
                FileUtil._get(project, url, mirrorsCacheArtifactFile, ignoreErrors);
            }
        }
        if (destinationFile == null) {
            return mirrorsCacheArtifactFile;
        }
        Path destinationPath = destinationFile.toPath();
        if (destinationFile.isDirectory()) {
            destinationPath = destinationPath.resolve(fileName);
        }
        Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
        Files.copy(mirrorsCacheArtifactFile.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
        return destinationPath.toFile();
    }

    public static String getAbsolutePath(File file) {
        String absolutePath = file.getAbsolutePath();
        return absolutePath.replace('\\', '/');
    }

    public static char getDriveLetter(File file) {
        if (!OSDetector.isWindows()) {
            throw new UnsupportedOperationException();
        }
        String absolutePath = FileUtil.getAbsolutePath(file);
        char driveLetter = absolutePath.charAt(0);
        return Character.toLowerCase(driveLetter);
    }

    public static boolean isChild(File file, File parentFile) {
        Path path = file.toPath();
        path = path.toAbsolutePath();
        Path parentPath = parentFile.toPath();
        return path.startsWith(parentPath = parentPath.toAbsolutePath());
    }

    public static boolean isUpToDate(Project project, Object source, Object target) {
        File sourceFile = project.file(source);
        File targetFile = project.file(target);
        if (!sourceFile.exists() || !targetFile.exists()) {
            return false;
        }
        boolean upToDate = false;
        try {
            long sourceLastModified = FileUtil._getLastModified(sourceFile);
            long targetLastModified = FileUtil._getLastModified(targetFile);
            if (targetLastModified >= sourceLastModified) {
                upToDate = true;
            }
        }
        catch (IOException ioe) {
            throw new GradleException(ioe.getMessage(), (Throwable)ioe);
        }
        return upToDate;
    }

    public static void jar(Project project, final File destinationFile, final String duplicate, final boolean update, final String[][] filesets) {
        Closure<Void> closure = new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                FileUtil._invokeAntMethodJar(antBuilder, destinationFile, duplicate, update, filesets, null);
            }
        };
        project.ant((Closure)closure);
    }

    public static String merge(Iterable<File> files, String separator) {
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.append(FileUtil.getAbsolutePath(file));
            sb.append(separator);
        }
        sb.setLength(sb.length() - separator.length());
        return sb.toString();
    }

    public static String read(String resourceName) throws IOException {
        StringBuilder sb = new StringBuilder();
        ClassLoader classLoader = FileUtil.class.getClassLoader();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(resourceName)));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static Properties readProperties(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
        }
        return properties;
    }

    public static Properties readProperties(Project project, String fileName) throws IOException {
        File file = project.file((Object)fileName);
        return FileUtil.readProperties(file);
    }

    public static String relativize(File file, File startFile) {
        Path path = file.toPath();
        Path startPath = startFile.toPath();
        Path relativePath = startPath.relativize(path);
        return relativePath.toString();
    }

    public static File replaceExtension(File file, String extension) {
        String fileName = file.getPath();
        int pos = fileName.lastIndexOf(46);
        if (pos != -1) {
            if (Validator.isNotNull(extension) && !extension.startsWith(".")) {
                extension = "." + extension;
            }
            fileName = fileName.substring(0, pos) + extension;
        }
        return new File(fileName);
    }

    public static FileCollection shrinkClasspath(Project project, FileCollection fileCollection) {
        if (!OSDetector.isWindows()) {
            return fileCollection;
        }
        ArrayList<File> shrunkClasspath = new ArrayList<File>();
        HashMap<Character, File> driveJarDirs = new HashMap<Character, File>();
        driveJarDirs.put(Character.valueOf(FileUtil.getDriveLetter(_TMP_DIR)), _TMP_DIR);
        driveJarDirs.put(Character.valueOf(FileUtil.getDriveLetter(project.getBuildDir())), project.getBuildDir());
        char curDriveLetter = '\u0000';
        ArrayList<File> curDriveFiles = new ArrayList<File>();
        for (File file : fileCollection) {
            char driveLetter = FileUtil.getDriveLetter(file);
            if (curDriveLetter != driveLetter) {
                File jarFile = FileUtil._createClasspathJarFile(project, curDriveFiles, (File)driveJarDirs.get(Character.valueOf(curDriveLetter)));
                if (jarFile != null) {
                    shrunkClasspath.add(jarFile);
                }
                curDriveLetter = driveLetter;
                curDriveFiles.clear();
            }
            if (driveJarDirs.containsKey(Character.valueOf(driveLetter))) {
                curDriveFiles.add(file);
                continue;
            }
            shrunkClasspath.add(file);
        }
        File jarFile = FileUtil._createClasspathJarFile(project, curDriveFiles, (File)driveJarDirs.get(Character.valueOf(curDriveLetter)));
        if (jarFile != null) {
            shrunkClasspath.add(jarFile);
        }
        return project.files(new Object[]{shrunkClasspath});
    }

    public static String stripExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static void write(File file, List<String> lines) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (i + 1 < lines.size()) {
                    printWriter.println(line);
                    continue;
                }
                printWriter.print(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File _createClasspathJarFile(Project project, List<File> files, File jarDir) {
        if (files.isEmpty()) {
            return null;
        }
        if (files.size() == 1) {
            return files.get(0);
        }
        AntBuilder antBuilder = project.createAntBuilder();
        jarDir.mkdirs();
        File jarFile = new File(jarDir, FileUtil.createTempFileName("classpath", "jar"));
        jarFile.deleteOnExit();
        String manifestClasspathProperty = "manifest.classpath." + jarFile.getName();
        FileUtil._invokeAntMethodManifestClasspath(antBuilder, files, jarFile, manifestClasspathProperty);
        String manifestClasspath = String.valueOf(antBuilder.getProperty(manifestClasspathProperty));
        File manifestFile = new File(jarFile.getParentFile(), jarFile.getName() + ".manifest");
        try {
            FileUtil._invokeAntMethodManifest(antBuilder, manifestFile, Collections.singletonMap("Class-Path", manifestClasspath));
            FileUtil._invokeAntMethodJar(antBuilder, jarFile, null, false, new String[0][0], manifestFile);
        }
        catch (Throwable throwable) {
            project.delete(new Object[]{manifestFile});
            throw throwable;
        }
        project.delete(new Object[]{manifestFile});
        return jarFile;
    }

    private static void _get(Project project, final String url, File destinationFile, final boolean ignoreErrors) {
        final File tmpFile = new File(destinationFile.getParentFile(), destinationFile.getName() + ".tmp");
        project.delete(new Object[]{destinationFile, tmpFile});
        Closure<Void> closure = new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dest", tmpFile);
                args.put("ignoreerrors", ignoreErrors);
                args.put("src", url);
                if (_logger.isLifecycleEnabled()) {
                    _logger.lifecycle("Trying to download " + url + " to " + tmpFile);
                }
                antBuilder.invokeMethod("get", args);
            }
        };
        project.ant((Closure)closure);
        if (!tmpFile.renameTo(destinationFile)) {
            throw new GradleException("Unable to rename " + tmpFile + " to " + destinationFile);
        }
    }

    private static long _getLastModified(File file) throws IOException {
        if (file.isFile()) {
            return file.lastModified();
        }
        final AtomicLong lastModified = new AtomicLong();
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                FileTime fileTime = basicFileAttributes.lastModifiedTime();
                long fileTimeMillis = fileTime.toMillis();
                if (fileTimeMillis > lastModified.longValue()) {
                    lastModified.set(fileTimeMillis);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return lastModified.get();
    }

    private static File _getMirrorsCacheDir() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".liferay/mirrors");
    }

    private static void _invokeAntMethod(AntBuilder antBuilder, String name, String argKey, Object argValue) {
        antBuilder.invokeMethod(name, Collections.singletonMap(argKey, argValue));
    }

    private static void _invokeAntMethodClasspath(final AntBuilder antBuilder, final String path) {
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                FileUtil._invokeAntMethod(antBuilder, "pathelement", "path", path);
            }
        };
        antBuilder.invokeMethod("classpath", (Object)closure);
    }

    private static void _invokeAntMethodFileset(AntBuilder antBuilder, String[] fileset) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("dir", fileset[0]);
        args.put("includes", fileset[1]);
        antBuilder.invokeMethod("fileset", args);
    }

    private static void _invokeAntMethodJar(final AntBuilder antBuilder, File destinationFile, String duplicate, boolean update, final String[][] filesets, File manifestFile) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("destfile", destinationFile);
        if (Validator.isNotNull(duplicate)) {
            args.put("duplicate", duplicate);
        }
        if (manifestFile != null) {
            args.put("manifest", manifestFile);
        }
        args.put("update", update);
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                for (String[] fileset : filesets) {
                    FileUtil._invokeAntMethodFileset(antBuilder, fileset);
                }
            }
        };
        antBuilder.invokeMethod("jar", (Object)new Object[]{args, closure});
    }

    private static void _invokeAntMethodManifest(final AntBuilder antBuilder, File file, final Map<String, String> attributes) {
        Map<String, File> args = Collections.singletonMap("file", file);
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                HashMap<String, Object> args = new HashMap<String, Object>();
                for (Map.Entry entry : attributes.entrySet()) {
                    args.put("name", entry.getKey());
                    args.put("value", entry.getValue());
                    antBuilder.invokeMethod("attribute", args);
                }
            }
        };
        antBuilder.invokeMethod("manifest", (Object)new Object[]{args, closure});
    }

    private static void _invokeAntMethodManifestClasspath(final AntBuilder antBuilder, final Iterable<File> files, File jarFile, String property) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("jarfile", jarFile);
        args.put("maxParentLevels", 99);
        args.put("property", property);
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                FileUtil._invokeAntMethodClasspath(antBuilder, FileUtil.merge(files, File.pathSeparator));
            }
        };
        antBuilder.invokeMethod("manifestclasspath", (Object)new Object[]{args, closure});
    }
}

