/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util;

import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.util.PatternFilterable;

public class GradleUtil {
    public static Configuration addConfiguration(Project project, String name) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return (Configuration)configurationContainer.create(name);
    }

    public static Dependency addDependency(Project project, String configurationName, File file) {
        return GradleUtil._addDependency(project, configurationName, project.files(new Object[]{file}));
    }

    public static Dependency addDependency(Project project, String configurationName, FileCollection fileCollection) {
        return GradleUtil._addDependency(project, configurationName, fileCollection);
    }

    public static Dependency addDependency(Project project, String configurationName, String dependencyNotation) {
        return GradleUtil._addDependency(project, configurationName, dependencyNotation);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version) {
        return GradleUtil.addDependency(project, configurationName, group, name, version, true);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version, boolean transitive) {
        return GradleUtil.addDependency(project, configurationName, group, name, version, null, transitive);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version, String classifier, boolean transitive) {
        HashMap<String, Object> dependencyNotation = new HashMap<String, Object>();
        if (Validator.isNotNull(classifier)) {
            dependencyNotation.put("classifier", classifier);
        }
        dependencyNotation.put("group", group);
        dependencyNotation.put("name", name);
        dependencyNotation.put("transitive", transitive);
        dependencyNotation.put("version", version);
        return GradleUtil._addDependency(project, configurationName, dependencyNotation);
    }

    public static <T> T addExtension(ExtensionAware extensionAware, String name, Class<T> clazz) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (T)extensionContainer.create(name, clazz, new Object[]{extensionAware});
    }

    public static SourceSet addSourceSet(Project project, String name) {
        JavaPluginConvention javaPluginConvention = GradleUtil.getConvention(project, JavaPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        return (SourceSet)sourceSetContainer.create(name);
    }

    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz) {
        Map<String, Class<T>> args = Collections.singletonMap("type", clazz);
        return (T)project.task(args, name);
    }

    public static <T extends Plugin<? extends Project>> void applyPlugin(Project project, Class<T> clazz) {
        Map<String, Class<T>> args = Collections.singletonMap("plugin", clazz);
        project.apply(args);
    }

    public static void applyScript(Project project, String name, Object object) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        ClassLoader classLoader = GradleUtil.class.getClassLoader();
        URL url = classLoader.getResource(name);
        if (url == null) {
            throw new GradleException("Unable to apply script " + name);
        }
        args.put("from", url);
        if (object != null) {
            args.put("to", object);
        }
        project.apply(args);
    }

    public static void executeIfEmpty(final Configuration configuration, final Action<Configuration> action) {
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        resolvableDependencies.beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencySet dependencies = configuration.getDependencies();
                Set parentConfigurations = configuration.getExtendsFrom();
                if (dependencies.isEmpty() && parentConfigurations.isEmpty()) {
                    action.execute((Object)configuration);
                }
            }
        });
    }

    public static Configuration getConfiguration(Project project, String name) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return configurationContainer.getByName(name);
    }

    public static <T> T getConvention(Project project, Class<T> clazz) {
        Convention convention = project.getConvention();
        return (T)convention.getPlugin(clazz);
    }

    public static <T> T getExtension(ExtensionAware extensionAware, Class<T> clazz) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (T)extensionContainer.getByType(clazz);
    }

    public static FileTree getFilteredFileTree(FileTree fileTree, final String[] excludes, final String[] includes) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(PatternFilterable patternFilterable) {
                if (ArrayUtil.isNotEmpty(excludes)) {
                    patternFilterable.setExcludes(Arrays.asList(excludes));
                }
                if (ArrayUtil.isNotEmpty(includes)) {
                    patternFilterable.setIncludes(Arrays.asList(includes));
                }
            }
        };
        return fileTree.matching((Closure)closure);
    }

    public static Project getProject(Project rootProject, File projectDir) {
        for (Project project : rootProject.getAllprojects()) {
            if (!projectDir.equals(project.getProjectDir())) continue;
            return project;
        }
        return null;
    }

    public static boolean getProperty(ExtensionAware extensionAware, String name, boolean defaultValue) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        if (!extraPropertiesExtension.has(name)) {
            return defaultValue;
        }
        Object value = extraPropertiesExtension.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static SourceSet getSourceSet(Project project, String name) {
        JavaPluginConvention javaPluginConvention = GradleUtil.getConvention(project, JavaPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        return (SourceSet)sourceSetContainer.getByName(name);
    }

    public static Task getTask(Project project, String name) {
        TaskContainer taskContainer = project.getTasks();
        return taskContainer.getByName(name);
    }

    public static String getTaskName(String prefix, File file) {
        String fileName = FileUtil.stripExtension(file.getName());
        fileName = fileName.replaceAll("\\W", "");
        return prefix + StringUtil.capitalize(fileName);
    }

    public static String getTaskPrefixedProperty(Task task, String name) {
        String suffix = "." + name;
        String value = System.getProperty(task.getPath() + suffix);
        if (Validator.isNull(value)) {
            value = System.getProperty(task.getName() + suffix);
        }
        return value;
    }

    public static void removeDependencies(Project project, String configurationName, String[] dependencyNotations) {
        Configuration configuration = GradleUtil.getConfiguration(project, configurationName);
        DependencySet dependencies = configuration.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            String dependencyNotation = GradleUtil._getDependencyNotation(dependency);
            if (!ArrayUtil.contains(dependencyNotations, dependencyNotation)) continue;
            iterator.remove();
        }
    }

    public static void setProperty(ExtensionAware extensionAware, String name, Object value) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        extraPropertiesExtension.set(name, value);
    }

    public static File toFile(Project project, Object object) {
        if (object == null) {
            return null;
        }
        return project.file(object);
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object object : iterable) {
            list.add(object.toString());
        }
        return list;
    }

    public static boolean waitFor(Callable<Boolean> callable, long checkInterval, long timeout) throws Exception {
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end) {
            if (callable.call().booleanValue()) {
                return true;
            }
            Thread.sleep(checkInterval);
        }
        return false;
    }

    private static Dependency _addDependency(Project project, String configurationName, Object dependencyNotation) {
        DependencyHandler dependencyHandler = project.getDependencies();
        return dependencyHandler.add(configurationName, dependencyNotation);
    }

    private static String _getDependencyNotation(Dependency dependency) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(dependency.getGroup())) {
            sb.append(dependency.getGroup());
            sb.append(":");
        }
        sb.append(dependency.getName());
        if (Validator.isNotNull(dependency.getVersion())) {
            sb.append(":");
            sb.append(dependency.getVersion());
        }
        return sb.toString();
    }
}

