/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util;

import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;

public class FileUtil {
    public static void concatenate(File destinationFile, Iterable<File> sourceFiles) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);
             FileChannel destinationChannel = fileOutputStream.getChannel();){
            for (File sourceFile : sourceFiles) {
                FileInputStream fileInputStream = new FileInputStream(sourceFile);
                Throwable throwable = null;
                try {
                    FileChannel sourceChannel = fileInputStream.getChannel();
                    Throwable throwable2 = null;
                    try {
                        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (sourceChannel == null) continue;
                        if (throwable2 != null) {
                            try {
                                sourceChannel.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        sourceChannel.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
    }

    public static boolean exists(Project project, String fileName) {
        File file = project.file((Object)fileName);
        return file.exists();
    }

    public static File get(Project project, String url) throws IOException {
        return FileUtil.get(project, url, null);
    }

    public static File get(Project project, String url, File destinationFile) throws IOException {
        return FileUtil.get(project, url, destinationFile, false, true, false);
    }

    public static File get(Project project, String url, File destinationFile, boolean ignoreErrors, boolean tryLocalNetwork, boolean verbose) throws IOException {
        String fileName;
        String mirrorsCacheArtifactSubdir = url.replaceFirst("https?:\\/\\/(.+\\/).+", "$1");
        File mirrorsCacheArtifactDir = new File(FileUtil._getMirrorsCacheDir(), mirrorsCacheArtifactSubdir);
        File mirrorsCacheArtifactFile = new File(mirrorsCacheArtifactDir, fileName = url.replaceFirst(".+\\/(.+)", "$1"));
        if (!mirrorsCacheArtifactFile.exists()) {
            mirrorsCacheArtifactDir.mkdirs();
            String mirrorsUrl = url.replaceFirst("http:\\/\\/", "http://mirrors/");
            if (tryLocalNetwork) {
                try {
                    FileUtil._get(project, mirrorsUrl, mirrorsCacheArtifactFile, ignoreErrors, verbose);
                }
                catch (Exception e) {
                    FileUtil._get(project, url, mirrorsCacheArtifactFile, ignoreErrors, verbose);
                }
            } else {
                FileUtil._get(project, url, mirrorsCacheArtifactFile, ignoreErrors, verbose);
            }
        }
        if (destinationFile == null) {
            return mirrorsCacheArtifactFile;
        }
        Path destinationPath = destinationFile.toPath();
        if (destinationFile.isDirectory()) {
            destinationPath = destinationPath.resolve(fileName);
        }
        Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
        Files.copy(mirrorsCacheArtifactFile.toPath(), destinationPath, new CopyOption[0]);
        return destinationPath.toFile();
    }

    public static String getAbsolutePath(File file) {
        String absolutePath = file.getAbsolutePath();
        return absolutePath.replace('\\', '/');
    }

    public static boolean isChild(File file, File parentFile) {
        Path path = file.toPath();
        path = path.toAbsolutePath();
        Path parentPath = parentFile.toPath();
        return path.startsWith(parentPath = parentPath.toAbsolutePath());
    }

    public static void jar(Project project, final File destinationFile, final String duplicate, final boolean update, final String[][] filesets) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(AntBuilder antBuilder) {
                FileUtil._invokeAntMethodJar(antBuilder, destinationFile, duplicate, update, filesets);
            }
        };
        project.ant((Closure)closure);
    }

    public static String read(String resourceName) throws IOException {
        StringBuilder sb = new StringBuilder();
        ClassLoader classLoader = FileUtil.class.getClassLoader();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(resourceName)));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static Properties readProperties(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
        }
        return properties;
    }

    public static Properties readProperties(Project project, String fileName) throws IOException {
        File file = project.file((Object)fileName);
        return FileUtil.readProperties(file);
    }

    public static String relativize(File file, File startFile) {
        Path path = file.toPath();
        Path startPath = startFile.toPath();
        Path relativePath = startPath.relativize(path);
        return relativePath.toString();
    }

    public static File replaceExtension(File file, String extension) {
        String fileName = file.getPath();
        int pos = fileName.lastIndexOf(46);
        if (pos != -1) {
            if (Validator.isNotNull(extension) && !extension.startsWith(".")) {
                extension = "." + extension;
            }
            fileName = fileName.substring(0, pos) + extension;
        }
        return new File(fileName);
    }

    public static String stripExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static void unzip(Project project, final File sourceFile, final File destinationFile, final int cutDirs, final String[] excludes, final String[] includes) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(AntBuilder antBuilder) {
                FileUtil._invokeAntMethodUnzip(antBuilder, sourceFile, destinationFile, cutDirs, excludes, includes);
            }
        };
        project.ant((Closure)closure);
    }

    public static void write(File file, List<String> lines) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (i + 1 < lines.size()) {
                    printWriter.println(line);
                    continue;
                }
                printWriter.print(line);
            }
        }
    }

    private static void _get(Project project, final String url, final File destinationFile, final boolean ignoreErrors, final boolean verbose) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(AntBuilder antBuilder) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dest", destinationFile);
                args.put("ignoreerrors", ignoreErrors);
                args.put("src", url);
                args.put("verbose", verbose);
                antBuilder.invokeMethod("get", args);
            }
        };
        project.ant((Closure)closure);
    }

    private static File _getMirrorsCacheDir() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".liferay/mirrors");
    }

    private static void _invokeAntMethod(AntBuilder antBuilder, String method, String paramName, Object paramValue) {
        Map<String, Object> args = Collections.singletonMap(paramName, paramValue);
        antBuilder.invokeMethod(method, args);
    }

    private static void _invokeAntMethodFileset(AntBuilder antBuilder, String[] fileset) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("dir", fileset[0]);
        args.put("includes", fileset[1]);
        antBuilder.invokeMethod("fileset", args);
    }

    private static void _invokeAntMethodJar(final AntBuilder antBuilder, File destinationFile, String duplicate, boolean update, final String[][] filesets) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("destfile", destinationFile);
        args.put("duplicate", duplicate);
        args.put("update", update);
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall() {
                for (String[] fileset : filesets) {
                    FileUtil._invokeAntMethodFileset(antBuilder, fileset);
                }
            }
        };
        antBuilder.invokeMethod("jar", (Object)new Object[]{args, closure});
    }

    private static void _invokeAntMethodPatternset(final AntBuilder antBuilder, final String[] excludes, final String[] includes) {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall() {
                if (ArrayUtil.isNotEmpty(excludes)) {
                    for (String exclude : excludes) {
                        FileUtil._invokeAntMethod(antBuilder, "exclude", "name", exclude);
                    }
                }
                if (ArrayUtil.isNotEmpty(includes)) {
                    for (String include : includes) {
                        FileUtil._invokeAntMethod(antBuilder, "include", "name", include);
                    }
                }
            }
        };
        antBuilder.invokeMethod("patternset", (Object)closure);
    }

    private static void _invokeAntMethodUnzip(final AntBuilder antBuilder, File sourceFile, File destinationFile, final int cutDirs, final String[] excludes, final String[] includes) {
        HashMap<String, File> args = new HashMap<String, File>();
        args.put("dest", destinationFile);
        args.put("src", sourceFile);
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall() {
                if (cutDirs > 0) {
                    FileUtil._invokeAntMethod(antBuilder, "cutdirsmapper", "dirs", cutDirs);
                }
                FileUtil._invokeAntMethodPatternset(antBuilder, excludes, includes);
            }
        };
        antBuilder.invokeMethod("unzip", (Object)new Object[]{args, closure});
    }
}

