/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.BundleTaskConvention;
import aQute.bnd.gradle.PropertiesWrapper;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Reporter;
import com.liferay.gradle.plugins.JspCDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.internal.AlloyTaglibDefaultsPlugin;
import com.liferay.gradle.plugins.internal.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.DBSupportDefaultsPlugin;
import com.liferay.gradle.plugins.internal.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JSModuleConfigGeneratorDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JavadocFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.RESTBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.ServiceBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.SpotBugsDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TLDFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TestIntegrationDefaultsPlugin;
import com.liferay.gradle.plugins.internal.UpgradeTableBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WSDDBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WatchOSGiPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.IncludeResourceCompileIncludeInstruction;
import com.liferay.gradle.plugins.internal.util.copy.RenameDependencyAction;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.javadoc.formatter.JavadocFormatterPlugin;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerBasePlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerPlugin;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.soy.SoyPlugin;
import com.liferay.gradle.plugins.soy.SoyTranslationPlugin;
import com.liferay.gradle.plugins.soy.tasks.BuildSoyTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.tld.formatter.TLDFormatterPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.TLDDocBuilderPlugin;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RelativePath;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;

public class LiferayOSGiPlugin
implements Plugin<Project> {
    public static final String AUTO_CLEAN_PROPERTY_NAME = "autoClean";
    public static final String AUTO_UPDATE_XML_TASK_NAME = "autoUpdateXml";
    public static final String CLEAN_DEPLOYED_PROPERTY_NAME = "cleanDeployed";
    public static final String COMPILE_INCLUDE_CONFIGURATION_NAME = "compileInclude";
    public static final String DEPLOY_DEPENDENCIES_TASK_NAME = "deployDependencies";
    public static final String DEPLOY_FAST_TASK_NAME = "deployFast";
    public static final String PLUGIN_NAME = "liferayOSGi";
    private static final String _CACHE_PLUGIN_ID = "com.liferay.cache";
    private static final Logger _logger = Logging.getLogger(LiferayOSGiPlugin.class);
    private static final Pattern _keyRegex = Pattern.compile("[a-z][\\p{Alnum}-_.]*");

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, LiferayOSGiExtension.class);
        this._applyPlugins(project);
        Configuration compileIncludeConfiguration = this._addConfigurationCompileInclude(project);
        this._configureArchivesBaseName(project);
        this._configureDescription(project);
        this._configureLiferay(project, liferayExtension);
        this._configureSourceSetMain(project);
        this._configureVersion(project);
        TaskProvider deployDependenciesTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)DEPLOY_DEPENDENCIES_TASK_NAME, Copy.class);
        TaskProvider deployFastTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)DEPLOY_FAST_TASK_NAME, Copy.class);
        TaskProvider directDeployTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME, DirectDeployTask.class);
        TaskProvider classesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"classes");
        TaskProvider cleanTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"clean", Delete.class);
        TaskProvider compileJSPTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"compileJSP", JavaCompile.class);
        TaskProvider deployTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"deploy", Copy.class);
        TaskProvider jarTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"jar", Jar.class);
        TaskProvider javadocTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"javadoc", Javadoc.class);
        TaskProvider processResourcesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"processResources", Copy.class);
        TaskProvider testTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"test", Test.class);
        this._configureTaskProviderAutoUpdateXml(project, liferayExtension, (TaskProvider<DirectDeployTask>)directDeployTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskProviderClean(project, (TaskProvider<Delete>)cleanTaskProvider);
        this._configureTaskProviderDeploy((TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Copy>)deployDependenciesTaskProvider);
        this._configureTaskProviderDeployDependencies(liferayExtension, (TaskProvider<Copy>)deployDependenciesTaskProvider);
        this._configureTaskProviderDeployFast(project, liferayExtension, (TaskProvider<Task>)classesTaskProvider, (TaskProvider<JavaCompile>)compileJSPTaskProvider, (TaskProvider<Copy>)deployFastTaskProvider, (TaskProvider<Copy>)processResourcesTaskProvider);
        this._configureTaskProviderJar(project, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskProviderJavadoc(project, (TaskProvider<Javadoc>)javadocTaskProvider);
        this._configureTaskProviderTest((TaskProvider<Test>)testTaskProvider);
        this._configureTaskProviderClean(liferayExtension, (TaskProvider<Delete>)cleanTaskProvider, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskProviderDeploy(project, liferayExtension, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Jar>)jarTaskProvider, false);
        this._configureTasksBuildWSDD(project, liferayExtension, (TaskProvider<Delete>)cleanTaskProvider, (TaskProvider<Copy>)deployTaskProvider);
        this._configureTasksTest(project);
        if (GradleUtil.isRunningInsideDaemon()) {
            this._configureTasksJavaCompileFork(project, true);
        }
        GradleUtil.withPlugin(project, ApplicationPlugin.class, applicationPlugin -> {
            TaskProvider runTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"run", JavaExec.class);
            this._configureApplication(project);
            this._configureTaskProviderRun(compileIncludeConfiguration, (TaskProvider<JavaExec>)runTaskProvider);
        });
        project.afterEvaluate(curProject -> {
            this._configureBundleExtensionAfterEvaluate((Project)curProject, liferayOSGiExtension, compileIncludeConfiguration);
            this._configureTaskProviderDeployDependenciesAfterEvaluate((TaskProvider<Copy>)deployDependenciesTaskProvider);
        });
    }

    private Configuration _addConfigurationCompileInclude(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)COMPILE_INCLUDE_CONFIGURATION_NAME);
        configuration.setDescription("Additional dependencies to include in the final JAR.");
        configuration.setVisible(false);
        Configuration compileOnlyConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compileOnly");
        compileOnlyConfiguration.extendsFrom(new Configuration[]{configuration});
        return configuration;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        this._configureBundleExtension(project);
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        if (GradleUtil.hasTask(project, "packageRunBuild")) {
            GradleUtil.applyPlugin((Project)project, JSTranspilerBasePlugin.class);
        } else {
            GradleUtil.applyPlugin((Project)project, JSModuleConfigGeneratorPlugin.class);
            GradleUtil.applyPlugin((Project)project, JSTranspilerPlugin.class);
        }
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, JavadocFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, JspCPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyTranslationPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDDocBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, TestIntegrationPlugin.class);
        AlloyTaglibDefaultsPlugin.INSTANCE.apply((Object)project);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        DBSupportDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        JSModuleConfigGeneratorDefaultsPlugin.INSTANCE.apply((Object)project);
        JavadocFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        JspCDefaultsPlugin.INSTANCE.apply((Object)project);
        RESTBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        ServiceBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        SpotBugsDefaultsPlugin.INSTANCE.apply((Object)project);
        TLDFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        TestIntegrationDefaultsPlugin.INSTANCE.apply((Object)project);
        UpgradeTableBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WSDDBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WatchOSGiPlugin.INSTANCE.apply((Object)project);
    }

    private void _configureApplication(Project project) {
        ApplicationPluginConvention applicationPluginConvention = (ApplicationPluginConvention)GradleUtil.getConvention((Project)project, ApplicationPluginConvention.class);
        String mainClassName = BndUtil.getInstruction(project, "Main-Class");
        if (Validator.isNotNull((String)mainClassName)) {
            applicationPluginConvention.setMainClassName(mainClassName);
        }
    }

    private void _configureArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        String bundleSymbolicName = BndUtil.getInstruction(project, "Bundle-SymbolicName");
        if (Validator.isNull((String)bundleSymbolicName)) {
            return;
        }
        Parameters parameters = new Parameters(bundleSymbolicName);
        Set keys = parameters.keySet();
        Iterator iterator = keys.iterator();
        bundleSymbolicName = (String)iterator.next();
        basePluginConvention.setArchivesBaseName(bundleSymbolicName);
    }

    private void _configureBundleExtension(Project project) {
        BundleExtension bundleExtension = new BundleExtension();
        ExtensionContainer extensionContainer = project.getExtensions();
        extensionContainer.add(BundleExtension.class, "bundle", (Object)bundleExtension);
        File file = project.file((Object)"bnd.bnd");
        if (!file.exists()) {
            return;
        }
        UTF8Properties utf8Properties = new UTF8Properties();
        try (Processor processor = new Processor();){
            utf8Properties.load(file, (Reporter)processor);
            Enumeration keys = utf8Properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = utf8Properties.getProperty(key);
                bundleExtension.put(key, (Object)value);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Could not read " + file, (Throwable)exception);
        }
    }

    private void _configureBundleExtensionAfterEvaluate(Project project, LiferayOSGiExtension liferayOSGiExtension, Configuration compileIncludeConfiguration) {
        BundleExtension bundleInstructions = BndUtil.getInstructions(project);
        IncludeResourceCompileIncludeInstruction includeResourceCompileIncludeInstruction = new IncludeResourceCompileIncludeInstruction(() -> compileIncludeConfiguration, liferayOSGiExtension::isExpandCompileInclude);
        bundleInstructions.put("-includeresource." + compileIncludeConfiguration.getName(), includeResourceCompileIncludeInstruction);
        Map<String, Object> bundleDefaultInstructions = liferayOSGiExtension.getBundleDefaultInstructions();
        for (Map.Entry<String, Object> entry : bundleDefaultInstructions.entrySet()) {
            String key = entry.getKey();
            if (bundleInstructions.containsKey(key)) continue;
            bundleInstructions.put(key, entry.getValue());
        }
    }

    private void _configureDescription(Project project) {
        String description = BndUtil.getInstruction(project, "Bundle-Description");
        if (Validator.isNull((String)description)) {
            description = BndUtil.getInstruction(project, "Bundle-Name");
        }
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
    }

    private void _configureLiferay(Project project, LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir(() -> {
            File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/modules");
            return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
        });
    }

    private void _configureSourceSetMain(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            return;
        }
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        File javaClassesDir = new File(docrootDir, "WEB-INF/classes");
        SourceDirectorySet javaSourceDirectorySet = sourceSet.getJava();
        javaSourceDirectorySet.setOutputDir(javaClassesDir);
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        sourceSetOutput.setResourcesDir(javaClassesDir);
        File srcDir = new File(docrootDir, "WEB-INF/src");
        Set<File> srcDirs = Collections.singleton(srcDir);
        javaSourceDirectorySet.setSrcDirs(srcDirs);
        SourceDirectorySet resourcesSourceDirectorySet = sourceSet.getResources();
        resourcesSourceDirectorySet.setSrcDirs(srcDirs);
    }

    private void _configureTaskJavaCompileFork(JavaCompile javaCompile, boolean fork) {
        CompileOptions compileOptions = javaCompile.getOptions();
        compileOptions.setFork(fork);
    }

    private void _configureTaskProviderAutoUpdateXml(Project project, LiferayExtension liferayExtension, TaskProvider<DirectDeployTask> directDeployTaskProvider, TaskProvider<Jar> jarTaskProvider) {
        directDeployTaskProvider.configure(directDeployTask -> {
            directDeployTask.setAppServerDeployDir(directDeployTask.getTemporaryDir());
            directDeployTask.setAppServerType("tomcat");
            Jar jarTask = (Jar)jarTaskProvider.get();
            directDeployTask.setWebAppFile(() -> FileUtil.replaceExtension((File)jarTask.getArchivePath(), (String)"war"));
            directDeployTask.setWebAppType("portlet");
            directDeployTask.doFirst(task -> {
                File jarFile = jarTask.getArchivePath();
                jarFile.renameTo(directDeployTask.getWebAppFile());
            });
            directDeployTask.doLast(task -> {
                Logger logger = task.getLogger();
                project.delete(new Object[]{"liferay/logs"});
                File liferayDir = project.file((Object)"liferay");
                boolean deleted = liferayDir.delete();
                if (!deleted && logger.isInfoEnabled()) {
                    logger.info("Unable to delete " + liferayDir);
                }
            });
            directDeployTask.doLast(task -> {
                String deployedPluginDirName = FileUtil.stripExtension((String)jarTask.getArchiveName());
                File deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), deployedPluginDirName);
                if (!deployedPluginDir.exists()) {
                    deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), project.getName());
                }
                if (!deployedPluginDir.exists()) {
                    _logger.warn("Unable to automatically update web.xml in " + jarTask.getArchivePath());
                    return;
                }
                FileUtil.touchFiles(project, deployedPluginDir, 0L, "WEB-INF/liferay-web.xml", "WEB-INF/web.xml", "WEB-INF/tld/*");
                deployedPluginDirName = project.relativePath((Object)deployedPluginDir);
                String[][] filesets = new String[][]{{project.relativePath((Object)liferayExtension.getAppServerPortalDir()), "WEB-INF/tld/c.tld"}, {deployedPluginDirName, "WEB-INF/liferay-web.xml,WEB-INF/web.xml"}, {deployedPluginDirName, "WEB-INF/tld/*"}};
                File warFile = directDeployTask.getWebAppFile();
                FileUtil.jar((Project)project, (File)warFile, (String)"preserve", (boolean)true, (String[][])filesets);
                warFile.renameTo(jarTask.getArchivePath());
            });
            directDeployTask.onlyIf(task -> {
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                return liferayOSGiExtension.isAutoUpdateXml() && FileUtil.exists((Project)project, (String)"docroot/WEB-INF/portlet.xml");
            });
            TaskInputsInternal taskInputs = directDeployTask.getInputs();
            taskInputs.file(() -> ((Jar)jarTask).getArchivePath());
        });
        jarTaskProvider.configure(jar -> jar.finalizedBy(new Object[]{directDeployTaskProvider}));
    }

    private void _configureTaskProviderBuildWSDDJar(Project project, LiferayExtension liferayExtension, BuildWSDDTask buildWSDDTask, TaskProvider<Jar> buildWSDDJarTaskProvider, TaskProvider<Delete> cleanTaskProvider, TaskProvider<Copy> deployTaskProvider) {
        buildWSDDJarTaskProvider.configure(buildWSDDJarTask -> {
            buildWSDDJarTask.setActions(Collections.emptyList());
            buildWSDDJarTask.dependsOn(new Object[]{buildWSDDTask});
            buildWSDDJarTask.doLast(task -> {
                Logger logger = project.getLogger();
                PropertiesWrapper gradleProperties = new PropertiesWrapper();
                gradleProperties.put("project", project);
                gradleProperties.put("task", task);
                try (Builder builder = new Builder(new Processor((Properties)gradleProperties, false));){
                    String bundleVersion;
                    String bundleSymbolicName;
                    Map<String, String> properties = this._getBuilderProperties(project, buildWSDDTask);
                    File buildFile = project.getBuildFile();
                    builder.setBase(buildFile.getParentFile());
                    builder.putAll(properties, true);
                    SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                    SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
                    SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                    ConfigurableFileCollection buildDirs = project.files(new Object[]{sourceDirectorySet.getOutputDir(), sourceSetOutput.getResourcesDir()});
                    builder.setClasspath(buildDirs.getFiles().toArray(new File[0]));
                    builder.setProperty("project.buildpath", buildDirs.getAsPath());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Classpath: {}", (Object)buildDirs.getAsPath());
                    }
                    SourceDirectorySet allSource = sourceSet.getAllSource();
                    Set srcDirs = allSource.getSrcDirs();
                    Stream stream = srcDirs.stream();
                    ConfigurableFileCollection sourceDirs = project.files(new Object[]{stream.filter(File::exists).collect(Collectors.toList())});
                    builder.setProperty("project.sourcepath", sourceDirs.getAsPath());
                    builder.setSourcepath(sourceDirs.getFiles().toArray(new File[0]));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Sourcepath: {}", (Object)builder.getSourcePath());
                    }
                    if (Validator.isNull((String)(bundleSymbolicName = builder.getProperty("Bundle-SymbolicName"))) || "<<EMPTY>>".equals(bundleSymbolicName)) {
                        builder.setProperty("Bundle-SymbolicName", project.getName());
                    }
                    if ((Validator.isNull((String)(bundleVersion = builder.getProperty("Bundle-Version"))) || "<<EMPTY>>".equals(bundleVersion)) && project.getVersion() != null) {
                        Object version = project.getVersion();
                        MavenVersion mavenVersion = MavenVersion.parseString((String)version.toString());
                        Version osgiVersion = mavenVersion.getOSGiVersion();
                        builder.setProperty("Bundle-Version", osgiVersion.toString());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Properties: {}", properties);
                    }
                    aQute.bnd.osgi.Jar bndJar = builder.build();
                    if (!builder.isOk()) {
                        BndUtils.logReport((Object)builder, (Logger)logger);
                        new GradleException(buildWSDDTask + " failed");
                    }
                    TaskOutputs taskOutputs = task.getOutputs();
                    FileCollection fileCollection = taskOutputs.getFiles();
                    bndJar.write(fileCollection.getSingleFile());
                    BndUtils.logReport((Object)builder, (Logger)logger);
                    if (!builder.isOk()) {
                        new GradleException(buildWSDDTask + " failed");
                    }
                }
                catch (Exception exception) {
                    new GradleException(buildWSDDTask + " failed", (Throwable)exception);
                }
            });
            String taskName = buildWSDDTask.getName();
            if (taskName.equals("buildWSDD")) {
                buildWSDDJarTask.setAppendix("wsdd");
            } else {
                buildWSDDJarTask.setAppendix("wsdd-" + taskName);
            }
            buildWSDDTask.finalizedBy(new Object[]{buildWSDDJarTask});
        });
        this._configureTaskProviderClean(liferayExtension, cleanTaskProvider, deployTaskProvider, buildWSDDJarTaskProvider);
        this._configureTaskProviderDeploy(project, liferayExtension, deployTaskProvider, buildWSDDJarTaskProvider, true);
    }

    private void _configureTaskProviderClean(LiferayExtension liferayExtension, TaskProvider<Delete> cleanTaskProvider, TaskProvider<Copy> deployTaskProvider, TaskProvider<Jar> jarTaskProvider) {
        cleanTaskProvider.configure(cleanTask -> cleanTask.delete(new Object[]{() -> {
            boolean cleanDeployed = GradleUtil.getProperty((ExtensionAware)cleanTask, (String)CLEAN_DEPLOYED_PROPERTY_NAME, (boolean)true);
            if (!cleanDeployed) {
                return null;
            }
            Copy deployTask = (Copy)deployTaskProvider.get();
            Jar jarTask = (Jar)jarTaskProvider.get();
            Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
            return new File(deployTask.getDestinationDir(), (String)deployedFileNameClosure.call((Object)jarTask));
        }}));
    }

    private void _configureTaskProviderClean(Project project, TaskProvider<Delete> cleanTaskProvider) {
        cleanTaskProvider.configure(cleanTask -> {
            Closure<Set<String>> c = new Closure<Set<String>>((Object)project){

                public Set<String> doCall(Delete delete) {
                    HashSet<String> cleanTaskNames = new HashSet<String>();
                    Project project = delete.getProject();
                    for (Task task : project.getTasks()) {
                        TaskOutputs taskOutputs;
                        boolean autoClean;
                        String taskName = task.getName();
                        if (taskName.equals(LiferayOSGiPlugin.DEPLOY_FAST_TASK_NAME) || taskName.equals("deploy") || taskName.equals("eclipseClasspath") || taskName.equals("eclipseProject") || taskName.equals("ideaModule") || task instanceof BuildSoyTask || task instanceof DownloadNodeModuleTask || task instanceof NpmInstallTask || GradleUtil.hasPlugin(project, LiferayOSGiPlugin._CACHE_PLUGIN_ID) && taskName.startsWith("save") && taskName.endsWith("Cache") || GradleUtil.hasPlugin(project, WSDLBuilderPlugin.class) && taskName.startsWith("buildWSDLGenerate") || !(autoClean = GradleUtil.getProperty((ExtensionAware)task, (String)LiferayOSGiPlugin.AUTO_CLEAN_PROPERTY_NAME, (boolean)true)) || !(taskOutputs = task.getOutputs()).getHasOutput()) continue;
                        cleanTaskNames.add("clean" + StringUtil.capitalize((String)taskName));
                    }
                    return cleanTaskNames;
                }
            };
            cleanTask.dependsOn(new Object[]{c});
        });
    }

    private void _configureTaskProviderDeploy(final Project project, final LiferayExtension liferayExtension, TaskProvider<Copy> deployTaskProvider, TaskProvider<Jar> jarTaskProvider, boolean lazy) {
        deployTaskProvider.configure(deployTask -> {
            Jar jarTask;
            Object sourcePath = jarTask = (Jar)jarTaskProvider.get();
            if (lazy) {
                sourcePath = () -> jarTask.getArchivePath();
            }
            Closure<Void> copySpecClosure = new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.rename((Closure)new Closure<String>((Object)project){

                        public String doCall(String fileName) {
                            Closure<String> closure = liferayExtension.getDeployedFileNameClosure();
                            return (String)closure.call((Object)jarTask);
                        }
                    });
                }
            };
            deployTask.from(sourcePath, (Closure)copySpecClosure);
        });
    }

    private void _configureTaskProviderDeploy(TaskProvider<Copy> deployTaskProvider, TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployTaskProvider.configure(deployTask -> deployTask.finalizedBy(new Object[]{deployDependenciesTaskProvider}));
    }

    private void _configureTaskProviderDeployDependencies(LiferayExtension liferayExtension, TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployDependenciesTaskProvider.configure(deployDependenciesTask -> {
            boolean keepVersions = Boolean.getBoolean("deploy.dependencies.keep.versions");
            GradleUtil.setProperty((ExtensionAware)deployDependenciesTask, (String)AUTO_CLEAN_PROPERTY_NAME, (Object)false);
            GradleUtil.setProperty((ExtensionAware)deployDependenciesTask, (String)"keepVersions", (Object)keepVersions);
            String renameSuffix = ".jar";
            if (keepVersions) {
                renameSuffix = "-$1.jar";
            }
            GradleUtil.setProperty((ExtensionAware)deployDependenciesTask, (String)"renameSuffix", (Object)renameSuffix);
            deployDependenciesTask.into(liferayExtension::getDeployDir);
            deployDependenciesTask.setDescription("Deploys additional dependencies.");
            TaskOutputsInternal taskOutputs = deployDependenciesTask.getOutputs();
            taskOutputs.upToDateWhen(task -> false);
        });
    }

    private void _configureTaskProviderDeployDependenciesAfterEvaluate(TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployDependenciesTaskProvider.configure(deployDependenciesTask -> deployDependenciesTask.eachFile((Action)new RenameDependencyAction(Boolean.getBoolean("deploy.dependencies.keep.versions"))));
    }

    private void _configureTaskProviderDeployFast(Project project, LiferayExtension liferayExtension, TaskProvider<Task> classesTaskProvider, TaskProvider<JavaCompile> compileJSPTaskProvider, TaskProvider<Copy> deployFastTaskProvider, TaskProvider<Copy> processResourcesTaskProvider) {
        deployFastTaskProvider.configure(deployFastTask -> {
            deployFastTask.setDescription("Builds and deploys resources to the Liferay work directory.");
            deployFastTask.setGroup("build");
            deployFastTask.setDestinationDir(liferayExtension.getLiferayHome());
            deployFastTask.setIncludeEmptyDirs(false);
            String bundleSymbolicName = BndUtil.getInstruction(project, "Bundle-SymbolicName");
            String bundleVersion = BndUtil.getInstruction(project, "Bundle-Version");
            StringBuilder sb = new StringBuilder();
            sb.append("work/");
            sb.append(bundleSymbolicName);
            sb.append("-");
            sb.append(bundleVersion);
            final String pathName = sb.toString();
            deployFastTask.from((Object)compileJSPTaskProvider, (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.into((Object)pathName);
                }
            });
            deployFastTask.from((Object)processResourcesTaskProvider, (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    Action action = details -> {
                        RelativePath relativePath = details.getRelativePath();
                        String[] segments = relativePath.getSegments();
                        if (segments.length > 4 && segments[2].equals("META-INF") && segments[3].equals("resources")) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(segments[0]);
                            list.add(segments[1]);
                            for (int i = 4; i < segments.length; ++i) {
                                String segment = segments[i];
                                if (segment.equals(".sass-cache")) continue;
                                list.add(segment);
                            }
                            segments = list.toArray(new String[0]);
                        }
                        details.setRelativePath(new RelativePath(true, segments));
                    };
                    copySpec.eachFile(action);
                    copySpec.include(new String[]{"**/*.css"});
                    copySpec.include(new String[]{"**/*.css.map"});
                    copySpec.into((Object)pathName);
                }
            });
            deployFastTask.dependsOn(new Object[]{classesTaskProvider});
            SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            deployFastTask.from((Object)mainSourceSet.getOutput(), (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    Action action = details -> {
                        RelativePath relativePath = details.getRelativePath();
                        String[] segments = relativePath.getSegments();
                        if (segments.length > 4 && segments[2].equals("META-INF") && segments[3].equals("resources")) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(segments[0]);
                            list.add(segments[1]);
                            for (int i = 4; i < segments.length; ++i) {
                                list.add(segments[i]);
                            }
                            segments = list.toArray(new String[0]);
                        }
                        details.setRelativePath(new RelativePath(true, segments));
                    };
                    copySpec.eachFile(action);
                    copySpec.include(new String[]{"**/*.js"});
                    copySpec.include(new String[]{"**/*.js.map"});
                    copySpec.into((Object)pathName);
                }
            });
        });
    }

    private void _configureTaskProviderJar(Project project, TaskProvider<Jar> jarTaskProvider) {
        jarTaskProvider.configure(jarTask -> {
            Convention convention = jarTask.getConvention();
            Map plugins = convention.getPlugins();
            BundleTaskConvention bundleTaskConvention = new BundleTaskConvention(jarTask);
            plugins.put("bundle", bundleTaskConvention);
            jarTask.setDescription("Assembles a bundle containing the main classes.");
            jarTask.doFirst(task -> {
                BundleExtension instructions = BndUtil.getInstructions(project);
                instructions.forEach((k, v) -> instructions.put(k, GradleUtil.toString((Object)v)));
                Map projectProperties = project.getProperties();
                for (Map.Entry entry : projectProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    Matcher matcher = _keyRegex.matcher(key);
                    if (!matcher.matches() || !(value instanceof String)) continue;
                    instructions.put(key, entry.getValue());
                }
                bundleTaskConvention.setBnd((Map)instructions);
            });
            jarTask.doLast(task -> bundleTaskConvention.buildBundle());
            File bndFile = project.file((Object)"bnd.bnd");
            if (!bndFile.exists()) {
                return;
            }
            TaskInputsInternal taskInputs = jarTask.getInputs();
            taskInputs.file((Object)bndFile);
        });
    }

    private void _configureTaskProviderJavadoc(Project project, TaskProvider<Javadoc> javadocTaskProvider) {
        String bundleName = BndUtil.getInstruction(project, "Bundle-Name");
        String bundleVersion = BndUtil.getInstruction(project, "Bundle-Version");
        if (Validator.isNull((String)bundleName) || Validator.isNull((String)bundleVersion)) {
            return;
        }
        javadocTaskProvider.configure(javadocTask -> javadocTask.setTitle(String.format("%s %s API", bundleName, bundleVersion)));
    }

    private void _configureTaskProviderRun(Configuration compileIncludeConfiguration, TaskProvider<JavaExec> runTaskProvider) {
        runTaskProvider.configure(runTask -> runTask.classpath(new Object[]{compileIncludeConfiguration}));
    }

    private void _configureTaskProviderTest(TaskProvider<Test> testTaskProvider) {
        testTaskProvider.configure(testTask -> {
            testTask.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Dliferay.mode=test", "-Duser.timezone=GMT"});
            testTask.setForkEvery(Long.valueOf(1L));
        });
    }

    private void _configureTasksBuildWSDD(Project project, LiferayExtension liferayExtension, TaskProvider<Delete> cleanTaskProvider, TaskProvider<Copy> deployTaskProvider) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, buildWSDDTask -> {
            TaskProvider taskProvider = GradleUtil.addTaskProvider((Project)project, (String)(buildWSDDTask.getName() + "Jar"), Jar.class);
            this._configureTaskProviderBuildWSDDJar(project, liferayExtension, (BuildWSDDTask)buildWSDDTask, (TaskProvider<Jar>)taskProvider, cleanTaskProvider, deployTaskProvider);
        });
    }

    private void _configureTasksJavaCompileFork(Project project, boolean fork) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JavaCompile.class, javaCompileTask -> this._configureTaskJavaCompileFork((JavaCompile)javaCompileTask, fork));
    }

    private void _configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, testTask -> this._configureTaskTestDefaultCharacterEncoding((Test)testTask));
    }

    private void _configureTaskTestDefaultCharacterEncoding(Test test) {
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private void _configureVersion(Project project) {
        String bundleVersion = BndUtil.getInstruction(project, "Bundle-Version");
        if (Validator.isNotNull((String)bundleVersion)) {
            project.setVersion((Object)bundleVersion);
        }
    }

    private Map<String, String> _getBuilderProperties(Project project, BuildWSDDTask buildWSDDTask) {
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
        Map<String, String> properties = GradleUtil.toStringMap(liferayOSGiExtension.getBundleDefaultInstructions());
        Map projectProperties = project.getProperties();
        for (Map.Entry entry : projectProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!Character.isLowerCase(key.charAt(0))) continue;
            properties.put(key, GradleUtil.toString(entry.getValue()));
        }
        properties.remove("-donotcopy");
        properties.remove("-liferay-service-xml");
        String bundleName = BndUtil.getInstruction(project, "Bundle-Name");
        if (Validator.isNotNull((String)bundleName)) {
            properties.put("Bundle-Name", bundleName + " WSDD descriptors");
        }
        String bundleSymbolicName = BndUtil.getInstruction(project, "Bundle-SymbolicName");
        properties.put("Bundle-SymbolicName", bundleSymbolicName + ".wsdd");
        properties.put("Fragment-Host", bundleSymbolicName);
        properties.put("Import-Package", "javax.servlet,javax.servlet.http");
        StringBuilder sb = new StringBuilder();
        sb.append("WEB-INF/=");
        sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getServerConfigFile()));
        sb.append(',');
        sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getOutputDir()));
        sb.append(";filter:=*.wsdd");
        properties.put("Include-Resource", sb.toString());
        return properties;
    }
}

