/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.AntBuilder;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;

public class LiferayAntPlugin
implements Plugin<Project> {
    private static final String _WAR_TASK_NAME = "war";
    private static final Transformer<String, String> _antTaskNamer = new Transformer<String, String>(){

        public String transform(String targetName) {
            if (targetName.equals("clean") || targetName.equals("install")) {
                targetName = "ant" + StringUtil.capitalize((String)targetName);
            }
            return targetName;
        }
    };

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        AntBuilder antBuilder = project.getAnt();
        antBuilder.importBuild((Object)"build.xml", _antTaskNamer);
        this._configureArchivesBaseName(project, antBuilder);
        this._configureArtifacts(project, antBuilder);
        this._configureVersion(project, antBuilder);
        this._configureAntTask(project, "clean");
    }

    private void _configureAntTask(Project project, String targetName) {
        String antTaskName = (String)_antTaskNamer.transform((Object)targetName);
        if (targetName.equals(antTaskName)) {
            return;
        }
        Task task = GradleUtil.getTask((Project)project, (String)targetName);
        task.dependsOn(new Object[]{antTaskName});
    }

    private void _configureArchivesBaseName(Project project, AntBuilder antBuilder) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        basePluginConvention.setArchivesBaseName(String.valueOf(antBuilder.getProperty("plugin.name")));
    }

    private void _configureArtifacts(final Project project, AntBuilder antBuilder) {
        ArtifactHandler artifacts = project.getArtifacts();
        File pluginFile = project.file(antBuilder.getProperty("plugin.file"));
        artifacts.add("archives", (Object)pluginFile, (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task warTask = GradleUtil.getTask((Project)project, (String)LiferayAntPlugin._WAR_TASK_NAME);
                configurablePublishArtifact.builtBy(new Object[]{warTask});
                configurablePublishArtifact.setName(GradleUtil.getArchivesBaseName(project));
            }
        });
    }

    private void _configureVersion(Project project, AntBuilder antBuilder) {
        project.setVersion(antBuilder.getProperty("plugin.full.version"));
    }
}

