/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;

public class SpotBugsDefaultsPlugin
extends BaseDefaultsPlugin<SpotBugsPlugin> {
    public static final Plugin<Project> INSTANCE = new SpotBugsDefaultsPlugin();
    private static final String _EXCLUDE_XML;
    private static final String _EXCLUDE_XML_FILE_NAME = "spot-bugs-exclude.xml";

    @Override
    protected void configureDefaults(Project project, SpotBugsPlugin spotBugsPlugin) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                SpotBugsDefaultsPlugin.this._configureSpotBugs(project);
            }
        });
    }

    @Override
    protected Class<SpotBugsPlugin> getPluginClass() {
        return SpotBugsPlugin.class;
    }

    private SpotBugsDefaultsPlugin() {
    }

    private void _configureSpotBugs(final Project project) {
        SpotBugsExtension spotBugsExtension = (SpotBugsExtension)GradleUtil.getExtension((ExtensionAware)project, SpotBugsExtension.class);
        RegularFileProperty excludeFilterRegularFileProperty = spotBugsExtension.getExcludeFilter();
        if (excludeFilterRegularFileProperty.isPresent()) {
            return;
        }
        File spotBugsExcludeXmlFile = project.file((Object)_EXCLUDE_XML_FILE_NAME);
        if (!spotBugsExcludeXmlFile.exists()) {
            excludeFilterRegularFileProperty.set(project.provider((Callable)new Callable<RegularFile>(){

                @Override
                public RegularFile call() throws Exception {
                    ProjectLayout projectLayout = project.getLayout();
                    DirectoryProperty directoryProperty = projectLayout.getBuildDirectory();
                    Provider provider = directoryProperty.file(SpotBugsDefaultsPlugin._EXCLUDE_XML_FILE_NAME);
                    RegularFile regularFile = (RegularFile)provider.get();
                    File file = regularFile.getAsFile();
                    Files.write(file.toPath(), _EXCLUDE_XML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    return regularFile;
                }
            }));
        } else {
            excludeFilterRegularFileProperty.set(spotBugsExcludeXmlFile);
        }
    }

    static {
        try {
            _EXCLUDE_XML = FileUtil.read((String)"com/liferay/gradle/plugins/internal/dependencies/spot-bugs-exclude.xml");
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }
}

