/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.db.support.DBSupportPlugin;
import com.liferay.gradle.plugins.db.support.tasks.BaseDBSupportTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class DBSupportDefaultsPlugin
extends BasePortalToolDefaultsPlugin<DBSupportPlugin> {
    public static final Plugin<Project> INSTANCE = new DBSupportDefaultsPlugin();
    private static final String[] _PORTAL_PROPERTIES_FILE_NAMES = new String[]{"portal-setup-wizard.properties", "portal-ext.properties", "portal-bundle.properties"};
    private static final String _PORTAL_TOOL_NAME = "com.liferay.portal.tools.db.support";

    @Override
    protected void configureDefaults(Project project, DBSupportPlugin plugin) {
        super.configureDefaults(project, plugin);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        this._configureConfigurationDBSupport(project, liferayExtension);
        this._configureTasksBaseDBSupport(project, liferayExtension);
    }

    @Override
    protected Class<DBSupportPlugin> getPluginClass() {
        return DBSupportPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "dbSupportTool";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private DBSupportDefaultsPlugin() {
    }

    private void _addDependenciesDBSupport(Project project, LiferayExtension liferayExtension) {
        GradleUtil.addDependency((Project)project, (String)"dbSupport", (FileCollection)FileUtil.getJarsFileTree(project, liferayExtension.getAppServerLibGlobalDir(), new String[0]));
    }

    private void _configureConfigurationDBSupport(final Project project, final LiferayExtension liferayExtension) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"dbSupport");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                DBSupportDefaultsPlugin.this._addDependenciesDBSupport(project, liferayExtension);
            }
        });
    }

    private void _configureTaskBaseDBSupport(BaseDBSupportTask baseDBSupportTask, final LiferayExtension liferayExtension) {
        baseDBSupportTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Properties properties;
                String url;
                BaseDBSupportTask baseDBSupportTask;
                block22: {
                    Properties defaultProperties;
                    File propertiesFile;
                    block21: {
                        baseDBSupportTask = (BaseDBSupportTask)task;
                        propertiesFile = baseDBSupportTask.getPropertiesFile();
                        url = baseDBSupportTask.getUrl();
                        if (propertiesFile != null || Validator.isNotNull((String)url)) {
                            return;
                        }
                        File jarFile = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib/portal-impl.jar");
                        if (!jarFile.exists()) {
                            return;
                        }
                        defaultProperties = null;
                        try {
                            defaultProperties = FileUtil.readPropertiesFromZipFile(jarFile, "portal.properties");
                        }
                        catch (IOException ioException) {
                            Logger logger = baseDBSupportTask.getLogger();
                            if (!logger.isWarnEnabled()) break block21;
                            logger.warn("Unable to read portal.properties file from {}", (Object)jarFile);
                        }
                    }
                    properties = new Properties(defaultProperties);
                    propertiesFile = this._getPortalPropertiesFile();
                    if (propertiesFile != null) {
                        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
                            properties.load(fileInputStream);
                        }
                        catch (IOException ioException) {
                            Logger logger = baseDBSupportTask.getLogger();
                            if (!logger.isWarnEnabled()) break block22;
                            logger.warn("Unable to read properties from {}", (Object)propertiesFile);
                        }
                    }
                }
                url = properties.getProperty("jdbc.default.url");
                url = url.replace("${liferay.home}", FileUtil.getAbsolutePath((File)liferayExtension.getLiferayHome()));
                baseDBSupportTask.setUrl((Object)url);
                if (baseDBSupportTask.getUserName() == null) {
                    baseDBSupportTask.setUserName((Object)properties.getProperty("jdbc.default.username"));
                }
                if (baseDBSupportTask.getPassword() == null) {
                    baseDBSupportTask.setPassword((Object)properties.getProperty("jdbc.default.password"));
                }
            }

            private File _getPortalPropertiesFile() {
                File liferayHome = liferayExtension.getLiferayHome();
                for (String fileName : _PORTAL_PROPERTIES_FILE_NAMES) {
                    File file = new File(liferayHome, fileName);
                    if (!file.exists()) continue;
                    return file;
                }
                return null;
            }
        });
    }

    private void _configureTasksBaseDBSupport(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaseDBSupportTask.class, (Action)new Action<BaseDBSupportTask>(){

            public void execute(BaseDBSupportTask baseDBSupportTask) {
                DBSupportDefaultsPlugin.this._configureTaskBaseDBSupport(baseDBSupportTask, liferayExtension);
            }
        });
    }
}

