/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.gulp.GulpPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.lang.builder.BuildLangTask;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;

public class LiferayThemePlugin
implements Plugin<Project> {
    public static final String CREATE_LIFERAY_THEME_JSON_TASK_NAME = "createLiferayThemeJson";
    private static final String _GULP_BUILD_TASK_NAME = "gulpBuild";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, GulpPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(project);
        this._configureArchivesBaseName(project, packageJsonMap);
        this._configureVersion(project, packageJsonMap);
        project.setBuildDir((Object)"build_gradle");
        Task createLiferayThemeJsonTask = this._addTaskCreateLiferayThemeJson(project, liferayExtension);
        this._configureArtifacts(project);
        this._configureConfigurationDefault(project);
        this._configureTaskBuildLang(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
        this._configureTasksExecuteGulp(createLiferayThemeJsonTask);
    }

    private Task _addTaskCreateLiferayThemeJson(Project project, final LiferayExtension liferayExtension) {
        Task task = project.task(CREATE_LIFERAY_THEME_JSON_TASK_NAME);
        final File liferayThemeJsonFile = project.file((Object)"liferay-theme.json");
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("appServerPath", FileUtil.getAbsolutePath((File)liferayExtension.getAppServerDir()));
                File appServerThemeDir = new File(liferayExtension.getAppServerDeployDir(), project.getName());
                map.put("appServerPathTheme", FileUtil.getAbsolutePath((File)appServerThemeDir));
                map.put("deployed", false);
                map.put("deployPath", FileUtil.getAbsolutePath((File)liferayExtension.getDeployDir()));
                map.put("themeName", project.getName());
                String json = JsonOutput.toJson(Collections.singletonMap("LiferayTheme", map));
                try {
                    Files.write(liferayThemeJsonFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioException) {
                    throw new UncheckedIOException((Throwable)ioException);
                }
            }
        });
        task.setDescription("Generates the " + liferayThemeJsonFile.getName() + " file for this project.");
        return task;
    }

    private void _configureArchivesBaseName(Project project, Map<String, Object> packageJsonMap) {
        String name = null;
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        if (liferayThemeMap != null) {
            name = (String)liferayThemeMap.get("distName");
        }
        if (Validator.isNull(name)) {
            name = (String)packageJsonMap.get("name");
        }
        if (Validator.isNull((String)name)) {
            return;
        }
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        basePluginConvention.setArchivesBaseName(name);
    }

    private void _configureArtifacts(final Project project) {
        ArtifactHandler artifacts = project.getArtifacts();
        File warFile = this._getWarFile(project);
        artifacts.add("archives", (Object)warFile, (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task gulpBuildTask = GradleUtil.getTask((Project)project, (String)LiferayThemePlugin._GULP_BUILD_TASK_NAME);
                if (GradleUtil.hasTask(project, "packageRunBuild")) {
                    gulpBuildTask.finalizedBy(new Object[]{"packageRunBuild"});
                }
                configurablePublishArtifact.builtBy(new Object[]{gulpBuildTask});
            }
        });
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureTaskBuildLang(Project project) {
        BuildLangTask buildLangTask = (BuildLangTask)GradleUtil.getTask((Project)project, (String)"buildLang");
        buildLangTask.setLangDir((Object)"src/WEB-INF/src/content");
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"assemble"});
        copy.from(new Object[]{this._getWarFile(project)});
    }

    private void _configureTaskExecuteGulp(ExecuteGulpTask executeGulpTask, Task createLiferayThemeJsonTask) {
        executeGulpTask.dependsOn(new Object[]{createLiferayThemeJsonTask});
    }

    private void _configureTasksExecuteGulp(final Task createLiferayThemeJsonTask) {
        Project project = createLiferayThemeJsonTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemePlugin.this._configureTaskExecuteGulp(executeGulpTask, createLiferayThemeJsonTask);
            }
        });
    }

    private void _configureVersion(Project project, Map<String, Object> packageJsonMap) {
        String version = (String)packageJsonMap.get("version");
        if (Validator.isNotNull((String)version)) {
            project.setVersion((Object)version);
        }
    }

    private Map<String, Object> _getPackageJsonMap(Project project) {
        File file = project.file((Object)"package.json");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(file);
    }

    private File _getWarFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".war"));
    }
}

