/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.util.BndUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.util.PatternFilterable;

public class JspCDefaultsPlugin
extends BaseDefaultsPlugin<JspCPlugin> {
    public static final String COMPILE_JSP_INCLUDE_PROPERTY_NAME = "compile.jsp.include";
    public static final Plugin<Project> INSTANCE = new JspCDefaultsPlugin();

    @Override
    protected void configureDefaults(Project project, JspCPlugin jspCPlugin) {
        this._configureTaskGenerateJSPJava(project);
        this._configureTaskJar(project);
        this._configureTaskProcessResources(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCDefaultsPlugin.this._configureBundleExtensionDefaults(project);
            }
        });
    }

    @Override
    protected Class<JspCPlugin> getPluginClass() {
        return JspCPlugin.class;
    }

    private JspCDefaultsPlugin() {
    }

    private void _configureBundleExtensionDefaults(Project project) {
        BundleExtension bundleInstructions = BndUtil.getInstructions(project);
        StringBuilder sb = new StringBuilder();
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        sb.append(FileUtil.getAbsolutePath((File)javaCompile.getDestinationDir()));
        sb.append(',');
        CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.getTask((Project)project, (String)"generateJSPJava");
        sb.append(FileUtil.getAbsolutePath((File)compileJSPTask.getDestinationDir()));
        bundleInstructions.put("-add-resource", sb.toString());
    }

    private void _configureTaskGenerateJSPJava(Project project) {
        final CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.getTask((Project)project, (String)"generateJSPJava");
        Copy copy = (Copy)GradleUtil.getTask((Project)compileJSPTask.getProject(), (String)"processResources");
        compileJSPTask.dependsOn(new Object[]{copy});
        compileJSPTask.setWebAppDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)compileJSPTask.getProject(), (String)"main");
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File(sourceSetOutput.getResourcesDir(), "META-INF/resources");
            }
        });
    }

    private void _configureTaskJar(Project project) {
        boolean compileJspInclude = GradleUtil.getProperty((ExtensionAware)project, (String)COMPILE_JSP_INCLUDE_PROPERTY_NAME, (boolean)false);
        if (!compileJspInclude) {
            return;
        }
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        jar.dependsOn(new Object[]{javaCompile});
    }

    private void _configureTaskProcessResources(Project project) {
        File tagsDir;
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
        FileTree fileTree = sourceDirectorySet.getAsFileTree();
        fileTree = fileTree.matching((Action)new Action<PatternFilterable>(){

            public void execute(PatternFilterable patternFilterable) {
                patternFilterable.include(new String[]{"**/*.tld"});
            }
        });
        copy.from((Object)fileTree.getFiles(), (Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.into((Object)"META-INF/resources/WEB-INF");
            }
        });
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        if (iterator.hasNext() && (tagsDir = new File((File)iterator.next(), "META-INF/tags")).exists()) {
            copy.from((Object)tagsDir, (Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.into((Object)"META-INF/resources/META-INF/tags");
                }
            });
        }
    }
}

