/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.TomcatAppServer;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.test.integration.tasks.SetUpTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StartTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StopAppServerTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.ExtensionAware;

public class TestIntegrationDefaultsPlugin
extends BaseDefaultsPlugin<TestIntegrationPlugin> {
    public static final Plugin<Project> INSTANCE = new TestIntegrationDefaultsPlugin();

    @Override
    protected void configureDefaults(Project project, TestIntegrationPlugin testIntegrationPlugin) {
        String portalVersion = PortalTools.getPortalVersion(project);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        TomcatAppServer tomcatAppServer = (TomcatAppServer)liferayExtension.getAppServer("tomcat");
        this._configureTestIntegrationTomcat(project, liferayExtension, tomcatAppServer);
        this._configureConfigurationTestModules(project, portalVersion);
        this._configureTaskCopyTestModules(project);
        this._configureTaskSetUpTestableTomcat(project, tomcatAppServer);
        this._configureTaskStartTestableTomcat(project, tomcatAppServer);
        this._configureTaskStopTestableTomcat(project, tomcatAppServer);
    }

    @Override
    protected Class<TestIntegrationPlugin> getPluginClass() {
        return TestIntegrationPlugin.class;
    }

    private TestIntegrationDefaultsPlugin() {
    }

    private void _addDependenciesTestModules(Project project, String portalVersion) {
        if ("7.0.x".equals(portalVersion) || "7.1.x".equals(portalVersion) || "7.2.x".equals(portalVersion)) {
            GradleUtil.addDependency((Project)project, (String)"testModules", (String)"com.liferay.portal", (String)"com.liferay.portal.test.integration", (String)"3.0.0");
        }
    }

    private void _configureConfigurationTestModules(final Project project, final String portalVersion) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"testModules");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TestIntegrationDefaultsPlugin.this._addDependenciesTestModules(project, portalVersion);
            }
        });
    }

    private void _configureTaskCopyTestModules(Project project) {
        Task copyTestModulesTask = GradleUtil.getTask((Project)project, (String)"copyTestModules");
        GradleUtil.setProperty((ExtensionAware)copyTestModulesTask, (String)"autoClean", (Object)false);
    }

    private void _configureTaskSetUpTestableTomcat(Project project, final TomcatAppServer tomcatAppServer) {
        SetUpTestableTomcatTask setUpTestableTomcatTask = (SetUpTestableTomcatTask)GradleUtil.getTask((Project)project, (String)"setUpTestableTomcat");
        setUpTestableTomcatTask.setJaCoCoAgentConfiguration((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.configuration", (String)null));
        setUpTestableTomcatTask.setJaCoCoAgentFile((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.jar", (String)null));
        setUpTestableTomcatTask.setAspectJAgent((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"aspectj.agent", (String)null));
        setUpTestableTomcatTask.setAspectJConfiguration((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"aspectj.configuration", (String)null));
        setUpTestableTomcatTask.setZipUrl((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getZipUrl();
            }
        });
    }

    private void _configureTaskStartTestableTomcat(Project project, final TomcatAppServer tomcatAppServer) {
        StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)GradleUtil.getTask((Project)project, (String)"startTestableTomcat");
        Object checkTimeout = GradleUtil.getProperty((ExtensionAware)project, (String)"timeout.app.server.wait");
        if (checkTimeout != null) {
            startTestableTomcatTask.setCheckTimeout((long)(GradleUtil.toInteger((Object)checkTimeout) * 1000));
        }
        startTestableTomcatTask.setExecutable((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getStartExecutable();
            }
        });
        startTestableTomcatTask.setExecutableArgs(new Object[]{new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                String argLine = System.getProperty("app.server.start.executable.arg.line");
                if (Validator.isNotNull((String)argLine)) {
                    return Arrays.asList(argLine.split(" "));
                }
                return tomcatAppServer.getStartExecutableArgs();
            }
        }});
    }

    private void _configureTaskStopTestableTomcat(Project project, final TomcatAppServer tomcatAppServer) {
        StopAppServerTask stopAppServerTask = (StopAppServerTask)GradleUtil.getTask((Project)project, (String)"stopTestableTomcat");
        stopAppServerTask.setExecutable((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getStopExecutable();
            }
        });
        stopAppServerTask.setExecutableArgs(new Object[]{new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return tomcatAppServer.getStopExecutableArgs();
            }
        }});
    }

    private void _configureTestIntegrationTomcat(Project project, final LiferayExtension liferayExtension, final TomcatAppServer tomcatAppServer) {
        TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)GradleUtil.getExtension((ExtensionAware)project, TestIntegrationTomcatExtension.class);
        testIntegrationTomcatExtension.setCheckPath((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getCheckPath();
            }
        });
        testIntegrationTomcatExtension.setPortNumber((Object)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return tomcatAppServer.getPortNumber();
            }
        });
        testIntegrationTomcatExtension.setDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return tomcatAppServer.getDir();
            }
        });
        testIntegrationTomcatExtension.setJmxRemotePort((Object)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return liferayExtension.getJmxRemotePort();
            }
        });
        testIntegrationTomcatExtension.setLiferayHome((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getLiferayHome();
            }
        });
        testIntegrationTomcatExtension.setManagerPassword((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getManagerPassword();
            }
        });
        testIntegrationTomcatExtension.setManagerUserName((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getManagerUserName();
            }
        });
    }
}

