/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;

public class LiferayPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "liferay";

    public void apply(final Project project) {
        Class<? extends Plugin<Project>> clazz = this._isAnt(project) ? this.getAntPluginClass() : (this._isOSGi(project) ? this.getOSGiPluginClass() : (this._isTheme(project) ? this.getThemePluginClass() : this.getBasePluginClass()));
        GradleUtil.applyPlugin((Project)project, clazz);
        GradleUtil.withPlugin(project, JavaPlugin.class, new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LiferayPlugin.this._configureJavaExtension(project);
            }
        });
    }

    protected Class<? extends Plugin<Project>> getAntPluginClass() {
        return LiferayAntPlugin.class;
    }

    protected Class<? extends Plugin<Project>> getBasePluginClass() {
        return LiferayBasePlugin.class;
    }

    protected Class<? extends Plugin<Project>> getOSGiPluginClass() {
        return LiferayOSGiPlugin.class;
    }

    protected Class<? extends Plugin<Project>> getThemePluginClass() {
        return LiferayThemePlugin.class;
    }

    private void _configureJavaExtension(Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)GradleUtil.getExtension((ExtensionAware)project, JavaPluginExtension.class);
        javaPluginExtension.disableAutoTargetJvm();
    }

    private boolean _isAnt(Project project) {
        return FileUtil.exists((Project)project, (String)"build.xml");
    }

    private boolean _isOSGi(Project project) {
        return FileUtil.exists((Project)project, (String)"bnd.bnd");
    }

    private boolean _isTheme(Project project) {
        String gulpFileContent;
        File gulpFile = project.file((Object)"gulpfile.js");
        if (!gulpFile.exists()) {
            return false;
        }
        try {
            gulpFileContent = new String(Files.readAllBytes(gulpFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        return gulpFileContent.contains("require('liferay-theme-tasks')");
    }
}

