/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.BuildExtInfoTask;
import groovy.lang.Closure;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;
import org.gradle.util.GUtil;

public class LiferayExtPlugin
implements Plugin<Project> {
    public static final String BUILD_EXT_INFO_BASE_DIR_TASK_NAME = "buildExtInfoBaseDir";
    public static final String BUILD_EXT_INFO_TASK_NAME = "buildExtInfo";
    public static final String EXT_IMPL_SOURCESET_NAME = "extImpl";
    public static final String EXT_KERNEL_SOURCESET_NAME = "extKernel";
    public static final String EXT_UTIL_BRIDGES_SOURCESET_NAME = "extUtilBridges";
    public static final String EXT_UTIL_JAVA_SOURCESET_NAME = "extUtilJava";
    public static final String EXT_UTIL_TAGLIB_SOURCESET_NAME = "extUtilTaglib";

    public void apply(Project project) {
        this._applyPlugins(project);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
        this._configureLiferay(project);
        this._configureTaskDeploy(war);
        Jar extKernelJar = this._addSourceSet(war, warPluginConvention, EXT_KERNEL_SOURCESET_NAME, (FileCollection)portalConfiguration);
        FileCollection compileClasspath = portalConfiguration.plus((FileCollection)project.files(new Object[]{extKernelJar}));
        Jar utilBridgesJar = this._addSourceSet(war, warPluginConvention, EXT_UTIL_BRIDGES_SOURCESET_NAME, compileClasspath);
        compileClasspath = compileClasspath.plus((FileCollection)project.files(new Object[]{utilBridgesJar}));
        Jar utilJavaJar = this._addSourceSet(war, warPluginConvention, EXT_UTIL_JAVA_SOURCESET_NAME, compileClasspath);
        compileClasspath = compileClasspath.plus((FileCollection)project.files(new Object[]{utilJavaJar}));
        Jar utilTaglibJar = this._addSourceSet(war, warPluginConvention, EXT_UTIL_TAGLIB_SOURCESET_NAME, compileClasspath);
        compileClasspath = compileClasspath.plus((FileCollection)project.files(new Object[]{utilTaglibJar}));
        Jar extImplJar = this._addSourceSet(war, warPluginConvention, EXT_IMPL_SOURCESET_NAME, compileClasspath);
        Sync buildExtInfoBaseDirTask = this._addTaskBuildExtInfoBaseDir(war);
        BuildExtInfoTask buildExtInfoTask = this._addTaskBuildExtInfo(buildExtInfoBaseDirTask, war, (FileCollection)portalConfiguration);
        this._configureTaskBuildExtInfoBaseDir(buildExtInfoBaseDirTask, buildExtInfoTask);
        this._configureTaskExtImplJar(extImplJar, utilBridgesJar, utilJavaJar, utilTaglibJar);
        this._configureTaskWar(war, buildExtInfoTask);
    }

    private Jar _addSourceSet(War war, final WarPluginConvention warPluginConvention, String name, FileCollection compileClasspath) {
        Project project = war.getProject();
        SourceSet sourceSet = GradleUtil.addSourceSet((Project)project, (String)name);
        sourceSet.setCompileClasspath(compileClasspath);
        final Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)sourceSet.getJarTaskName(), Jar.class);
        jar.from(new Object[]{sourceSet.getOutput()});
        jar.setAppendix(GUtil.toWords((CharSequence)name, (char)'-'));
        jar.setDescription("Assembles a jar archive containing the " + jar.getAppendix() + " classes.");
        Callable<File> srcDirCallable = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(warPluginConvention.getWebAppDir(), "WEB-INF/" + jar.getAppendix() + "/src");
            }
        };
        SourceDirectorySet javaSourceDirectorySet = sourceSet.getJava();
        javaSourceDirectorySet.srcDir((Object)srcDirCallable);
        SourceDirectorySet resourcesDirectorySet = sourceSet.getResources();
        resourcesDirectorySet.srcDir((Object)srcDirCallable);
        CopySpec copySpec = war.getWebInf();
        copySpec.from(new Object[]{jar});
        copySpec.into((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return jar.getAppendix();
            }
        });
        copySpec.rename((Closure)new Closure<String>((Object)project){

            public String doCall(String fileName) {
                return jar.getAppendix() + "." + jar.getExtension();
            }
        });
        return jar;
    }

    private BuildExtInfoTask _addTaskBuildExtInfo(final Sync buildExtInfoBaseDirTask, final War war, FileCollection classpath) {
        final BuildExtInfoTask buildExtInfoTask = (BuildExtInfoTask)GradleUtil.addTask((Project)buildExtInfoBaseDirTask.getProject(), (String)BUILD_EXT_INFO_TASK_NAME, BuildExtInfoTask.class);
        buildExtInfoTask.dependsOn(new Object[]{buildExtInfoBaseDirTask});
        buildExtInfoTask.setBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(buildExtInfoBaseDirTask.getDestinationDir(), "WEB-INF");
            }
        });
        buildExtInfoTask.setClasspath(classpath);
        buildExtInfoTask.setDescription("Generates the ext information xml file.");
        buildExtInfoTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildExtInfoTask.getTemporaryDir();
            }
        });
        buildExtInfoTask.setServletContextName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String servletContextName = war.getBaseName();
                String appendix = war.getAppendix();
                if (appendix != null) {
                    servletContextName = servletContextName + "-" + appendix;
                }
                return servletContextName;
            }
        });
        return buildExtInfoTask;
    }

    private Sync _addTaskBuildExtInfoBaseDir(War war) {
        final Project project = war.getProject();
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)BUILD_EXT_INFO_BASE_DIR_TASK_NAME, Sync.class);
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "build-ext-info");
            }
        });
        sync.setDescription("Copies the exploded war archive into a temporary directory.");
        sync.with(new CopySpec[]{war});
        return sync;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
    }

    private void _configureLiferay(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(liferayExtension.getAppServerParentDir(), "deploy");
            }
        });
    }

    private void _configureTaskBuildExtInfoBaseDir(Sync buildExtInfoBaseDirTask, final BuildExtInfoTask buildExtInfoTask) {
        buildExtInfoBaseDirTask.exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement fileTreeElement) {
                File outputFile = buildExtInfoTask.getOutputFile();
                String outputFileName = outputFile.getName();
                return outputFileName.equals(fileTreeElement.getPath());
            }
        });
    }

    private void _configureTaskDeploy(War war) {
        Copy copy = (Copy)GradleUtil.getTask((Project)war.getProject(), (String)"deploy");
        copy.from(new Object[]{war});
    }

    private void _configureTaskExtImplJar(Jar extImplJar, Jar ... jars) {
        Project project = extImplJar.getProject();
        for (final Jar jar : jars) {
            extImplJar.into((Object)"com/liferay/portal/deploy/dependencies", (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{jar});
                    copySpec.rename((Closure)new PortalDeployDependencyRenameClosure(jar));
                }
            });
        }
    }

    private void _configureTaskWar(War war, final BuildExtInfoTask buildExtInfoTask) {
        Project project = war.getProject();
        String name = project.getName();
        if (!name.endsWith("-ext")) {
            war.setAppendix("ext");
        }
        CopySpec copySpec = war.getWebInf();
        war.dependsOn(new Object[]{buildExtInfoTask});
        copySpec.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildExtInfoTask.getOutputFile();
            }
        }});
    }

    private static class PortalDeployDependencyRenameClosure
    extends Closure<String> {
        private final Jar _jar;

        public PortalDeployDependencyRenameClosure(Jar jar) {
            super((Object)jar.getProject());
            this._jar = jar;
        }

        public String doCall(String fileName) {
            Project project = this._jar.getProject();
            StringBuilder sb = new StringBuilder();
            sb.append("ext-");
            sb.append(project.getName());
            sb.append('-');
            sb.append(this._jar.getAppendix());
            sb.append('.');
            sb.append(this._jar.getExtension());
            return sb.toString();
        }
    }
}

